/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.commands;

import com.google.inject.Inject;
import dev.dejvokep.boostedyaml.YamlDocument;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.World;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionState;
import org.reprogle.dimensionpause.store.Database;

public class CommandFeedback {
    public static final MiniMessage mm = MiniMessage.miniMessage();
    @Inject
    private ConfigManager configManager;
    @Inject
    private DimensionState state;

    public Component getChatPrefix() {
        return mm.deserialize((Object)Objects.requireNonNull(this.configManager.getLanguageFile().getString("prefix")));
    }

    public Component sendCommandFeedback(String feedback, @Nullable String world, @Nullable String dimension) {
        BuildableComponent feedbackMessage;
        Component chatPrefix = this.getChatPrefix();
        YamlDocument languageFile = this.configManager.getLanguageFile();
        World.Environment environment = null;
        if (dimension != null && (dimension.equalsIgnoreCase("end") || dimension.equalsIgnoreCase("nether"))) {
            environment = dimension.equalsIgnoreCase("nether") ? World.Environment.NETHER : World.Environment.THE_END;
        }
        switch (feedback.toLowerCase()) {
            case "usage": {
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\n \n \n \n \n \n-----------------------\n \n").color((TextColor)NamedTextColor.WHITE)).append(chatPrefix)).append((Component)Component.text((String)" "))).append((Component)Component.text((String)"Need help?\n \n", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"  /dimensionpause ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"toggle [end | nether] \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"  /dimensionpause ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"state [end | nether] \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"  /dimensionpause ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"reload \n \n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"-----------------------", (TextColor)NamedTextColor.WHITE))).build();
                break;
            }
            case "nopermission": {
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("no-permission")))).build();
                break;
            }
            case "reload": {
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("reload")))).build();
                break;
            }
            case "io-exception": {
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("io-exception")))).build();
                break;
            }
            case "newstate": {
                Component pausedComponent = mm.deserialize((Object)languageFile.getString("state.paused"));
                Component unpausedComponent = mm.deserialize((Object)languageFile.getString("state.unpaused"));
                if (environment == null) {
                    feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("toggled.default")))).build();
                    break;
                }
                Database.WorldPauseStatus worldState = this.state.getState(world, environment);
                TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("toggled." + dimension)))).append(!worldState.enabled() ? pausedComponent : unpausedComponent);
                if (worldState.expiresAt() != null) {
                    Component untilComponent = mm.deserialize((Object)languageFile.getString("state.until"));
                    ((TextComponent.Builder)((TextComponent.Builder)builder.append(untilComponent)).append((Component)Component.text((String)worldState.expiresAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))))).append((Component)Component.text((String)" UTC"));
                }
                feedbackMessage = builder.build();
                break;
            }
            case "state": {
                Component pausedComponent = mm.deserialize((Object)languageFile.getString("state.paused"));
                Component unpausedComponent = mm.deserialize((Object)languageFile.getString("state.unpaused"));
                if (environment == null) {
                    return Component.empty();
                }
                Database.WorldPauseStatus worldState = this.state.getState(world, environment);
                TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("state." + dimension)))).append(!worldState.enabled() ? pausedComponent : unpausedComponent);
                if (worldState.expiresAt() != null) {
                    Component untilComponent = mm.deserialize((Object)languageFile.getString("state.until"));
                    ((TextComponent.Builder)((TextComponent.Builder)builder.append(untilComponent)).append((Component)Component.text((String)worldState.expiresAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))))).append((Component)Component.text((String)" UTC"));
                }
                feedbackMessage = builder.build();
                break;
            }
            default: {
                feedbackMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(chatPrefix)).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)languageFile.getString("unknown-error")))).build();
            }
        }
        return feedbackMessage;
    }

    public Title getTitleForDimension(World.Environment env) {
        String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        BuildableComponent mainTitle = ((TextComponent.Builder)Component.text().append(mm.deserialize((Object)this.configManager.getPluginConfig().getString("dimensions." + environment + ".alert.title.title")))).build();
        BuildableComponent subtitle = ((TextComponent.Builder)Component.text().append(mm.deserialize((Object)this.configManager.getPluginConfig().getString("dimensions." + environment + ".alert.title.subtitle")))).build();
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L));
        return Title.title((Component)mainTitle, (Component)subtitle, (Title.Times)times);
    }

    public Component getChatForDimension(World.Environment env) {
        String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.getChatPrefix())).append(mm.deserialize((Object)this.configManager.getPluginConfig().getString("dimensions." + environment + ".alert.chat.message")))).build();
    }

    public Component getToggleMessageForDimension(World world, World.Environment env, boolean newState) {
        return this.getToggleMessageForDimension(world.getName(), env, newState);
    }

    public Component getToggleMessageForDimension(String world, World.Environment env, boolean newState) {
        String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        String stateParsed = newState ? "<red>paused</red>" : "<green>unpaused</green>";
        String worldFmtd = "<blue>" + world + "<reset>";
        String preparsedText = this.configManager.getPluginConfig().getString("dimensions." + environment + ".alert.on-toggle.message").replace("%world%", worldFmtd).replace("%state%", stateParsed);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.getChatPrefix())).append((Component)Component.text((String)" "))).append(mm.deserialize((Object)preparsedText))).build();
    }
}

