/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.store.Database;
import org.reprogle.dimensionpause.store.SQLite;

@Singleton
public class DimensionState {
    public final Set<UUID> alertPlayers = new HashSet<UUID>();
    @Inject
    private ConfigManager configManager;
    @Inject
    private DimensionPausePlugin plugin;
    @Inject
    private CommandFeedback commandFeedback;
    @Inject
    private SQLite db;

    public void toggleDimension(World world, World.Environment dimension, @Nullable LocalDate expirationTime) {
        this.toggleDimension(world.getName(), dimension, expirationTime);
    }

    public void toggleDimension(String world, World.Environment dimension, @Nullable LocalDate expirationTime) {
        Collection players = this.plugin.getServer().getOnlinePlayers();
        boolean worldDimensionEnabled = this.db.isWorldEnabled(world, dimension).enabled();
        this.db.setWorld(world, dimension, !worldDimensionEnabled, expirationTime);
        this.alertOfStateChange(players, world, dimension, !worldDimensionEnabled);
        if (!worldDimensionEnabled) {
            boolean bypassable = this.configManager.getPluginConfig().getBoolean("dimensions." + (dimension.equals((Object)World.Environment.NETHER) ? "nether" : "end") + ".bypassable");
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getWorld().getEnvironment().equals((Object)dimension) || this.canBypass(player, bypassable)) continue;
                this.kickToWorld(player, dimension, true);
            }
        }
    }

    @Nullable
    public Location kickToWorld(Player player, World.Environment dimension, boolean teleport) {
        Location loc = player.getRespawnLocation();
        if (this.configManager.getPluginConfig().getBoolean("try-bed-first").booleanValue() && loc != null) {
            if (teleport) {
                player.teleportAsync(loc);
            }
        } else {
            World world = Bukkit.getWorld((String)this.configManager.getPluginConfig().getString("kick-world"));
            if (world == null) {
                this.plugin.getLogger().log(Level.WARNING, "IMPORTANT MESSAGE! A world has been paused, but at least one player is still in it ({0}). This player doesn't have a valid respawn location, and the kick-world configured in config was not obtainable, so we cannot teleport players out of the world. Please intervene!", player.getName());
                return null;
            }
            if (teleport) {
                player.teleportAsync(world.getSpawnLocation());
            }
            loc = world.getSpawnLocation();
        }
        if (teleport) {
            this.alertPlayer(player, dimension);
        }
        return loc;
    }

    public Database.WorldPauseStatus getState(World world, World.Environment dimension) {
        return this.getState(world.getName(), dimension);
    }

    public Database.WorldPauseStatus getState(String world, World.Environment dimension) {
        return this.db.isWorldEnabled(world, dimension);
    }

    public boolean canBypass(Player player, boolean bypassableFlag) {
        if (player.isOp()) {
            return true;
        }
        if (!bypassableFlag) {
            return false;
        }
        return player.hasPermission("dimensionpause.bypass");
    }

    public void alertPlayer(Player player, World.Environment dimension) {
        String env = dimension.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        boolean sendTitle = this.configManager.getPluginConfig().getBoolean("dimensions." + env + ".alert.title.enabled");
        boolean sendChat = this.configManager.getPluginConfig().getBoolean("dimensions." + env + ".alert.chat.enabled");
        if (sendTitle) {
            player.showTitle(this.commandFeedback.getTitleForDimension(dimension));
        }
        if (sendChat) {
            player.sendMessage(this.commandFeedback.getChatForDimension(dimension));
        }
    }

    private void alertOfStateChange(Collection<? extends Player> players, String world, World.Environment environment, boolean newState) {
        String env;
        String string = env = environment.equals((Object)World.Environment.NETHER) ? "nether" : "end";
        if (!this.configManager.getPluginConfig().getBoolean("dimensions." + env + ".alert.on-toggle.enabled").booleanValue()) {
            return;
        }
        for (Player player : players) {
            player.sendMessage(this.commandFeedback.getToggleMessageForDimension(world, environment, newState));
        }
    }
}

