/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.store;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.store.Database;
import org.reprogle.dimensionpause.store.patches.SQLitePatch;

@Singleton
public class SQLite
extends Database {
    private final DimensionPausePlugin plugin;
    private final Logger logger;
    private final List<SQLitePatch> patches = new ArrayList<SQLitePatch>();
    private final int DB_VERSION = 1;
    private final String SQLITE_CREATE_WORLDS_TABLE = "CREATE TABLE IF NOT EXISTS dimensionpause_worlds (`world` VARCHAR NOT NULL,`dimension` VARCHAR NOT NULL,`enabled` INTEGER NOT NULL,`updatedAt` DATE NOT NULL,`expiresAt` DATE NULL,PRIMARY KEY (`world`, `dimension`))";
    private final String SET_PRAGMA = "PRAGMA user_version = 1;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public SQLite(DimensionPausePlugin plugin, Logger logger) {
        super(plugin);
        Statement s;
        this.logger = logger;
        this.plugin = plugin;
        this.connection = this.getSQLConnection();
        try {
            s = this.connection.createStatement();
            try {
                PreparedStatement ps = this.connection.prepareStatement("PRAGMA user_version;");
                ResultSet rs = ps.executeQuery();
                int userVersion = rs.getInt("user_version");
                boolean upgradeNecessary = this.checkIfUpgradeNecessary(this.connection, userVersion);
                if (!upgradeNecessary) {
                    s.executeUpdate("CREATE TABLE IF NOT EXISTS dimensionpause_worlds (`world` VARCHAR NOT NULL,`dimension` VARCHAR NOT NULL,`enabled` INTEGER NOT NULL,`updatedAt` DATE NOT NULL,`expiresAt` DATE NULL,PRIMARY KEY (`world`, `dimension`))");
                } else {
                    for (SQLitePatch patch : this.patches) {
                        if (!this.connection.isClosed()) {
                            this.connection.close();
                        }
                        if (userVersion >= patch.patchedIn()) continue;
                        this.connection = this.getSQLConnection();
                        patch.update(this.connection, logger);
                    }
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (SQLException e) {
            logger.severe("SQLException occurred while creating SQLite connection: " + e.getMessage());
            logger.severe("Full stack" + Arrays.toString(e.getStackTrace()));
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.severe("Failed to close SQLite Connection: " + String.valueOf(e));
            }
        }
        this.connection = this.getSQLConnection();
        try {
            s = this.connection.createStatement();
            try {
                s.executeUpdate("PRAGMA user_version = 1;");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (SQLException e) {
            logger.severe("SQLException occurred while creating SQLite connection: " + e.getMessage());
            logger.severe("Full stack" + Arrays.toString(e.getStackTrace()));
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.severe("Failed to close SQLite Connection: " + String.valueOf(e));
            }
        }
    }

    @Override
    public Connection getSQLConnection() {
        File dataFolder = new File(this.plugin.getDataFolder(), "dimensionpause.db");
        if (!dataFolder.exists()) {
            try {
                boolean success = dataFolder.createNewFile();
                if (success) {
                    this.logger.info("Created data folder");
                } else {
                    this.logger.severe("Could not create data folder!");
                }
            }
            catch (IOException e) {
                this.logger.severe("Could not create dimensionpause.db file");
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dataFolder));
            return this.connection;
        }
        catch (SQLException e) {
            this.logger.severe("SQLite exception on initialize: " + String.valueOf(e));
        }
        catch (ClassNotFoundException e) {
            this.logger.severe("SQLite JDBC Library not found. Please install this on your host to use SQLite: " + String.valueOf(e));
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        return null;
    }

    public boolean checkIfUpgradeNecessary(Connection connection, int userVersion) {
        boolean tablesExist;
        boolean alreadyInitialized = userVersion >= 1;
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT name FROM sqlite_master WHERE type='table' AND name NOT LIKE 'sqlite_%';");
            ResultSet rs = ps.executeQuery();
            tablesExist = rs.next();
        }
        catch (SQLException e) {
            tablesExist = false;
        }
        return !alreadyInitialized && tablesExist;
    }
}

