/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import com.google.inject.Inject;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionState;
import org.reprogle.dimensionpause.commands.CommandFeedback;

public class PortalCreateEventListener
implements Listener {
    @Inject
    DimensionState state;
    @Inject
    ConfigManager configManager;
    @Inject
    CommandFeedback commandFeedback;

    @EventHandler
    public void onPortalCreateEvent(PortalCreateEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (p.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return;
        }
        if (this.state.getState(p.getWorld(), World.Environment.NETHER).enabled()) {
            return;
        }
        if (event.getReason().equals((Object)PortalCreateEvent.CreateReason.FIRE)) {
            boolean bypassable = this.configManager.getPluginConfig().getBoolean("dimensions.nether.bypassable");
            if (this.state.canBypass(p, bypassable)) {
                return;
            }
            event.setCancelled(true);
            boolean sendTitle = this.configManager.getPluginConfig().getBoolean("dimensions.nether.alert.title.enabled");
            boolean sendChat = this.configManager.getPluginConfig().getBoolean("dimensions.nether.alert.chat.enabled");
            if (sendTitle) {
                p.showTitle(this.commandFeedback.getTitleForDimension(World.Environment.NETHER));
            }
            if (sendChat) {
                p.sendMessage(this.commandFeedback.getChatForDimension(World.Environment.NETHER));
            }
        }
    }
}

