/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.commands.CommandFeedback;

public class PortalCreateEventListener
implements Listener {
    @EventHandler
    public static void onPortalCreateEvent(PortalCreateEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!DimensionPausePlugin.ds.getState(World.Environment.NETHER)) {
            return;
        }
        if (event.getReason().equals((Object)PortalCreateEvent.CreateReason.FIRE)) {
            boolean bypassable = ConfigManager.getPluginConfig().getBoolean("dimensions.nether.bypassable");
            if (DimensionPausePlugin.ds.getState(World.Environment.NETHER)) {
                if (DimensionPausePlugin.ds.canBypass(p, bypassable)) {
                    return;
                }
                event.setCancelled(true);
                boolean sendTitle = ConfigManager.getPluginConfig().getBoolean("dimensions.nether.alert.title.enabled");
                boolean sendChat = ConfigManager.getPluginConfig().getBoolean("dimensions.nether.alert.chat.enabled");
                if (sendTitle) {
                    p.showTitle(CommandFeedback.getTitleForDimension(World.Environment.NETHER));
                }
                if (sendChat) {
                    p.sendMessage(CommandFeedback.getChatForDimension(World.Environment.NETHER));
                }
            }
        }
    }
}

