/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.commands.CommandFeedback;

public class EntityPortalEnterEventListener
implements Listener {
    private final Set<UUID> playersBeingHandled = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onNetherPortalEnter(EntityPortalEnterEvent event) {
        double newVecZ;
        double newVecX;
        Player p;
        block11: {
            block10: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block10;
                p = (Player)entity;
                if (ConfigManager.getPluginConfig().getBoolean("dimensions.nether.bounce-back").booleanValue() && DimensionPausePlugin.ds.getState(World.Environment.NETHER)) break block11;
            }
            return;
        }
        Location currentLocation = event.getLocation().set((double)event.getLocation().getBlockX(), (double)event.getLocation().getBlockY(), (double)event.getLocation().getBlockZ());
        if (currentLocation.getBlock().getType() != Material.NETHER_PORTAL) {
            return;
        }
        if (DimensionPausePlugin.ds.canBypass(p, ConfigManager.getPluginConfig().getBoolean("dimensions.nether.bypassable"))) {
            return;
        }
        if (this.playersBeingHandled.contains(p.getUniqueId())) {
            return;
        }
        this.playersBeingHandled.add(p.getUniqueId());
        double strength = 1.0;
        Block block = currentLocation.getBlock();
        if (block.getRelative(BlockFace.WEST).getType() == Material.NETHER_PORTAL || block.getRelative(BlockFace.EAST).getType() == Material.NETHER_PORTAL) {
            newVecX = 0.0;
            newVecZ = p.getLocation().getZ() < block.getLocation().getZ() + 0.5 ? -1.0 * strength : 1.0 * strength;
        } else {
            newVecZ = 0.0;
            newVecX = p.getLocation().getX() < block.getLocation().getX() + 0.5 ? -1.0 * strength : 1.0 * strength;
        }
        DimensionPausePlugin.plugin.getServer().getScheduler().runTaskLater((Plugin)DimensionPausePlugin.plugin, () -> {
            p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 200, 5, false, false));
            p.setVelocity(new Vector(newVecX, 0.7, newVecZ));
            this.playersBeingHandled.remove(p.getUniqueId());
        }, 1L);
        boolean sendTitle = ConfigManager.getPluginConfig().getBoolean("dimensions.nether.alert.title.enabled");
        boolean sendChat = ConfigManager.getPluginConfig().getBoolean("dimensions.nether.alert.chat.enabled");
        if (sendTitle) {
            p.showTitle(CommandFeedback.getTitleForDimension(World.Environment.NETHER));
        }
        if (sendChat) {
            p.sendMessage(CommandFeedback.getChatForDimension(World.Environment.NETHER));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEndPortalEnter(EntityPortalEnterEvent event) {
        Player p;
        block9: {
            block8: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block8;
                p = (Player)entity;
                if (ConfigManager.getPluginConfig().getBoolean("dimensions.end.bounce-back").booleanValue() && DimensionPausePlugin.ds.getState(World.Environment.THE_END)) break block9;
            }
            return;
        }
        Location currentLocation = event.getLocation().set((double)event.getLocation().getBlockX(), (double)event.getLocation().getBlockY(), (double)event.getLocation().getBlockZ());
        if (currentLocation.getBlock().getType() != Material.END_PORTAL) {
            return;
        }
        if (DimensionPausePlugin.ds.canBypass(p, ConfigManager.getPluginConfig().getBoolean("dimensions.end.bypassable"))) {
            return;
        }
        if (this.playersBeingHandled.contains(p.getUniqueId())) {
            return;
        }
        this.playersBeingHandled.add(p.getUniqueId());
        float yaw = p.getLocation().getYaw();
        double radians = Math.toRadians(yaw);
        double x = Math.sin(radians);
        double z = -Math.cos(radians);
        Vector knockbackDirection = new Vector(x, 0.7, z);
        knockbackDirection.multiply(0.7);
        p.setVelocity(knockbackDirection);
        DimensionPausePlugin.plugin.getServer().getScheduler().runTaskLater((Plugin)DimensionPausePlugin.plugin, () -> {
            p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 200, 5, false, false));
            this.playersBeingHandled.remove(p.getUniqueId());
        }, 5L);
        boolean sendTitle = ConfigManager.getPluginConfig().getBoolean("dimensions.end.alert.title.enabled");
        boolean sendChat = ConfigManager.getPluginConfig().getBoolean("dimensions.end.alert.chat.enabled");
        if (sendTitle) {
            p.showTitle(CommandFeedback.getTitleForDimension(World.Environment.THE_END));
        }
        if (sendChat) {
            p.sendMessage(CommandFeedback.getChatForDimension(World.Environment.THE_END));
        }
    }

    @EventHandler
    public void onPlayerDamageEvent(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (this.playersBeingHandled.contains(p.getUniqueId())) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 10, 5, false, false));
        }
    }
}

