/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reprogle.dimensionpause.commands.CommandFeedback;
import org.reprogle.dimensionpause.commands.SubCommand;
import org.reprogle.dimensionpause.commands.subcommands.Reload;
import org.reprogle.dimensionpause.commands.subcommands.State;
import org.reprogle.dimensionpause.commands.subcommands.Toggle;

public class CommandManager
implements TabExecutor {
    private final ArrayList<SubCommand> subcommands = new ArrayList();

    public CommandManager() {
        this.subcommands.add(new Toggle());
        this.subcommands.add(new Reload());
        this.subcommands.add(new State());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!sender.hasPermission("dimensionpause.commands")) {
            sender.sendMessage(CommandFeedback.sendCommandFeedback("nopermission", new String[0]));
            return false;
        }
        if (args.length > 0) {
            for (SubCommand subcommand : this.subcommands) {
                if (!args[0].equalsIgnoreCase(subcommand.getName())) continue;
                if (!this.checkPermissions(sender, subcommand)) {
                    sender.sendMessage(CommandFeedback.sendCommandFeedback("nopermission", new String[0]));
                    return false;
                }
                subcommand.perform(sender, args);
                return true;
            }
            sender.sendMessage(CommandFeedback.sendCommandFeedback("usage", new String[0]));
        } else {
            sender.sendMessage(CommandFeedback.sendCommandFeedback("usage", new String[0]));
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!sender.hasPermission("dimensionpause.commands") && !sender.isOp()) {
            return null;
        }
        if (args.length == 1) {
            ArrayList<String> subcommandsTabComplete = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], List.of((String[])this.subcommands.stream().map(SubCommand::getName).toArray(String[]::new)), subcommandsTabComplete);
            return subcommandsTabComplete;
        }
        if (args.length >= 2) {
            for (SubCommand subcommand : this.subcommands) {
                if (!args[0].equalsIgnoreCase(subcommand.getName())) continue;
                ArrayList<String> subcommandsTabComplete = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[args.length - 1], subcommand.getSubcommands(sender, args), subcommandsTabComplete);
                return subcommandsTabComplete;
            }
        }
        return null;
    }

    private boolean checkPermissions(CommandSender sender, SubCommand subcommand) {
        boolean allowed = false;
        if (subcommand.getRequiredPermissions().isEmpty()) {
            return true;
        }
        for (String permission : subcommand.getRequiredPermissions()) {
            if (!sender.hasPermission(permission)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }
}

