/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private static YamlDocument config;
    private static YamlDocument languageFile;
    private static final List<String> languages;

    public static void setupConfig(Plugin plugin) {
        plugin.getLogger().info("Attempting to load config files...");
        try {
            config = YamlDocument.create((File)new File(plugin.getDataFolder(), "config.yml"), (InputStream)plugin.getResource("config.yml"), (GeneralSettings)GeneralSettings.DEFAULT, (LoaderSettings)LoaderSettings.builder().setAutoUpdate(true).build(), (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("file-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build());
            config.update();
            config.save();
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not create/load plugin config, disabling! Please alert the plugin author with the following info: " + String.valueOf(e));
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
        String language = config.getString("language");
        if (!languages.contains(language) && Boolean.FALSE.equals(config.getBoolean("bypass-language-check"))) {
            plugin.getLogger().warning("Language is currently set to " + language + ". This language is currently not supported, defaulting to en_US.");
            language = "en_US";
        }
        try {
            languageFile = YamlDocument.create((File)new File(new File(plugin.getDataFolder(), "lang"), language + ".yml"), (InputStream)plugin.getResource("lang/" + language + ".yml"), (GeneralSettings)GeneralSettings.DEFAULT, (LoaderSettings)LoaderSettings.builder().setAutoUpdate(true).build(), (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("language-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build());
            languageFile.update();
            languageFile.save();
            plugin.getLogger().info("Language set to: " + language);
        }
        catch (IOException e) {
            plugin.getLogger().severe("Could not load language file, disabling! Please alert the plugin author with the following info:" + String.valueOf(e));
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
        plugin.getLogger().info("Successfully loaded all plugin config files!");
    }

    public static YamlDocument getPluginConfig() {
        return config;
    }

    public static YamlDocument getLanguageFile() {
        return languageFile;
    }

    static {
        languages = List.of("en_US");
    }
}

