/*
 * Decompiled with CFR 0.152.
 */
package me.telesphoreo.listener;

import java.util.Map;
import me.telesphoreo.util.LoginMessagesBase;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class PermissionLoginMessages
extends LoginMessagesBase
implements Listener {
    private boolean hasPermission(Player player, String permission) {
        Permission p = new Permission(permission, PermissionDefault.FALSE);
        return player.hasPermission(p);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        try {
            Map login_messages = this.plugin.getConfig().getConfigurationSection("ranks").getValues(false);
            Map player_login_messages = this.plugin.getConfig().getConfigurationSection("players").getValues(false);
            boolean vanilla_join_msg = this.plugin.getConfig().getBoolean("show_vanilla_messages");
            for (String key : login_messages.keySet()) {
                MemorySection login = (MemorySection)login_messages.get(key);
                String permission = login.getString("permission");
                String message = login.getString("message");
                if (!this.hasPermission(player, permission) || player_login_messages.keySet().contains(player.getName())) continue;
                if (message == null) {
                    this.logger.severe("There is no message set!");
                } else if (!vanilla_join_msg) {
                    event.joinMessage(this.plugin.mmDeserialize(message.replace("%player%", player.getName())));
                } else {
                    Bukkit.broadcast((Component)this.plugin.mmDeserialize(message.replace("%player%", player.getName())));
                }
                break;
            }
        }
        catch (ClassCastException ex) {
            this.logger.severe("Failed to load login messages.");
            this.logger.severe(ex.toString());
        }
    }
}

