/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.validator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLValidator {
    private final FileConfiguration defaultConfig;
    private final FileConfiguration targetConfig;
    private final File targetFile;
    private final Set<String> filteredSubtrees;

    public YAMLValidator(String resourceFileName, File targetFile) {
        this.defaultConfig = this.loadResourceConfig(resourceFileName);
        this.targetFile = targetFile;
        this.targetConfig = YamlConfiguration.loadConfiguration((File)targetFile);
        this.filteredSubtrees = Collections.emptySet();
    }

    public YAMLValidator(String resourceFileName, File targetFile, Set<String> filteredSubtrees) {
        this.defaultConfig = this.loadResourceConfig(resourceFileName);
        this.targetFile = targetFile;
        this.targetConfig = YamlConfiguration.loadConfiguration((File)targetFile);
        this.filteredSubtrees = filteredSubtrees;
    }

    public YAMLValidator(String resourceFileName, String targetFileName, Set<String> filteredSubtrees) {
        File targetFile;
        this.defaultConfig = this.loadResourceConfig(resourceFileName);
        this.targetFile = targetFile = new File(targetFileName);
        this.targetConfig = YamlConfiguration.loadConfiguration((File)targetFile);
        this.filteredSubtrees = filteredSubtrees;
    }

    private FileConfiguration loadResourceConfig(String resourceFileName) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceFileName);
        if (inputStream == null) {
            throw new RuntimeException("Resource file '" + resourceFileName + "' is missing in plugin resources");
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
    }

    public boolean validate() {
        return this.checkKeys((ConfigurationSection)this.defaultConfig, (ConfigurationSection)this.targetConfig, "");
    }

    private boolean checkKeys(ConfigurationSection defaultSection, ConfigurationSection targetSection, String path) {
        if (defaultSection == null) {
            return true;
        }
        if (this.filteredSubtrees.contains(path)) {
            return true;
        }
        Set keys = defaultSection.getKeys(false);
        boolean allKeysPresent = true;
        for (String key : keys) {
            ConfigurationSection targetSubSection;
            ConfigurationSection defaultSubSection;
            Object fullPath = path.isEmpty() ? key : path + "." + key;
            if (this.filteredSubtrees.contains(fullPath)) continue;
            if (targetSection == null || !targetSection.contains(key)) {
                allKeysPresent = false;
            }
            if (!defaultSection.isConfigurationSection(key) || this.checkKeys(defaultSubSection = defaultSection.getConfigurationSection(key), targetSubSection = targetSection != null ? targetSection.getConfigurationSection(key) : null, (String)fullPath)) continue;
            allKeysPresent = false;
        }
        return allKeysPresent;
    }

    public void fix() throws IOException {
        this.fixKeys((ConfigurationSection)this.defaultConfig, (ConfigurationSection)this.targetConfig, "");
        this.targetConfig.save(this.targetFile);
    }

    private void fixKeys(ConfigurationSection defaultSection, ConfigurationSection targetSection, String path) {
        if (defaultSection == null) {
            return;
        }
        if (this.filteredSubtrees.contains(path)) {
            return;
        }
        Set keys = defaultSection.getKeys(false);
        for (String key : keys) {
            Object fullPath = path.isEmpty() ? key : path + "." + key;
            if (this.filteredSubtrees.contains(fullPath)) continue;
            if (!targetSection.contains(key)) {
                targetSection.set(key, defaultSection.get(key));
            }
            if (!defaultSection.isConfigurationSection(key)) continue;
            ConfigurationSection defaultSubSection = defaultSection.getConfigurationSection(key);
            ConfigurationSection targetSubSection = targetSection.getConfigurationSection(key);
            if (targetSubSection == null) {
                targetSubSection = targetSection.createSection(key);
            }
            this.fixKeys(defaultSubSection, targetSubSection, (String)fullPath);
        }
    }
}

