/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class DelayedTeleport {
    public static ConcurrentHashMap<UUID, BukkitTask> tasks = new ConcurrentHashMap();
    public static ConcurrentHashMap<UUID, Location> initialLocations = new ConcurrentHashMap();

    public DelayedTeleport(Player player, Location location) {
        UUID playerId = player.getUniqueId();
        if (tasks.containsKey(playerId)) {
            DelayedTeleport.cancelTeleport(playerId);
            return;
        }
        boolean delayedTeleportEnabled = Homestead.config.getBoolean("delayed-teleport.enabled");
        if (!delayedTeleportEnabled) {
            this.teleportPlayer(player, location);
            return;
        }
        boolean ignoreOperators = Homestead.config.getBoolean("delayed-teleport.ignore-operators");
        if (ignoreOperators && PlayerUtils.isOperator(player)) {
            this.teleportPlayer(player, location);
            return;
        }
        PlayerUtils.sendMessage(player, 53);
        int delay = Homestead.config.getInt("delayed-teleport.delay");
        initialLocations.put(playerId, player.getLocation().clone());
        BukkitTask task = Homestead.getInstance().runSyncTaskLater(() -> {
            tasks.remove(playerId);
            initialLocations.remove(playerId);
            this.teleportPlayer(player, location);
        }, delay);
        tasks.put(playerId, task);
    }

    public static void cancelTeleport(UUID playerId) {
        BukkitTask task = tasks.get(playerId);
        if (task != null) {
            task.cancel();
            tasks.remove(playerId);
            initialLocations.remove(playerId);
        }
    }

    private void teleportPlayer(Player player, Location location) {
        if (location == null) {
            PlayerUtils.sendMessage(player, 52);
            return;
        }
        player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 500.0f, 1.0f);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{location}", Formatters.formatLocation(location));
        PlayerUtils.sendMessage(player, 51, replacements);
    }
}

