/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.rewards;

import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.structure.Region;

public class Rewards {
    public static int getChunksByEachMember(Region region) {
        if (!Homestead.config.isRewardsEnabled()) {
            return 0;
        }
        int chunksPerMember = Homestead.config.getInt("rewards.for-each-member.chunks");
        return region.getMembers().size() * chunksPerMember;
    }

    public static int getSubAreasByEachMember(Region region) {
        if (!Homestead.config.isRewardsEnabled()) {
            return 0;
        }
        int subAreasPerMember = Homestead.config.getInt("rewards.for-each-member.subareas");
        return region.getMembers().size() * subAreasPerMember;
    }

    public static int getChunksByPlayTime(OfflinePlayer player) {
        if (!Homestead.config.isRewardsEnabled()) {
            return 0;
        }
        if (player == null || !player.hasPlayedBefore() && !player.isOnline()) {
            return 0;
        }
        long playerMinutes = Rewards.getPlayerMinutes(player);
        List rewards = Homestead.config.getConfig().getMapList("rewards.by-playtime");
        return Rewards.getHighestRewardValue(rewards, playerMinutes, "chunks");
    }

    public static int getSubAreasByPlayTime(OfflinePlayer player) {
        if (!Homestead.config.isRewardsEnabled()) {
            return 0;
        }
        if (player == null || !player.hasPlayedBefore() && !player.isOnline()) {
            return 0;
        }
        long playerMinutes = Rewards.getPlayerMinutes(player);
        List rewards = Homestead.config.getConfig().getMapList("rewards.by-playtime");
        return Rewards.getHighestRewardValue(rewards, playerMinutes, "subareas");
    }

    private static long getPlayerMinutes(OfflinePlayer player) {
        return (long)player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 1200L;
    }

    private static int getHighestRewardValue(List<Map<?, ?>> rewards, long playerMinutes, String rewardKey) {
        int maxValue = 0;
        for (Map<?, ?> entry : rewards) {
            long requiredMinutes = Rewards.calculateRequiredMinutes(entry);
            int rewardValue = Rewards.getInt(entry, rewardKey);
            if (playerMinutes < requiredMinutes || rewardValue <= maxValue) continue;
            maxValue = rewardValue;
        }
        return maxValue;
    }

    private static long calculateRequiredMinutes(Map<?, ?> entry) {
        int minutes = Rewards.getInt(entry, "minutes");
        int hours = Rewards.getInt(entry, "hours");
        int days = Rewards.getInt(entry, "days");
        return (long)minutes + (long)hours * 60L + (long)days * 24L * 60L;
    }

    private static int getInt(Map<?, ?> map, String key) {
        Object val = map.get(key);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return 0;
    }
}

