/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.items.ItemUtils;

public class MenuUtils {
    public static String getTitle(int path) {
        return (String)Homestead.menusConfig.get("titles." + path);
    }

    public static ButtonData getButtonData(int path) {
        String name = (String)Homestead.menusConfig.get("buttons." + path + ".name");
        ArrayList<String> lore = (ArrayList<String>)Homestead.menusConfig.get("buttons." + path + ".lore");
        String type = (String)Homestead.menusConfig.get("buttons." + path + ".type");
        if (name == null) {
            name = "NO NAME";
        }
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        if (type == null) {
            type = "BARRIER";
        }
        return new ButtonData(name, lore, type);
    }

    public static ItemStack getButton(ButtonData data, Map<String, String> replacements) {
        if (data.getOriginalType().startsWith("PLAYERHEAD-")) {
            String texture = data.getOriginalType().split("-")[1];
            return ItemUtils.getPlayerHead(data.getName(), data.getLore(), texture, replacements);
        }
        return ItemUtils.getItem(data.getName(), data.getLore(), data.getType(), replacements);
    }

    public static ItemStack getButton(int path, OfflinePlayer ... playerHead) {
        ButtonData data = MenuUtils.getButtonData(path);
        if (data.getOriginalType().startsWith("PLAYERHEAD-")) {
            String texture = data.getOriginalType().split("-")[1];
            if (texture.equalsIgnoreCase("this")) {
                if (playerHead.length == 0) {
                    return ItemUtils.getItem(data.getName(), data.getLore(), Material.BARRIER);
                }
                return ItemUtils.getPlayerHead(data.getName(), data.getLore(), playerHead[0].getUniqueId());
            }
            return ItemUtils.getPlayerHead(data.getName(), data.getLore(), texture);
        }
        return ItemUtils.getItem(data.getName(), data.getLore(), data.getType());
    }

    public static ItemStack getButton(int path, Map<String, String> replacements, OfflinePlayer ... playerHead) {
        ButtonData data = MenuUtils.getButtonData(path);
        if (data.getOriginalType().startsWith("PLAYERHEAD-")) {
            String texture = data.getOriginalType().split("-")[1];
            if (texture.equalsIgnoreCase("this")) {
                if (playerHead.length == 0) {
                    return ItemUtils.getItem(data.getName(), data.getLore(), Material.BARRIER, replacements);
                }
                return ItemUtils.getPlayerHead(data.getName(), data.getLore(), playerHead[0].getUniqueId(), replacements);
            }
            return ItemUtils.getPlayerHead(data.getName(), data.getLore(), texture, replacements);
        }
        return ItemUtils.getItem(data.getName(), data.getLore(), data.getType(), replacements);
    }

    public static ItemStack getFlagButton(String flag, boolean value) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        Object description = Homestead.language.get("flags-info." + flag + ".description");
        replacements.put("{flag}", flag);
        replacements.put("{flag-description}", description instanceof String ? description.toString() : String.join((CharSequence)"\n", (List)description));
        replacements.put("{state}", Formatters.getFlag(value));
        replacements.put("{flag-allowed}", Formatters.getBoolean(!Homestead.config.isFlagDisabled(flag)));
        ButtonData data = MenuUtils.getButtonData(17);
        String type = (String)Homestead.language.get("flags-info." + flag + ".type");
        if (type != null && type.startsWith("PLAYERHEAD-")) {
            String texture = type.split("-")[1];
            return ItemUtils.getPlayerHead(data.getName(), data.getLore(), texture, replacements);
        }
        return ItemUtils.getItem(data.getName(), data.getLore(), Material.getMaterial((String)(type == null ? "BARRIER" : type)), replacements);
    }

    public static ItemStack getBackButton() {
        return ItemUtils.getItem(MenuUtils.getButtonData(0));
    }

    public static ItemStack getPreviousPageButton() {
        return ItemUtils.getItem(MenuUtils.getButtonData(1));
    }

    public static ItemStack getNextPageButton() {
        return ItemUtils.getItem(MenuUtils.getButtonData(2));
    }

    public static ItemStack getEmptySlot() {
        return ItemUtils.getItem(MenuUtils.getButtonData(3));
    }

    public static class ButtonData {
        public String name;
        public List<String> lore;
        public Material type;
        public String originalType;

        public ButtonData(String name, List<String> lore, String type) {
            this.name = name;
            this.lore = lore;
            this.type = Material.getMaterial((String)type);
            this.originalType = type;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getLore() {
            return this.lore;
        }

        public Material getType() {
            return this.type == null ? Material.BARRIER : this.type;
        }

        public String getOriginalType() {
            return this.originalType;
        }
    }
}

