/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.limits;

import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.rewards.LevelRewards;
import tfagaming.projects.minecraft.homestead.tools.minecraft.rewards.Rewards;

public class Limits {
    public static int getPlayerLimit(OfflinePlayer player, LimitType limit) {
        return switch (limit.ordinal()) {
            case 0, 4, 5 -> Limits.getBaseLimitValue(player, limit);
            default -> 0;
        };
    }

    public static int getRegionLimit(Region region, LimitType limit) {
        if (region == null) {
            return 0;
        }
        OfflinePlayer owner = region.getOwner();
        if (owner == null) {
            return 0;
        }
        return switch (limit.ordinal()) {
            case 1 -> Limits.getBaseLimitValue(owner, limit) + Rewards.getChunksByEachMember(region) + Rewards.getChunksByPlayTime(owner) + LevelRewards.getChunksByLevel(region);
            case 2 -> Limits.getBaseLimitValue(owner, limit) + LevelRewards.getMembersByLevel(region);
            case 3 -> Limits.getBaseLimitValue(owner, limit) + Rewards.getSubAreasByEachMember(region) + Rewards.getSubAreasByPlayTime(owner) + LevelRewards.getSubAreasByLevel(region);
            case 4, 5 -> Limits.getBaseLimitValue(owner, limit);
            default -> 0;
        };
    }

    public static boolean hasReachedLimit(OfflinePlayer player, Region region, LimitType limit) {
        return switch (limit.ordinal()) {
            case 0 -> Limits.hasReachedRegionsLimit(player);
            case 1 -> Limits.hasReachedChunksLimit(region);
            case 2 -> Limits.hasReachedMembersLimit(region);
            case 3 -> Limits.hasReachedSubAreasLimit(region);
            default -> false;
        };
    }

    private static int getBaseLimitValue(OfflinePlayer player, LimitType limit) {
        String limitKey = Limits.getLimitConfigKey(limit);
        Object playerOverride = Homestead.config.getRaw("player-limits." + player.getName() + "." + limitKey);
        if (playerOverride != null) {
            return (Integer)playerOverride;
        }
        LimitMethod method = Limits.getLimitsMethod();
        switch (method.ordinal()) {
            case 1: {
                String opKey = PlayerUtils.isOperator(player) ? "op" : "non-op";
                Object staticValue = Homestead.config.getRaw("limits.static." + opKey + "." + limitKey);
                return staticValue == null ? 0 : (Integer)staticValue;
            }
            case 0: {
                Object groupValue;
                String group = PlayerUtils.getPlayerGroup(player);
                if (group == null) {
                    group = "default";
                }
                return (groupValue = Homestead.config.getRaw("limits.groups." + group + "." + limitKey)) == null ? 0 : (Integer)groupValue;
            }
        }
        return 0;
    }

    private static boolean hasReachedRegionsLimit(OfflinePlayer player) {
        int max;
        if (player == null) {
            return false;
        }
        int current = RegionsManager.getRegionsOwnedByPlayer(player).size();
        return current >= (max = Limits.getPlayerLimit(player, LimitType.REGIONS));
    }

    private static boolean hasReachedChunksLimit(Region region) {
        int max;
        if (region == null) {
            return false;
        }
        int current = region.getChunks().size();
        return current >= (max = Limits.getRegionLimit(region, LimitType.CHUNKS_PER_REGION));
    }

    private static boolean hasReachedMembersLimit(Region region) {
        int max;
        if (region == null) {
            return false;
        }
        int current = region.getMembers().size();
        return current >= (max = Limits.getRegionLimit(region, LimitType.MEMBERS_PER_REGION));
    }

    private static boolean hasReachedSubAreasLimit(Region region) {
        int max;
        if (region == null) {
            return false;
        }
        int current = SubAreasManager.getSubAreasOfRegion(region.getUniqueId()).size();
        return current >= (max = Limits.getRegionLimit(region, LimitType.SUBAREAS_PER_REGION));
    }

    private static String getLimitConfigKey(LimitType limit) {
        return switch (limit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "regions";
            case 1 -> "chunks-per-region";
            case 2 -> "members-per-region";
            case 3 -> "subareas-per-region";
            case 4 -> "max-subarea-volume";
            case 5 -> "commands-cooldown";
        };
    }

    public static LimitMethod getLimitsMethod() {
        String method;
        return switch (method = Homestead.config.getString("limits.method")) {
            case "static" -> LimitMethod.STATIC;
            case "groups" -> LimitMethod.GROUPS;
            default -> LimitMethod.STATIC;
        };
    }

    public static enum LimitType {
        REGIONS,
        CHUNKS_PER_REGION,
        MEMBERS_PER_REGION,
        SUBAREAS_PER_REGION,
        MAX_SUBAREA_VOLUME,
        COMMANDS_COOLDOWN;

    }

    public static enum LimitMethod {
        GROUPS,
        STATIC;

    }
}

