/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.java;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.java.NumberUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;

public class Formatters {
    public static String replace(String string, Map<String, String> replacements) {
        if (string == null) {
            return "[Homestead: String is null]";
        }
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            string = string.replace(entry.getKey(), entry.getValue() == null ? "null" : (CharSequence)entry.getValue());
        }
        return string;
    }

    public static String formatLocation(Location location) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{world}", location.getWorld().getName());
        replacements.put("{x}", String.valueOf(NumberUtils.truncateToTwoDecimalPlaces(location.getX())));
        replacements.put("{y}", String.valueOf(NumberUtils.truncateToTwoDecimalPlaces(location.getY())));
        replacements.put("{z}", String.valueOf(NumberUtils.truncateToTwoDecimalPlaces(location.getZ())));
        return ChatColorTranslator.translate(Formatters.replace(Homestead.config.getString("formatters.location"), replacements));
    }

    public static String formatChunk(Chunk chunk) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{world}", chunk.getWorld().getName());
        replacements.put("{x}", String.valueOf(NumberUtils.truncateToTwoDecimalPlaces(chunk.getX())));
        replacements.put("{z}", String.valueOf(NumberUtils.truncateToTwoDecimalPlaces(chunk.getZ())));
        return ChatColorTranslator.translate(Formatters.replace(Homestead.config.getString("formatters.location"), replacements));
    }

    public static String formatBalance(double amount) {
        String balance = NumberUtils.convertToBalance(amount);
        String format = Homestead.config.getString("formatters.balance");
        return format.replace("{balance}", balance);
    }

    public static String formatDate(long date) {
        String pattern = Homestead.config.getString("formatters.date-format");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String formatted = simpleDateFormat.format(date);
        String dateWithAgo = Homestead.config.getString("formatters.date");
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{date}", formatted);
        replacements.put("{time-ago}", Formatters.getAgo(date));
        return Formatters.replace(dateWithAgo, replacements);
    }

    public static String formatRating(double rate) {
        return Formatters.formatRating(Math.round((float)rate));
    }

    public static String formatRating(int rate) {
        String star = (String)Homestead.language.get("default.star");
        switch (rate) {
            case 1: {
                return ChatColorTranslator.translate("&c" + star.repeat(1));
            }
            case 2: {
                return ChatColorTranslator.translate("&6" + star.repeat(2));
            }
            case 3: {
                return ChatColorTranslator.translate("&e" + star.repeat(3));
            }
            case 4: {
                return ChatColorTranslator.translate("&a" + star.repeat(4));
            }
            case 5: {
                return ChatColorTranslator.translate("&a" + star.repeat(5));
            }
        }
        return Formatters.getNone();
    }

    public static String formatRemainingTime(long time) {
        long currentTime = System.currentTimeMillis();
        long differenceMillis = time - currentTime;
        long totalSeconds = differenceMillis / 1000L;
        long days = totalSeconds / 86400L;
        long remaining = totalSeconds % 86400L;
        long hours = remaining / 3600L;
        long minutes = (remaining %= 3600L) / 60L;
        long seconds = remaining % 60L;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{d}", String.valueOf(days));
        replacements.put("{h}", String.valueOf(hours));
        replacements.put("{m}", String.valueOf(minutes));
        replacements.put("{s}", String.valueOf(seconds));
        return ChatColorTranslator.translate(Formatters.replace(Homestead.config.getString("formatters.duration"), replacements));
    }

    public static String formatPlayerPlaytimeDuration(OfflinePlayer player) {
        long totalMinutes = Formatters.getPlayerMinutes(player);
        long totalSeconds = totalMinutes * 60L;
        long days = totalSeconds / 86400L;
        long remainingSeconds = totalSeconds % 86400L;
        long hours = remainingSeconds / 3600L;
        long minutes = (remainingSeconds %= 3600L) / 60L;
        long seconds = remainingSeconds % 60L;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{d}", String.valueOf(days));
        replacements.put("{h}", String.valueOf(hours));
        replacements.put("{m}", String.valueOf(minutes));
        replacements.put("{s}", String.valueOf(seconds));
        return ChatColorTranslator.translate(Formatters.replace(Homestead.config.getString("formatters.duration"), replacements));
    }

    private static long getPlayerMinutes(OfflinePlayer player) {
        return (long)player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 1200L;
    }

    public static String formatPaginationMenuTitle(String title, int currentPage, int totalPages) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{title}", title);
        replacements.put("{current-page}", String.valueOf(currentPage));
        replacements.put("{total-pages}", String.valueOf(totalPages));
        return ChatColorTranslator.translate(Formatters.replace(Homestead.config.getString("formatters.gui-pagination-title"), replacements));
    }

    public static String formatPrivateChat(String regionName, String sender, String message) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", regionName);
        replacements.put("{sender}", sender);
        replacements.put("{message}", message);
        return ChatColorTranslator.translate(Formatters.replace(Homestead.config.getString("formatters.private-chat"), replacements));
    }

    public static String getPlayerOwnedRegions(OfflinePlayer player) {
        List<Region> regions = RegionsManager.getRegionsOwnedByPlayer(player);
        if (regions.isEmpty()) {
            return Formatters.getNone();
        }
        String format = Homestead.config.getString("formatters.player-regions");
        return ChatColorTranslator.translate(regions.stream().map(region -> format.replace("{region}", region.getName())).collect(Collectors.joining(Homestead.config.getString("formatters.player-regions-joining"))));
    }

    public static String getPlayerTrustedRegions(OfflinePlayer player) {
        List<Region> regions = RegionsManager.getRegionsHasPlayerAsMember(player);
        if (regions.isEmpty()) {
            return Formatters.getNone();
        }
        String format = Homestead.config.getString("formatters.player-regions");
        return ChatColorTranslator.translate(regions.stream().map(region -> format.replace("{region}", region.getName())).collect(Collectors.joining(Homestead.config.getString("formatters.player-regions-joining"))));
    }

    public static String getMembersOfRegion(Region region) {
        List<SerializableMember> members = region.getMembers();
        if (members.isEmpty()) {
            return Formatters.getNone();
        }
        String format = Homestead.config.getString("formatters.region-members");
        return ChatColorTranslator.translate(members.stream().map(member -> format.replace("{playername}", member.getBukkitOfflinePlayer().getName())).collect(Collectors.joining(Homestead.config.getString("formatters.region-members-joining"))));
    }

    public static String getRegionsOfWar(War war) {
        ArrayList<Region> regions = war.getRegions();
        if (regions.isEmpty()) {
            return Formatters.getNone();
        }
        String format = Homestead.config.getString("formatters.war-regions");
        return ChatColorTranslator.translate(regions.stream().map(region -> format.replace("{region}", region.getName())).collect(Collectors.joining(Homestead.config.getString("formatters.war-regions-joining"))));
    }

    public static String getNone() {
        return ChatColorTranslator.translate((String)Homestead.language.get("default.none"));
    }

    public static String getBoolean(boolean value) {
        return ChatColorTranslator.translate((String)Homestead.language.get(value ? "default.isTrue" : "default.isFalse"));
    }

    public static String getEnabled(boolean value) {
        return ChatColorTranslator.translate((String)Homestead.language.get(value ? "default.isEnabled" : "default.isDisabled"));
    }

    public static String getFlag(boolean value) {
        return ChatColorTranslator.translate((String)Homestead.language.get(value ? "default.flagSet" : "default.flagUnset"));
    }

    public static String getPlayerStatus(OfflinePlayer player) {
        return ChatColorTranslator.translate(Bukkit.getBannedPlayers().contains(player) ? (String)Homestead.language.get("default.banned") : (player.isOnline() ? (String)Homestead.language.get("default.online") : (String)Homestead.language.get("default.offline")));
    }

    public static String getAgo(long time) {
        long currentTime = System.currentTimeMillis();
        long differenceMillis = currentTime - time;
        long totalSeconds = differenceMillis / 1000L;
        long days = totalSeconds / 86400L;
        long remaining = totalSeconds % 86400L;
        long hours = remaining / 3600L;
        long minutes = (remaining %= 3600L) / 60L;
        long seconds = remaining % 60L;
        if (days != 0L) {
            return Homestead.config.getString("formatters.ago-days").replace("{v}", String.valueOf(days));
        }
        if (hours != 0L) {
            return Homestead.config.getString("formatters.ago-hours").replace("{v}", String.valueOf(hours));
        }
        if (minutes != 0L) {
            return Homestead.config.getString("formatters.ago-minutes").replace("{v}", String.valueOf(minutes));
        }
        if (seconds != 0L) {
            return Homestead.config.getString("formatters.ago-seconds").replace("{v}", String.valueOf(seconds));
        }
        return "0";
    }
}

