/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.sessions.mergingregion;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.structure.Region;

public final class MergeRegionSession {
    private static final Map<UUID, UUID> requests = new ConcurrentHashMap<UUID, UUID>();

    private MergeRegionSession() {
    }

    public static void newMergeRequest(Region region, Region regionToMerge) {
        UUID from = region.getUniqueId();
        UUID to = regionToMerge.getUniqueId();
        if (requests.containsValue(to) || requests.containsValue(from) || requests.containsKey(to) || requests.containsKey(from)) {
            return;
        }
        requests.put(from, to);
        MergeRegionSession.startTimer(region);
    }

    public static boolean isFromHaveRequest(Region from) {
        return requests.containsKey(from.getUniqueId());
    }

    public static boolean isToHaveRequest(Region to) {
        return requests.containsValue(to.getUniqueId());
    }

    public static UUID getFrom(Region to) {
        for (Map.Entry<UUID, UUID> e : requests.entrySet()) {
            if (!e.getValue().equals(to.getUniqueId())) continue;
            return e.getKey();
        }
        return null;
    }

    public static UUID getTo(Region from) {
        return requests.get(from.getUniqueId());
    }

    private static void startTimer(Region fromRegion) {
        UUID id = fromRegion.getUniqueId();
        Homestead.getInstance().runAsyncTaskLater(() -> requests.remove(id), 60);
    }
}

