/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.managers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.api.events.ChunkClaimEvent;
import tfagaming.projects.minecraft.homestead.api.events.ChunkUnclaimEvent;
import tfagaming.projects.minecraft.homestead.integrations.WorldEditAPI;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chunks.ChunkUtils;

public final class ChunksManager {
    private ChunksManager() {
    }

    public static Error claimChunk(UUID id, Chunk chunk) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return Error.REGION_NOT_FOUND;
        }
        if (ChunksManager.isChunkInDisabledWorld(chunk)) {
            return Error.CHUNK_IN_DISABLED_WORLD;
        }
        if (Homestead.config.isAdjacentChunksRuleEnabled() && !region.getChunks().isEmpty() && !ChunksManager.hasAdjacentOwnedChunk(region, chunk)) {
            return Error.CHUNK_NOT_ADJACENT_TO_REGION;
        }
        region.addChunk(chunk);
        ChunkClaimEvent event = new ChunkClaimEvent(region, chunk);
        Homestead.getInstance().runSyncTask(() -> Bukkit.getPluginManager().callEvent((Event)event));
        return null;
    }

    public static Error unclaimChunk(UUID id, Chunk chunk) {
        return ChunksManager.unclaimChunkInternal(id, chunk, false);
    }

    public static Error forceUnclaimChunk(UUID id, Chunk chunk) {
        return ChunksManager.unclaimChunkInternal(id, chunk, true);
    }

    private static Error unclaimChunkInternal(UUID id, Chunk chunk, boolean force) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return Error.REGION_NOT_FOUND;
        }
        if (Homestead.config.isAdjacentChunksRuleEnabled() && !force && ChunksManager.wouldSplitRegion(region, chunk)) {
            return Error.CHUNK_WOULD_SPLIT_REGION;
        }
        ChunksManager.removeChunk(id, chunk);
        if (Homestead.config.regenerateChunksWithWorldEdit()) {
            Homestead.getInstance().runAsyncTask(() -> WorldEditAPI.regenerateChunk(chunk.getWorld(), chunk.getX(), chunk.getZ()));
        }
        if (region.getLocation() != null && ChunkUtils.areEqual(region.getLocation().getBukkitLocation().getChunk(), chunk)) {
            region.setLocationToNull();
        }
        ChunkUnclaimEvent event = new ChunkUnclaimEvent(region, chunk);
        Homestead.getInstance().runSyncTask(() -> Bukkit.getPluginManager().callEvent((Event)event));
        return null;
    }

    public static Error removeChunk(UUID id, Chunk chunk) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return Error.REGION_NOT_FOUND;
        }
        region.removeChunk(chunk);
        block0: for (SubArea subArea : SubAreasManager.getSubAreasOfRegion(id)) {
            for (Chunk subAreaChunk : ChunkUtils.getChunksInArea(subArea.getFirstPoint(), subArea.getSecondPoint())) {
                if (!ChunkUtils.areEqual(subAreaChunk, chunk)) continue;
                SubAreasManager.deleteSubArea(subArea.getUniqueId());
                continue block0;
            }
        }
        return null;
    }

    public static boolean wouldSplitRegion(Region region, Chunk chunkToRemove) {
        if (region == null || region.getChunks() == null || region.getChunks().isEmpty()) {
            return false;
        }
        ArrayList<SerializableChunk> normalized = new ArrayList<SerializableChunk>();
        for (SerializableChunk serializableChunk : region.getChunks()) {
            if (serializableChunk == null || serializableChunk.getWorldName() == null || serializableChunk.getWorldName().isBlank()) continue;
            serializableChunk.setWorldName(serializableChunk.getWorldName().trim());
            normalized.add(serializableChunk);
        }
        LinkedHashMap<String, SerializableChunk> byKey = new LinkedHashMap<String, SerializableChunk>();
        for (SerializableChunk serializableChunk : normalized) {
            byKey.putIfAbsent(serializableChunk.toString(true), serializableChunk);
        }
        ArrayList arrayList = new ArrayList(byKey.values());
        arrayList.removeIf(c -> ChunkUtils.areEqual(c.getBukkitChunk(), chunkToRemove));
        if (arrayList.isEmpty()) {
            return false;
        }
        String string = ((SerializableChunk)arrayList.getFirst()).getWorldName();
        HashSet<SerializableChunk> visited = new HashSet<SerializableChunk>();
        LinkedList<SerializableChunk> queue = new LinkedList<SerializableChunk>();
        queue.add((SerializableChunk)arrayList.getFirst());
        visited.add((SerializableChunk)arrayList.getFirst());
        while (!queue.isEmpty()) {
            SerializableChunk current = (SerializableChunk)queue.poll();
            for (SerializableChunk neighbor : arrayList) {
                if (neighbor == null || !neighbor.getWorldName().equals(string) || visited.contains(neighbor) || !ChunksManager.areAdjacent(current, neighbor)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return visited.size() != arrayList.size();
    }

    private static boolean areAdjacent(SerializableChunk a, SerializableChunk b) {
        if (!a.getWorldName().equals(b.getWorldName())) {
            return false;
        }
        int dx = Math.abs(a.getX() - b.getX());
        int dz = Math.abs(a.getZ() - b.getZ());
        return dx == 1 && dz == 0 || dx == 0 && dz == 1;
    }

    public static boolean isChunkInDisabledWorld(Chunk chunk) {
        String worldName = chunk.getWorld().getName();
        List<String> exact = Homestead.config.getStringList("disabled-worlds-exact");
        if (exact.contains(worldName)) {
            return true;
        }
        List<String> patterns = Homestead.config.getStringList("disabled-worlds-pattern");
        for (String pat : patterns) {
            String regex;
            if (!(!pat.contains("*") && !pat.contains("?") ? pat.equals(worldName) : worldName.matches(regex = "\\Q" + pat.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q") + "\\E"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isChunkClaimed(Chunk chunk) {
        String key = SerializableChunk.convertToString(chunk, true);
        for (Region region : RegionsManager.getAll()) {
            for (SerializableChunk serialized : region.getChunks()) {
                if (serialized == null || !serialized.toString(true).equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public static Region getRegionOwnsTheChunk(Chunk chunk) {
        String key = SerializableChunk.convertToString(chunk, true);
        for (Region region : RegionsManager.getAll()) {
            for (SerializableChunk serialized : region.getChunks()) {
                if (serialized == null || !serialized.toString(true).equals(key)) continue;
                return region;
            }
        }
        return null;
    }

    public static boolean hasAdjacentOwnedChunk(Region region, Chunk chunk) {
        int[][] dirs;
        World world = chunk.getWorld();
        int x = chunk.getX();
        int z = chunk.getZ();
        for (int[] dir : dirs = new int[][]{{x + 1, z}, {x - 1, z}, {x, z + 1}, {x, z - 1}}) {
            Chunk neighbor;
            Region neighborRegion;
            int nx = dir[0];
            int nz = dir[1];
            if (!world.isChunkLoaded(nx, nz) || (neighborRegion = ChunksManager.getRegionOwnsTheChunk(neighbor = world.getChunkAt(nx, nz))) == null || !neighborRegion.getUniqueId().equals(region.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public static Chunk findNearbyUnclaimedChunk(Player player) {
        Chunk start = player.getLocation().getChunk();
        World world = player.getWorld();
        int sx = start.getX();
        int sz = start.getZ();
        for (int radius = 1; radius <= 30; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    Chunk current;
                    if (Math.abs(x) != radius && Math.abs(z) != radius || !world.isChunkLoaded(sx + x, sz + z) || ChunksManager.isChunkClaimed(current = world.getChunkAt(sx + x, sz + z))) continue;
                    return current;
                }
            }
        }
        return null;
    }

    public static boolean hasNeighbor(Player player) {
        Chunk[] neighbors;
        Chunk chunk = player.getLocation().getChunk();
        World world = player.getWorld();
        int x = chunk.getX();
        int z = chunk.getZ();
        for (Chunk neighbor : neighbors = new Chunk[]{world.getChunkAt(x, z - 1), world.getChunkAt(x, z + 1), world.getChunkAt(x - 1, z), world.getChunkAt(x + 1, z)}) {
            Region r;
            if (!ChunksManager.isChunkClaimed(neighbor) || (r = ChunksManager.getRegionOwnsTheChunk(neighbor)) == null || r.isOwner((OfflinePlayer)player)) continue;
            return true;
        }
        return false;
    }

    public static Chunk getFromLocation(World world, int x, int z) {
        Location location = new Location(world, (double)(x * 16 + 8), 64.0, (double)(z * 16 + 8));
        return location.getChunk();
    }

    public static Location getLocation(Player player, Chunk chunk) {
        Location loc;
        loc.setY((loc = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 8), 64.0, (double)(chunk.getZ() * 16 + 8))).getWorld() == null ? 64.0 : (double)(loc.getWorld().getHighestBlockYAt(loc) + 2));
        loc.setPitch(player.getLocation().getPitch());
        loc.setYaw(player.getLocation().getYaw());
        return loc;
    }

    public static Location getLocation(Player player, SerializableChunk chunk) {
        Location loc;
        World world = chunk.getWorld();
        if (world == null) {
            return null;
        }
        int x = chunk.getX() * 16 + 8;
        int z = chunk.getZ() * 16 + 8;
        if (world.getEnvironment() == World.Environment.NETHER) {
            loc = ChunksManager.findSafeNetherLocation(world, x, z);
        } else {
            int highest = world.getHighestBlockYAt(x, z);
            loc = new Location(world, (double)x, (double)(highest + 2), (double)z);
        }
        if (loc != null) {
            loc.setPitch(player.getLocation().getPitch());
            loc.setYaw(player.getLocation().getYaw());
        }
        return loc;
    }

    private static Location findSafeNetherLocation(World world, int x, int z) {
        for (int y = 32; y < 127; ++y) {
            Block block = world.getBlockAt(x, y, z);
            Block above = world.getBlockAt(x, y + 1, z);
            if (block.getType() != Material.AIR || above.getType() != Material.AIR) continue;
            return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        }
        return null;
    }

    public static void removeRandomChunk(UUID id) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        List<SerializableChunk> chunks = region.getChunks();
        if (chunks == null || chunks.isEmpty()) {
            return;
        }
        int index = new Random().nextInt(chunks.size());
        region.removeChunk(chunks.get(index));
    }

    public static int deleteInvalidChunks() {
        int count = 0;
        HashSet<String> worlds = new HashSet<String>();
        for (World w : Bukkit.getWorlds()) {
            worlds.add(w.getName());
        }
        for (Region region : RegionsManager.getAll()) {
            if (region == null || region.getChunks() == null || region.getChunks().isEmpty()) continue;
            Iterator<SerializableChunk> it = region.getChunks().iterator();
            while (it.hasNext()) {
                SerializableChunk sc = it.next();
                if (sc != null && sc.getWorldName() != null && worlds.contains(sc.getWorldName().trim())) continue;
                it.remove();
                ++count;
            }
        }
        return count;
    }

    public static enum Error {
        REGION_NOT_FOUND,
        CHUNK_IN_DISABLED_WORLD,
        CHUNK_NOT_ADJACENT_TO_REGION,
        CHUNK_WOULD_SPLIT_REGION;

    }
}

