/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.logs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import tfagaming.projects.minecraft.homestead.Homestead;

public class LogsFile {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss MM/dd/yyyy");
    private final File logFile = new File(Homestead.getInstance().getDataFolder(), "logs.txt");
    private boolean isReady = false;

    public LogsFile() {
        this.createLogFile();
        this.clear();
        this.save("-------------------------------------------------------------------");
        this.save("This is the logs.txt file; it saves all command executions and errors from the plugin.");
        this.save("Do not delete this file while the plugin is running.");
        this.save("-------------------------------------------------------------------");
    }

    private void createLogFile() {
        if (!Homestead.getInstance().getDataFolder().exists()) {
            Homestead.getInstance().getDataFolder().mkdirs();
        }
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.isReady = true;
    }

    public void save(String message) {
        if (!this.isReady) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.logFile, true);){
            String timestamp = LocalDateTime.now().format(formatter);
            writer.write("[" + timestamp + "] " + message + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clear() {
        if (!this.isReady) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.logFile, false);){
            writer.write("");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

