/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Raid;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Fence;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public final class RegionProtectionListener
implements Listener {
    public static final Map<UUID, Location> lastLocations = new HashMap<UUID, Location>();

    public static void onEntityMove(Entity entity) {
        try {
            Location from = lastLocations.get(entity.getUniqueId());
            Location to = entity.getLocation();
            if (from == null) {
                from = entity.getLocation();
            }
            Chunk fromChunk = from.getChunk();
            Chunk toChunk = to.getChunk();
            lastLocations.put(entity.getUniqueId(), to.clone());
            if (fromChunk.equals((Object)toChunk)) {
                return;
            }
            if (ChunksManager.isChunkClaimed(toChunk) && entity instanceof CopperGolem) {
                Region fromRegion = ChunksManager.getRegionOwnsTheChunk(fromChunk);
                Region toRegion = ChunksManager.getRegionOwnsTheChunk(toChunk);
                if (toRegion == null) {
                    return;
                }
                if (fromRegion == null) {
                    if (!toRegion.isWorldFlagSet(0x100000L)) {
                        entity.remove();
                    }
                } else if (!fromRegion.getUniqueId().equals(toRegion.getUniqueId()) && !toRegion.isWorldFlagSet(0x100000L)) {
                    entity.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean canBeBrokenByProjectile(Block block) {
        return !block.isPreferredTool(new ItemStack(Material.AIR));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = block.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 2L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryInstanceOfEntityOpen(InventoryOpenEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof Entity) {
            Entity entity = (Entity)holder;
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                Player player = (Player)event.getPlayer();
                Location location = villager.getLocation();
                Chunk chunk = location.getChunk();
                RegionProtection.hasPermission(player, chunk, location, 0x400000L, null, () -> event.setCancelled(true));
            } else if (entity instanceof ChestBoat || entity instanceof ChestedHorse || entity instanceof StorageMinecart || entity instanceof HopperMinecart) {
                Player player = (Player)event.getPlayer();
                Location location = entity.getLocation();
                Chunk chunk = location.getChunk();
                RegionProtection.hasPermission(player, chunk, location, 4L, null, () -> event.setCancelled(true));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        Block blockClicked = event.getBlockClicked();
        BlockFace blockFace = event.getBlockFace();
        Block blockRelative = blockClicked.getRelative(blockFace);
        Location location = blockRelative.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 2L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Block blockClicked = event.getBlockClicked();
        BlockFace blockFace = event.getBlockFace();
        Block blockRelative = blockClicked.getRelative(blockFace);
        Location location = blockRelative.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerExtinguishFire(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Action action = event.getAction();
        Block targetBlock = player.getTargetBlock(null, 5);
        if (action != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (targetBlock.getType() == Material.FIRE) {
            Location location = targetBlock.getLocation();
            Chunk chunk = location.getChunk();
            RegionProtection.hasPermission(player, chunk, location, 0x800000L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerTrampleBlock(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block blockClicked = event.getClickedBlock();
        Action action = event.getAction();
        if (action != Action.PHYSICAL || blockClicked == null) {
            return;
        }
        if (List.of(Material.FARMLAND, Material.TURTLE_EGG).contains(blockClicked.getType())) {
            Location location = blockClicked.getLocation();
            Chunk chunk = location.getChunk();
            RegionProtection.hasPermission(player, chunk, location, 32768L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerHarvestCrop(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block blockClicked = event.getClickedBlock();
        if (blockClicked == null) {
            return;
        }
        if (this.isCropBlock(blockClicked)) {
            Location location = blockClicked.getLocation();
            Chunk chunk = location.getChunk();
            RegionProtection.hasPermission(player, chunk, location, 16384L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPlaceSpawnEgg(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Action action = event.getAction();
        Block blockClicked = event.getClickedBlock();
        ItemStack item = event.getItem();
        if (item == null || blockClicked == null || action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (item.getType().name().endsWith("_SPAWN_EGG")) {
            Location location = blockClicked.getLocation();
            Chunk chunk = location.getChunk();
            RegionProtection.hasPermission(player, chunk, location, 0x800000000L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Material type;
        Player player = event.getPlayer();
        Block clicked = event.getClickedBlock();
        Location location = clicked != null ? clicked.getLocation() : player.getLocation();
        Chunk chunk = location.getChunk();
        if (event.getItem() != null) {
            boolean placeSpawnItem;
            Material itemType = event.getItem().getType();
            String itn = itemType.name();
            boolean bl = placeSpawnItem = itn.contains("BOAT") || itn.contains("ARMOR_STAND") || itn.contains("MINECART") || itn.contains("PAINTING") || itemType == Material.BONE_MEAL || itemType == Material.ITEM_FRAME || itemType == Material.GLOW_ITEM_FRAME;
            if (placeSpawnItem) {
                RegionProtection.hasPermission(player, chunk, location, 2L, null, () -> event.setCancelled(true));
                return;
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && clicked != null) {
            type = clicked.getType();
            if (this.isShulkerBox(type)) {
                RegionProtection.hasPermission(player, chunk, location, 4L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isAnySign(type)) {
                RegionProtection.hasPermission(player, chunk, location, 2L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isContainerLike(type)) {
                RegionProtection.hasPermission(player, chunk, location, 4L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isAnvil(type)) {
                RegionProtection.hasPermission(player, chunk, location, 64L, null, () -> event.setCancelled(true));
                return;
            }
            if (Tag.TRAPDOORS.isTagged((Keyed)type)) {
                RegionProtection.hasPermission(player, chunk, location, 16L, null, () -> event.setCancelled(true));
                return;
            }
            if (Tag.DOORS.isTagged((Keyed)type) || type.name().contains("DOOR")) {
                RegionProtection.hasPermission(player, chunk, location, 8L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isArchaeologyBlockWithBrush(type, player)) {
                RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
                return;
            }
            if (Tag.BUTTONS.isTagged((Keyed)type)) {
                RegionProtection.hasPermission(player, chunk, location, 512L, null, () -> event.setCancelled(true));
                return;
            }
            if (type.name().contains("FENCE_GATE")) {
                RegionProtection.hasPermission(player, chunk, location, 32L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isSmallInteractable(type)) {
                RegionProtection.hasPermission(player, chunk, location, 65536L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isLecternOrVaultWithKey(type, player)) {
                RegionProtection.hasPermission(player, chunk, location, 4L, null, () -> event.setCancelled(true));
                return;
            }
            if (type.name().endsWith("_BED")) {
                RegionProtection.hasPermission(player, chunk, location, 0x100000000L, null, () -> event.setCancelled(true));
                return;
            }
            if (type == Material.LEVER) {
                RegionProtection.hasPermission(player, chunk, location, 256L, null, () -> event.setCancelled(true));
                return;
            }
            if (type == Material.BELL) {
                RegionProtection.hasPermission(player, chunk, location, 2048L, null, () -> event.setCancelled(true));
                return;
            }
            if (this.isRedstoneInteraction(type)) {
                RegionProtection.hasPermission(player, chunk, location, 128L, null, () -> event.setCancelled(true));
                return;
            }
            return;
        }
        if (event.getAction() == Action.PHYSICAL && clicked != null) {
            type = clicked.getType();
            if (Tag.PRESSURE_PLATES.isTagged((Keyed)type)) {
                RegionProtection.hasPermission(player, chunk, location, 1024L, null, () -> event.setCancelled(true));
                return;
            }
            if (type == Material.TRIPWIRE) {
                RegionProtection.hasPermission(player, chunk, location, 4096L, null, () -> event.setCancelled(true));
            }
        }
    }

    private boolean isShulkerBox(Material type) {
        if (Tag.SHULKER_BOXES.isTagged((Keyed)type)) {
            return true;
        }
        String n = type.name();
        return n.endsWith("SHULKER_BOX");
    }

    private boolean isAnySign(Material type) {
        if (Tag.SIGNS.isTagged((Keyed)type)) {
            return true;
        }
        String n = type.name();
        return n.endsWith("_HANGING_SIGN") || n.endsWith("_WALL_HANGING_SIGN") || n.endsWith("_SIGN") || n.endsWith("_WALL_SIGN");
    }

    private boolean isContainerLike(Material type) {
        if (type == Material.ENDER_CHEST) {
            return false;
        }
        if (Tag.CAMPFIRES.isTagged((Keyed)type)) {
            return true;
        }
        if (this.isShulkerBox(type)) {
            return true;
        }
        switch (type) {
            case FURNACE: 
            case SMOKER: 
            case BLAST_FURNACE: 
            case BREWING_STAND: 
            case BARREL: 
            case BEACON: 
            case DROPPER: 
            case DISPENSER: 
            case CHISELED_BOOKSHELF: 
            case CAULDRON: 
            case LAVA_CAULDRON: 
            case WATER_CAULDRON: 
            case LODESTONE: 
            case HOPPER: {
                return true;
            }
        }
        String n = type.name();
        if (n.contains("CHEST")) {
            return true;
        }
        return n.contains("SHELF");
    }

    private boolean isAnvil(Material type) {
        return type.name().contains("ANVIL");
    }

    private boolean isArchaeologyBlockWithBrush(Material type, Player player) {
        if (type != Material.SUSPICIOUS_GRAVEL && type != Material.SUSPICIOUS_SAND) {
            return false;
        }
        return player.getInventory().getItemInMainHand().getType() == Material.BRUSH;
    }

    private boolean isSmallInteractable(Material type) {
        if (type == Material.CAKE) {
            return true;
        }
        if (type == Material.DECORATED_POT) {
            return true;
        }
        if (type == Material.FLOWER_POT) {
            return true;
        }
        String n = type.name();
        return n.contains("POTTED");
    }

    private boolean isLecternOrVaultWithKey(Material type, Player player) {
        if (type == Material.LECTERN) {
            Material inHand = player.getInventory().getItemInMainHand().getType();
            return inHand == Material.WRITTEN_BOOK || inHand == Material.WRITABLE_BOOK;
        }
        if (type == Material.VAULT) {
            return player.getInventory().getItemInMainHand().getType().name().contains("TRIAL_KEY");
        }
        return false;
    }

    private boolean isRedstoneInteraction(Material type) {
        return switch (type) {
            case Material.REPEATER, Material.COMPARATOR, Material.COMMAND_BLOCK, Material.COMMAND_BLOCK_MINECART, Material.REDSTONE, Material.REDSTONE_WIRE, Material.NOTE_BLOCK, Material.JUKEBOX, Material.COMPOSTER, Material.DAYLIGHT_DETECTOR -> true;
            default -> false;
        };
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPunchFrame(EntityDamageByEntityEvent event) {
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof ItemFrame && (entity = event.getDamager()) instanceof Player) {
            Player player = (Player)entity;
            Location location = entity2.getLocation();
            Chunk chunk = location.getChunk();
            RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent event) {
        Player player = event.getPlayer();
        Lectern lectern = event.getLectern();
        Location location = lectern.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 4L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Location location = block.getLocation();
            Chunk chunk = location.getChunk();
            EntityEquipment equipment = player.getEquipment();
            if (equipment == null) {
                return;
            }
            ItemStack boots = equipment.getBoots();
            if (boots != null && boots.getEnchantments().containsKey(Enchantment.FROST_WALKER)) {
                RegionProtection.hasPermission(player, chunk, location, 8192L, null, () -> event.setCancelled(true));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        if (player == null && ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (region != null && !region.isWorldFlagSet(32L)) {
                event.setCancelled(true);
            }
            return;
        }
        RegionProtection.hasPermission(player, chunk, location, 0x800000L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingEntityBreak(HangingBreakByEntityEvent event) {
        Hanging entity = event.getEntity();
        Entity remover = event.getRemover();
        if (entity instanceof Painting || entity instanceof ItemFrame) {
            Region region;
            Location location;
            Chunk chunk;
            if (remover instanceof Player) {
                Player player = (Player)remover;
                Location location2 = entity.getLocation();
                Chunk chunk2 = location2.getChunk();
                RegionProtection.hasPermission(player, chunk2, location2, 1L, null, () -> event.setCancelled(true));
            } else if (Explosives.isExplosive(remover) && ChunksManager.isChunkClaimed(chunk = (location = entity.getLocation()).getChunk()) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(128L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHitBreakableBlock(ProjectileHitEvent event) {
        Region region;
        Block hit = event.getHitBlock();
        if (hit == null) {
            return;
        }
        Projectile projectile = event.getEntity();
        ProjectileSource source = projectile.getShooter();
        if (!RegionProtectionListener.canBeBrokenByProjectile(hit)) {
            return;
        }
        Location location = hit.getLocation();
        Chunk chunk = location.getChunk();
        if (source instanceof Player) {
            Player player = (Player)source;
            RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
        } else if (projectile instanceof WitherSkull) {
            Region region2;
            if (ChunksManager.isChunkClaimed(chunk) && (region2 = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region2.isWorldFlagSet(256L)) {
                event.getEntity().remove();
                event.setCancelled(true);
            }
        } else if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(1024L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Region region;
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        if (damager instanceof Player) {
            Player player = (Player)damager;
            if (entity instanceof ArmorStand) {
                RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
            } else if (entity instanceof Player) {
                RegionProtection.hasPermission(player, chunk, location, 0x8000000L, null, () -> event.setCancelled(true));
            } else if (entity instanceof Monster || entity instanceof IronGolem) {
                RegionProtection.hasPermission(player, chunk, location, 0x200000L, null, () -> event.setCancelled(true));
            } else if (entity instanceof Mob) {
                RegionProtection.hasPermission(player, chunk, location, 0x100000L, null, () -> event.setCancelled(true));
            }
        } else if (Explosives.isExplosive(entity) && ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(128L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 262144L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractThrowThrowable(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material type = item.getType();
        long flag = -1L;
        if (type == Material.ENDER_PEARL) {
            flag = 0x20000000L;
        } else if (type == Material.SPLASH_POTION || type == Material.LINGERING_POTION) {
            flag = 0x40000000L;
        } else {
            return;
        }
        Location launchLoc = player.getLocation();
        Chunk chunk = launchLoc.getChunk();
        RegionProtection.hasPermission(player, chunk, launchLoc, flag, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerEatChorusFruit(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        Chunk chunk = location.getChunk();
        ItemStack item = event.getItem();
        if (item.getType().equals((Object)Material.CHORUS_FRUIT)) {
            RegionProtection.hasPermission(player, chunk, location, 0x20000000L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        Region region;
        ThrownPotion entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            RegionProtection.hasPermission(player, chunk, location, 0x40000000L, null, () -> event.setCancelled(true));
        } else if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(1024L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        Region region;
        ThrownPotion entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            RegionProtection.hasPermission(player, chunk, location, 0x40000000L, null, () -> event.setCancelled(true));
        } else if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(1024L)) {
            event.setCancelled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHitEntity(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        Entity entityHit = event.getHitEntity();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (entity instanceof ThrownPotion) {
                Location location = entity.getLocation();
                Chunk chunk = location.getChunk();
                RegionProtection.hasPermission(player, chunk, location, 0x40000000L, null, () -> event.setCancelled(true));
                return;
            }
        }
        if (!(shooter instanceof Player)) return;
        Player player = (Player)shooter;
        if (!(entityHit instanceof LivingEntity)) return;
        Location location = entityHit.getLocation();
        Chunk chunk = location.getChunk();
        if (entityHit instanceof Player) {
            RegionProtection.hasPermission(player, chunk, location, 0x8000000L, null, () -> event.setCancelled(true));
            return;
        }
        if (!(entityHit instanceof Monster) && !(entityHit instanceof IronGolem)) {
            if (!(entityHit instanceof Mob)) return;
            RegionProtection.hasPermission(player, chunk, location, 0x100000L, null, () -> event.setCancelled(true));
            return;
        }
        RegionProtection.hasPermission(player, chunk, location, 0x200000L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 0x80000000L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Location location = player.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 0x80000000L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        Vehicle vehicle = event.getVehicle();
        Location location = vehicle.getLocation();
        Chunk chunk = location.getChunk();
        Entity entity = event.getEntered();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RegionProtection.hasPermission(player, chunk, location, 0x1000000L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleDamage(VehicleDamageEvent event) {
        Vehicle vehicle = event.getVehicle();
        Location location = vehicle.getLocation();
        Chunk chunk = location.getChunk();
        Entity entity = event.getAttacker();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RegionProtection.hasPermission(player, chunk, location, 1L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerLeashEntity(PlayerLeashEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 262144L, null, () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLeashEvent(PlayerLeashEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Location location = entity.getLocation();
        Block block = location.getBlock();
        Chunk chunk = location.getChunk();
        if (block instanceof Fence) {
            RegionProtection.hasPermission(player, chunk, location, 262144L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerUnleashEntity(PlayerUnleashEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Location location = entity.getLocation();
        Block block = location.getBlock();
        Chunk chunk = location.getChunk();
        if (block instanceof Fence) {
            RegionProtection.hasPermission(player, chunk, location, 262144L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        if (entity instanceof Villager) {
            RegionProtection.hasPermission(player, chunk, location, 0x400000L, null, () -> event.setCancelled(true));
        } else if (entity instanceof ArmorStand) {
            RegionProtection.hasPermission(player, chunk, location, 131072L, null, () -> event.setCancelled(true));
        } else if (entity instanceof ItemFrame || entity instanceof GlowItemFrame) {
            RegionProtection.hasPermission(player, chunk, location, 524288L, null, () -> event.setCancelled(true));
        } else if (!(entity instanceof Player)) {
            RegionProtection.hasPermission(player, chunk, location, 262144L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        Location location = entity.getLocation();
        Chunk chunk = location.getChunk();
        if (entity instanceof Villager) {
            RegionProtection.hasPermission(player, chunk, location, 0x400000L, null, () -> event.setCancelled(true));
        } else if (entity instanceof ArmorStand) {
            RegionProtection.hasPermission(player, chunk, location, 131072L, null, () -> event.setCancelled(true));
        } else if (entity instanceof ItemFrame || entity instanceof GlowItemFrame) {
            RegionProtection.hasPermission(player, chunk, location, 524288L, null, () -> event.setCancelled(true));
        } else if (!(entity instanceof Player)) {
            RegionProtection.hasPermission(player, chunk, location, 262144L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Location location = player.getLocation();
            Chunk chunk = location.getChunk();
            if (event.isGliding() && this.isWearingElytra(player)) {
                RegionProtection.hasPermission(player, chunk, location, 0x400000000L, null, () -> event.setCancelled(true));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause != EntityDamageEvent.DamageCause.FALL && cause != EntityDamageEvent.DamageCause.FLY_INTO_WALL) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Location location = player.getLocation();
            Chunk chunk = location.getChunk();
            RegionProtection.hasPermission(player, chunk, location, 0x10000000L, null, () -> event.setCancelled(true));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof WindCharge) {
            Region region;
            Chunk chunk = event.getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(524288L)) {
                entity.remove();
                event.setCancelled(true);
            }
        } else if (entity instanceof Wither || entity instanceof WitherSkull) {
            boolean updated = event.blockList().removeIf(block -> {
                Chunk chunk = block.getChunk();
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                return region != null && !region.isWorldFlagSet(256L);
            });
            if (updated) {
                event.setCancelled(true);
            }
        } else if (Explosives.isExplosive(entity)) {
            Chunk chunk = event.getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                if (region != null && !region.isWorldFlagSet(128L)) {
                    event.setCancelled(true);
                }
            } else {
                boolean belowSeaOnly = Homestead.config.getBoolean("special-feat.tnt-explodes-only-below-sea-level");
                ArrayList<Block> allowed = new ArrayList<Block>();
                for (Block block2 : event.blockList()) {
                    Chunk blockChunk = block2.getChunk();
                    if (ChunksManager.isChunkClaimed(blockChunk)) continue;
                    if (belowSeaOnly && entity instanceof TNTPrimed) {
                        if (block2.getY() > block2.getWorld().getSeaLevel()) continue;
                        allowed.add(block2);
                        continue;
                    }
                    allowed.add(block2);
                }
                event.blockList().clear();
                event.blockList().addAll(allowed);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        Block block = event.getBlock();
        if (block.getType().equals((Object)Material.AIR)) {
            Location location = block.getLocation();
            Chunk chunk = location.getChunk();
            if (ChunksManager.isChunkClaimed(chunk)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                if (region != null && !region.isWorldFlagSet(128L)) {
                    event.setCancelled(true);
                }
            } else {
                ArrayList<Block> allowedBlocks = new ArrayList<Block>();
                for (Block b : event.blockList()) {
                    Location blockLocation = b.getLocation();
                    Chunk blockChunk = blockLocation.getChunk();
                    if (ChunksManager.isChunkClaimed(blockChunk)) continue;
                    allowedBlocks.add(b);
                }
                event.blockList().clear();
                event.blockList().addAll(allowedBlocks);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        Region region;
        BlockState newState = event.getNewState();
        Block block = event.getBlock();
        Block source = event.getSource();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        if (newState.getType() == Material.FIRE) {
            Region region2;
            if (ChunksManager.isChunkClaimed(chunk) && (region2 = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region2.isWorldFlagSet(32L)) {
                event.setCancelled(true);
            }
        } else if (source.getType() == Material.GRASS_BLOCK || source.getType() == Material.MYCELIUM) {
            Region region3;
            if (ChunksManager.isChunkClaimed(chunk) && (region3 = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region3.isWorldFlagSet(8192L)) {
                event.setCancelled(true);
            }
        } else if (event.getSource().getType() == Material.SCULK_CATALYST) {
            Region region4;
            if (ChunksManager.isChunkClaimed(chunk) && (region4 = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region4.isWorldFlagSet(16384L)) {
                event.setCancelled(true);
            }
        } else if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(4096L)) {
            event.setCancelled(true);
        }
    }

    public void onBlockGrow(BlockGrowEvent event) {
        Region region;
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(4096L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        Region region;
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(16L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Region region;
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(32L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLiquidFlow(BlockFromToEvent event) {
        Region region;
        Chunk toChunk;
        Chunk fromChunk = event.getBlock().getChunk();
        if (!fromChunk.equals((Object)(toChunk = event.getToBlock().getChunk())) && ChunksManager.isChunkClaimed(toChunk) && (region = ChunksManager.getRegionOwnsTheChunk(toChunk)) != null && !region.isWorldFlagSet(64L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        ArrayList<Block> affectedBlocks = new ArrayList<Block>(event.getBlocks());
        BlockFace direction = event.getDirection();
        if (!affectedBlocks.isEmpty()) {
            affectedBlocks.add(piston.getRelative(direction));
        }
        if (!this.canPistonMoveBlock(affectedBlocks, direction, piston.getLocation().getChunk(), false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Block piston = event.getBlock();
        ArrayList<Block> affectedBlocks = new ArrayList<Block>(event.getBlocks());
        BlockFace direction = event.getDirection();
        if (event.isSticky() && !affectedBlocks.isEmpty()) {
            affectedBlocks.add(piston.getRelative(direction));
        }
        if (!this.canPistonMoveBlock(affectedBlocks, direction, piston.getLocation().getChunk(), true)) {
            event.setCancelled(true);
        }
    }

    private boolean canPistonMoveBlock(List<Block> blocks, BlockFace direction, Chunk pistonChunk, boolean retractOrNot) {
        if (retractOrNot) {
            for (Block block : blocks) {
                Chunk chunk = block.getLocation().getChunk();
                if (chunk.equals((Object)pistonChunk) || !ChunksManager.isChunkClaimed(chunk)) continue;
                Region pistonChunkRegion = ChunksManager.getRegionOwnsTheChunk(pistonChunk);
                UUID pistonChunkOwner = pistonChunkRegion == null ? null : pistonChunkRegion.getOwnerId();
                UUID targetChunkOwner = Objects.requireNonNull(ChunksManager.getRegionOwnsTheChunk(chunk)).getOwnerId();
                if (pistonChunkRegion != null && pistonChunkOwner != null && pistonChunkOwner.equals(targetChunkOwner)) {
                    return true;
                }
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                if (region == null || region.isWorldFlagSet(512L)) continue;
                return false;
            }
            return true;
        }
        for (Block block : blocks) {
            Chunk chunk = block.getRelative(direction).getLocation().getChunk();
            if (chunk.equals((Object)pistonChunk) || !ChunksManager.isChunkClaimed(chunk)) continue;
            Region pistonChunkRegion = ChunksManager.getRegionOwnsTheChunk(pistonChunk);
            UUID pistonChunkOwner = pistonChunkRegion == null ? null : pistonChunkRegion.getOwnerId();
            UUID targetChunkOwner = Objects.requireNonNull(ChunksManager.getRegionOwnsTheChunk(chunk)).getOwnerId();
            if (pistonChunkRegion != null && pistonChunkOwner != null && pistonChunkOwner.equals(targetChunkOwner)) {
                return true;
            }
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (region == null || region.isWorldFlagSet(512L)) continue;
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDispense(BlockDispenseEvent event) {
        Block block = event.getBlock();
        BlockData blockdata = event.getBlock().getBlockData();
        Chunk targetChunk = block.getRelative(((Directional)blockdata).getFacing()).getLocation().getChunk();
        if (!block.getLocation().getChunk().equals((Object)targetChunk) && ChunksManager.isChunkClaimed(targetChunk)) {
            Region dispenserChunkRegion = ChunksManager.getRegionOwnsTheChunk(block.getLocation().getChunk());
            UUID dispenserChunkOwner = dispenserChunkRegion == null ? null : dispenserChunkRegion.getOwnerId();
            UUID targetChunkOwner = Objects.requireNonNull(ChunksManager.getRegionOwnsTheChunk(targetChunk)).getOwnerId();
            if (dispenserChunkRegion != null && dispenserChunkOwner != null && dispenserChunkOwner.equals(targetChunkOwner)) {
                return;
            }
            Region region = ChunksManager.getRegionOwnsTheChunk(targetChunk);
            if (region != null && !region.isWorldFlagSet(1024L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Region region;
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        Location location = block.getLocation();
        Chunk chunk = location.getChunk();
        if (entity instanceof Sheep || entity instanceof Goat || entity instanceof Cow || entity instanceof Villager || entity instanceof Bee || block.getType().hasGravity()) {
            return;
        }
        if (entity instanceof Wither || entity instanceof WitherSkull) {
            Region region2;
            if (ChunksManager.isChunkClaimed(chunk) && (region2 = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region2.isWorldFlagSet(256L)) {
                event.setCancelled(true);
            }
        } else if (!(entity instanceof Player) && !(entity instanceof FallingBlock) && ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(4L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        Location location = event.getLocation();
        Chunk chunk = location.getChunk();
        LivingEntity entity = event.getEntity();
        CreatureSpawnEvent.SpawnReason spawnReason = event.getSpawnReason();
        boolean ignoreSpawners = Homestead.config.getBoolean("flags-configuration.spawners");
        if (ignoreSpawners && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            return;
        }
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (entity instanceof Monster || entity instanceof IronGolem) {
                if (region != null && !region.isWorldFlagSet(2L)) {
                    event.setCancelled(true);
                }
            } else if (entity instanceof Mob && region != null && !region.isWorldFlagSet(1L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity2(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        Chunk chunk = entity.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (!(damager instanceof Player) && region != null && !region.isWorldFlagSet(8L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBreakDoor(EntityBreakDoorEvent event) {
        LivingEntity entity = event.getEntity();
        Chunk chunk = entity.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (!(entity instanceof Player) && region != null && !region.isWorldFlagSet(4L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRaidTrigger(RaidTriggerEvent event) {
        Player player = event.getPlayer();
        Raid raid = event.getRaid();
        Location location = raid.getLocation();
        Chunk chunk = location.getChunk();
        RegionProtection.hasPermission(player, chunk, location, 0x200000000L, null, () -> {
            event.setCancelled(true);
            PotionEffect effect = event.getPlayer().getPotionEffect(PotionEffectType.RAID_OMEN);
            if (effect != null) {
                event.getPlayer().removePotionEffect(PotionEffectType.RAID_OMEN);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        Material blockType = event.getBlock().getType();
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (blockType == Material.SNOW) {
                if (region != null && !region.isWorldFlagSet(65536L)) {
                    event.setCancelled(true);
                }
            } else if (blockType == Material.ICE && region != null && !region.isWorldFlagSet(131072L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleMove(VehicleMoveEvent event) {
        Chunk toChunk;
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        Chunk fromChunk = from.getChunk();
        if (fromChunk.equals((Object)(toChunk = to.getChunk()))) {
            return;
        }
        if (ChunksManager.isChunkClaimed(toChunk)) {
            Region fromRegion = ChunksManager.getRegionOwnsTheChunk(fromChunk);
            Region toRegion = ChunksManager.getRegionOwnsTheChunk(toChunk);
            if (fromRegion == null) {
                if (toRegion != null && !toRegion.isWorldFlagSet(2048L)) {
                    event.getVehicle().remove();
                }
            } else if (toRegion != null && !fromRegion.getUniqueId().equals(toRegion.getUniqueId()) && !toRegion.isWorldFlagSet(2048L)) {
                event.getVehicle().remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWitherBlockChange(EntityChangeBlockEvent event) {
        Region region;
        Block block;
        Chunk chunk;
        Entity entity = event.getEntity();
        if ((entity.getType() == EntityType.WITHER || entity.getType() == EntityType.WITHER_SKULL) && ChunksManager.isChunkClaimed(chunk = (block = event.getBlock()).getChunk()) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(256L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSnowGolemTrail(EntityBlockFormEvent event) {
        Region region;
        Block block;
        Chunk chunk;
        Entity entity = event.getEntity();
        if (entity instanceof Snowman && ChunksManager.isChunkClaimed(chunk = (block = event.getBlock()).getChunk()) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(262144L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent event) {
        Region region;
        Chunk chunk = event.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(4096L)) {
            event.setCancelled(true);
        }
    }

    private boolean isWearingElytra(Player player) {
        return player.getInventory().getChestplate() != null && player.getInventory().getChestplate().getType() == Material.ELYTRA;
    }

    private boolean isCropBlock(Block block) {
        Material type = block.getType();
        return type == Material.WHEAT || type == Material.CARROTS || type == Material.POTATOES || type == Material.BEETROOTS || type == Material.PITCHER_PLANT || type == Material.NETHER_WART || type == Material.KELP || type == Material.CACTUS || type == Material.SEA_PICKLE || type == Material.RED_MUSHROOM || type == Material.BROWN_MUSHROOM || type == Material.SWEET_BERRIES || type == Material.SWEET_BERRY_BUSH;
    }

    public static class RegionProtection {
        public static boolean hasPermission(Player player, Chunk chunk, Location location, long flag) {
            if (Homestead.config.getBoolean("special-feat.ignore-region-protection-if-action-in-disabled-world") && ChunksManager.isChunkInDisabledWorld(chunk)) {
                return true;
            }
            if (player != null && PlayerUtils.isOperator(player)) {
                return true;
            }
            if (!ChunksManager.isChunkClaimed(chunk)) {
                return true;
            }
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (region == null) {
                return true;
            }
            assert (player != null);
            if (region.isOwner((OfflinePlayer)player) && !List.of(Long.valueOf(0x8000000L), Long.valueOf(0x4000000L)).contains(flag)) {
                return true;
            }
            SubArea subArea = SubAreasManager.findSubAreaHasLocationInside(location);
            return subArea != null ? PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getUniqueId(), player, flag, true) : PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, flag, true);
        }

        public static void hasPermission(Player player, Chunk chunk, Location location, long flag, Runnable onTrue, Runnable onFalse) {
            if (Homestead.config.getBoolean("special-feat.ignore-region-protection-if-action-in-disabled-world") && ChunksManager.isChunkInDisabledWorld(chunk)) {
                if (onTrue != null) {
                    onTrue.run();
                }
                return;
            }
            boolean allowed = RegionProtection.hasPermission(player, chunk, location, flag);
            if (allowed && onTrue != null) {
                onTrue.run();
            }
            if (!allowed && onFalse != null) {
                onFalse.run();
            }
        }
    }

    public static class Explosives {
        public static boolean isExplosive(Entity e) {
            if (e == null) {
                return false;
            }
            if (e instanceof TNTPrimed) {
                return true;
            }
            if (e instanceof Creeper) {
                return true;
            }
            if (e instanceof Fireball) {
                return true;
            }
            if (e instanceof WitherSkull) {
                return true;
            }
            if (e instanceof EnderCrystal) {
                return true;
            }
            if (e instanceof WindCharge) {
                return true;
            }
            if (e instanceof Player) {
                return false;
            }
            return switch (e.getType()) {
                case EntityType.TNT, EntityType.TNT_MINECART, EntityType.CREEPER, EntityType.FIREBALL, EntityType.WITHER_SKULL, EntityType.END_CRYSTAL, EntityType.WIND_CHARGE -> true;
                default -> false;
            };
        }
    }

    public static class Projectiles {
        public static boolean isProjectile(Entity e) {
            return e instanceof Projectile;
        }

        public static boolean isPlayerProjectile(Entity e) {
            Projectile p;
            return e instanceof Projectile && (p = (Projectile)e).getShooter() instanceof Player;
        }

        public static boolean isMobProjectile(Entity e) {
            Projectile p;
            return e instanceof Projectile && (p = (Projectile)e).getShooter() instanceof LivingEntity && !(p.getShooter() instanceof Player);
        }
    }
}

