/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.borders.ChunkParticlesSpawner;
import tfagaming.projects.minecraft.homestead.integrations.WorldGuardAPI;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.autoclaim.AutoClaimSession;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chunks.ChunkBorder;
import tfagaming.projects.minecraft.homestead.tools.minecraft.limits.Limits;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public final class PlayerAutoClaimListener
implements Listener {
    private static final long CLAIM_COOLDOWN_MS = 500L;
    private final Map<Player, Chunk> lastChunks = new WeakHashMap<Player, Chunk>();
    private final Map<Player, Long> lastClaimAttempt = new WeakHashMap<Player, Long>();

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Chunk currentChunk = player.getLocation().getChunk();
        if (!AutoClaimSession.hasSession(player)) {
            return;
        }
        Chunk lastChunk = this.lastChunks.get(player);
        if (!currentChunk.equals((Object)lastChunk)) {
            this.tryToClaim(player, currentChunk);
            this.lastChunks.put(player, currentChunk);
        }
    }

    private void tryToClaim(Player player, Chunk chunk) {
        long now = System.currentTimeMillis();
        if (this.lastClaimAttempt.containsKey(player) && now - this.lastClaimAttempt.get(player) < 500L) {
            return;
        }
        this.lastClaimAttempt.put(player, now);
        if (ChunksManager.isChunkInDisabledWorld(chunk)) {
            PlayerUtils.sendMessage(player, 20);
            return;
        }
        boolean wgEnabled = Homestead.config.getBoolean("worldguard.protect-existing-regions");
        if (wgEnabled && WorldGuardAPI.isChunkInWorldGuardRegion(chunk)) {
            PlayerUtils.sendMessage(player, 133);
            return;
        }
        Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
        if (region == null) {
            if (!RegionsManager.getRegionsOwnedByPlayer((OfflinePlayer)player).isEmpty()) {
                TargetRegionSession.randomizeRegion(player);
                region = TargetRegionSession.getRegion((OfflinePlayer)player);
            } else {
                if (!player.hasPermission("homestead.region.create")) {
                    PlayerUtils.sendMessage(player, 8);
                    return;
                }
                if (Limits.hasReachedLimit((OfflinePlayer)player, null, Limits.LimitType.REGIONS)) {
                    PlayerUtils.sendMessage(player, 116);
                    return;
                }
                region = RegionsManager.createRegion(player.getName(), (OfflinePlayer)player, true);
                TargetRegionSession.newSession(player, region);
            }
        }
        if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 16L)) {
            return;
        }
        Region owner = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (owner != null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", owner.getName());
            PlayerUtils.sendMessage(player, 21, replacements);
            return;
        }
        if (Limits.hasReachedLimit(null, region, Limits.LimitType.CHUNKS_PER_REGION)) {
            PlayerUtils.sendMessage(player, 116);
            return;
        }
        int before = region.getChunks().size();
        ChunksManager.Error error = ChunksManager.claimChunk(region.getUniqueId(), chunk);
        int after = region.getChunks().size();
        if (error == null) {
            if (after > before) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 22, replacements);
            }
            if (region.getLocation() == null) {
                region.setLocation(player.getLocation());
            }
            if (!ChunkParticlesSpawner.isTaskRunning(player)) {
                ChunkBorder.show(player);
            }
        } else {
            switch (error) {
                case REGION_NOT_FOUND: {
                    PlayerUtils.sendMessage(player, 9);
                    break;
                }
                case CHUNK_NOT_ADJACENT_TO_REGION: {
                    PlayerUtils.sendMessage(player, 140);
                }
            }
        }
    }
}

