/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations.maps;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.integrations.maps.RegionIconTools;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;
import xyz.jpenilla.squaremap.api.marker.Polygon;
import xyz.jpenilla.squaremap.api.marker.Polyline;

public class SquaremapAPI {
    private static final Map<World, SimpleLayerProvider> layers = new HashMap<World, SimpleLayerProvider>();
    private static Squaremap api;

    public SquaremapAPI(Homestead plugin) {
        try {
            api = SquaremapProvider.get();
            this.update();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void clearAllMarkers() {
        for (SimpleLayerProvider layer : layers.values()) {
            if (layer == null) continue;
            layer.getMarkers().removeIf(__ -> true);
        }
    }

    public void addChunkMarker(Region region, SerializableChunk chunk) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", region.getName());
        replacements.put("{region-owner}", region.getOwner().getName());
        replacements.put("{region-members}", ChatColorTranslator.removeColor(Formatters.getMembersOfRegion(region), false));
        replacements.put("{region-chunks}", String.valueOf(region.getChunks().size()));
        replacements.put("{global-rank}", String.valueOf(RegionsManager.getGlobalRank(region.getUniqueId())));
        replacements.put("{region-description}", region.getDescription());
        replacements.put("{region-size}", String.valueOf(region.getChunks().size() * 256));
        boolean isOperator = PlayerUtils.isOperator(region.getOwner());
        String hoverText = Formatters.replace(isOperator ? Homestead.config.getString("dynamic-maps.chunks.operator-description") : Homestead.config.getString("dynamic-maps.chunks.description"), replacements);
        int chunkColor = region.getMapColor() == 0 ? (isOperator ? Homestead.config.getInt("dynamic-maps.chunks.operator-color") : Homestead.config.getInt("dynamic-maps.chunks.color")) : region.getMapColor();
        World world = chunk.getWorld();
        SimpleLayerProvider targetLayer = layers.get(world);
        if (targetLayer == null) {
            String layerId = "claims_" + world.getName();
            MapWorld mapWorld = api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).orElse(null);
            if (mapWorld != null) {
                SimpleLayerProvider layer = SimpleLayerProvider.builder((String)"Homestead Regions").showControls(true).defaultHidden(false).layerPriority(1).zIndex(250).build();
                mapWorld.layerRegistry().register(Key.of((String)layerId), (Object)layer);
                layers.put(world, layer);
                targetLayer = layer;
            }
        }
        this.addChunkMarkerWithOptions(targetLayer, chunk, hoverText, chunkColor, !this.isChunkClaimed(region, chunk, GeoDirection.NORTH), !this.isChunkClaimed(region, chunk, GeoDirection.EAST), !this.isChunkClaimed(region, chunk, GeoDirection.SOUTH), !this.isChunkClaimed(region, chunk, GeoDirection.WEST));
        boolean isEnabled = Homestead.config.getBoolean("dynamic-maps.icons.enabled");
        if (isEnabled) {
            SimpleLayerProvider targetLayerFinal = targetLayer;
            if (region.getLocation() != null && region.getLocation().getBukkitLocation().getChunk().equals((Object)chunk.getBukkitChunk())) {
                Homestead.getInstance().runAsyncTask(() -> this.addRegionIcon(targetLayerFinal, region, hoverText));
            }
        }
    }

    private void addRegionIcon(SimpleLayerProvider targetLayer, Region region, String hoverText) {
        BufferedImage bufferedIcon = RegionIconTools.getIconBufferedImage(region.getIcon());
        int iconSize = Homestead.config.getInt("dynamic-maps.icons.size");
        if (region.getLocation() == null) {
            return;
        }
        if (bufferedIcon != null) {
            try {
                Key iconKey = Key.of((String)("region_icon_" + region.getName().toLowerCase().replaceAll(" ", "_")));
                Location regionLocation = region.getLocation().getBukkitLocation();
                Point iconPoint = Point.of((double)regionLocation.getX(), (double)regionLocation.getZ());
                if (api.iconRegistry().hasEntry(iconKey) && !((BufferedImage)api.iconRegistry().get(iconKey)).equals(bufferedIcon)) {
                    api.iconRegistry().unregister(iconKey);
                }
                if (!api.iconRegistry().hasEntry(iconKey) && bufferedIcon != null) {
                    api.iconRegistry().register(iconKey, (Object)bufferedIcon);
                }
                Icon icon = Marker.icon((Point)iconPoint, (Key)iconKey, (int)iconSize, (int)iconSize);
                MarkerOptions iconOptions = MarkerOptions.builder().hoverTooltip(hoverText).build();
                icon.markerOptions(iconOptions);
                targetLayer.addMarker(iconKey, (Marker)icon);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addChunkMarkerWithOptions(SimpleLayerProvider targetLayer, SerializableChunk chunk, String hoverText, int chunkColor, boolean north, boolean east, boolean south, boolean west) {
        this.addChunkMarkerWithOptions(targetLayer, chunk, hoverText, chunkColor, north, east, south, west, 0.0);
    }

    private void addChunkMarkerWithOptions(SimpleLayerProvider targetLayer, SerializableChunk chunk, String hoverText, int chunkColor, boolean north, boolean east, boolean south, boolean west, double offset) {
        double minX = (double)chunk.getX() * 16.0;
        double minZ = (double)chunk.getZ() * 16.0;
        double maxX = minX + 16.0;
        double maxZ = minZ + 16.0;
        double offsetMinX = minX + offset;
        double offsetMinZ = minZ + offset;
        double offsetMaxX = maxX - offset;
        double offsetMaxZ = maxZ - offset;
        Point topLeft = Point.of((double)offsetMinX, (double)offsetMinZ);
        Point topRight = Point.of((double)offsetMaxX, (double)offsetMinZ);
        Point bottomLeft = Point.of((double)offsetMinX, (double)offsetMaxZ);
        Point bottomRight = Point.of((double)offsetMaxX, (double)offsetMaxZ);
        Key chunkKey = Key.of((String)("chunk_" + chunk.getX() + "_" + chunk.getZ()));
        Polygon fillArea = Marker.polygon(List.of(topLeft, topRight, bottomRight, bottomLeft, topLeft));
        int chunkTransparencyInfill = Homestead.config.getInt("dynamic-maps.chunks.transparency-fill");
        int chunkTransparencyOutline = Homestead.config.getInt("dynamic-maps.chunks.transparency-outline");
        MarkerOptions fillOptions = MarkerOptions.builder().hoverTooltip(hoverText).fillColor(this.applyAlpha(chunkColor, chunkTransparencyInfill)).strokeColor(this.applyAlpha(chunkColor, chunkTransparencyOutline)).strokeWeight(0).fill(true).stroke(false).build();
        fillArea.markerOptions(fillOptions);
        targetLayer.addMarker(Key.of((String)(String.valueOf(chunkKey) + "_fill")), (Marker)fillArea);
        MarkerOptions borderOptions = MarkerOptions.builder().strokeColor(this.applyAlpha(chunkColor, 255)).strokeWeight(2).stroke(true).fill(false).build();
        if (north) {
            Polyline topBorder = Marker.polyline(List.of(topLeft, topRight));
            topBorder.markerOptions(borderOptions);
            targetLayer.addMarker(Key.of((String)(String.valueOf(chunkKey) + "_north")), (Marker)topBorder);
        }
        if (east) {
            Polyline rightBorder = Marker.polyline(List.of(topRight, bottomRight));
            rightBorder.markerOptions(borderOptions);
            targetLayer.addMarker(Key.of((String)(String.valueOf(chunkKey) + "_east")), (Marker)rightBorder);
        }
        if (south) {
            Polyline bottomBorder = Marker.polyline(List.of(bottomLeft, bottomRight));
            bottomBorder.markerOptions(borderOptions);
            targetLayer.addMarker(Key.of((String)(String.valueOf(chunkKey) + "_south")), (Marker)bottomBorder);
        }
        if (west) {
            Polyline leftBorder = Marker.polyline(List.of(topLeft, bottomLeft));
            leftBorder.markerOptions(borderOptions);
            targetLayer.addMarker(Key.of((String)(String.valueOf(chunkKey) + "_west")), (Marker)leftBorder);
        }
    }

    public boolean isChunkClaimed(Region region, SerializableChunk chunk, GeoDirection direction) {
        int x = chunk.getX();
        int z = chunk.getZ();
        World world = chunk.getWorld();
        return switch (direction.ordinal()) {
            case 0 -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x, z - 1).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            case 1 -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x + 1, z).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            case 2 -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x, z + 1).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            case 3 -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x - 1, z).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            default -> false;
        };
    }

    public void update() {
        this.clearAllMarkers();
        for (Region region : RegionsManager.getAll()) {
            for (SerializableChunk chunk : region.getChunks()) {
                this.addChunkMarker(region, chunk);
            }
        }
    }

    private Color applyAlpha(int color, int alpha) {
        return new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha);
    }

    private static enum GeoDirection {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

