/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations.maps;

import com.flowpowered.math.vector.Vector2i;
import com.technicjelle.BMUtils.Cheese;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class BlueMapAPI {
    private static final String MARKER_SET_ID = "homestead:regions";
    private final Map<World, MarkerSet> markerSets = new HashMap<World, MarkerSet>();
    private final de.bluecolored.bluemap.api.BlueMapAPI api;

    public BlueMapAPI(Homestead plugin, de.bluecolored.bluemap.api.BlueMapAPI api) {
        this.api = api;
        this.update();
    }

    public void clearAllMarkers() {
        for (BlueMapMap map : this.api.getMaps()) {
            MarkerSet set = (MarkerSet)map.getMarkerSets().get(MARKER_SET_ID);
            if (set == null) continue;
            set.getMarkers().clear();
        }
        for (MarkerSet cached : this.markerSets.values()) {
            cached.getMarkers().clear();
        }
    }

    public MarkerSet getOrNewMarkerSet(World world) {
        if (world == null) {
            return null;
        }
        MarkerSet set = this.markerSets.computeIfAbsent(world, w -> MarkerSet.builder().label("Homestead Regions").build());
        this.api.getWorld((Object)world).ifPresent(bmWorld -> {
            for (BlueMapMap map : bmWorld.getMaps()) {
                Map mapSets = map.getMarkerSets();
                if (mapSets.get(MARKER_SET_ID) == set) continue;
                mapSets.put(MARKER_SET_ID, set);
            }
        });
        return set;
    }

    public void addRegionMarker(Region region) {
        Collection<Cheese> platter;
        if (region == null || region.getChunks() == null || region.getChunks().isEmpty()) {
            return;
        }
        boolean isOperator = PlayerUtils.isOperator(region.getOwner());
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", region.getName());
        replacements.put("{region-owner}", region.getOwner().getName());
        replacements.put("{region-members}", ChatColorTranslator.removeColor(Formatters.getMembersOfRegion(region), false));
        replacements.put("{region-chunks}", String.valueOf(region.getChunks().size()));
        replacements.put("{global-rank}", String.valueOf(RegionsManager.getGlobalRank(region.getUniqueId())));
        replacements.put("{region-description}", region.getDescription());
        replacements.put("{region-size}", String.valueOf(region.getChunks().size() * 256));
        String hoverTextRaw = Formatters.replace(isOperator ? Homestead.config.getString("dynamic-maps.chunks.operator-description") : Homestead.config.getString("dynamic-maps.chunks.description"), replacements);
        Object plainLabel = region.getName() + " (#" + RegionsManager.getGlobalRank(region.getUniqueId()) + ")";
        plainLabel = ChatColorTranslator.removeColor((String)plainLabel, false).replaceAll("<[^>]*>", "").replaceAll("&lt;[^&]*&gt;", "").trim();
        String hoverText = hoverTextRaw.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        int chunkColor = region.getMapColor() == 0 ? (isOperator ? Homestead.config.getInt("dynamic-maps.chunks.operator-color") : Homestead.config.getInt("dynamic-maps.chunks.color")) : region.getMapColor();
        int chunkTransparencyInfill = Homestead.config.getInt("dynamic-maps.chunks.transparency-fill");
        int chunkTransparencyOutline = Homestead.config.getInt("dynamic-maps.chunks.transparency-outline");
        World world = this.resolveRegionWorld(region);
        if (world == null) {
            return;
        }
        MarkerSet markerSet = this.getOrNewMarkerSet(world);
        if (markerSet == null) {
            return;
        }
        Map markers = markerSet.getMarkers();
        Vector2i[] chunkCoordinates = (Vector2i[])region.getChunks().stream().map(sc -> new Vector2i(sc.getX(), sc.getZ())).toArray(Vector2i[]::new);
        if (chunkCoordinates.length == 0) {
            return;
        }
        try {
            platter = Cheese.createPlatterFromChunks(chunkCoordinates);
        }
        catch (Throwable t2) {
            Homestead.getInstance().getLogger().log(Level.WARNING, "BlueMap: Could not create shapes for region " + region.getName() + " (" + String.valueOf(region.getUniqueId()) + "): " + t2.getMessage(), t2);
            return;
        }
        float minY = world.getMinHeight();
        float maxY = world.getMaxHeight();
        int i = 0;
        for (Cheese cheese : platter) {
            ExtrudeMarker.Builder builder = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label((String)plainLabel)).detail(hoverText)).shape(cheese.getShape(), minY, maxY).fillColor(new Color(chunkColor, chunkTransparencyInfill)).lineColor(new Color(chunkColor, chunkTransparencyOutline)).lineWidth(2).depthTestEnabled(false);
            if (!cheese.getHoles().isEmpty()) {
                builder.holes((Shape[])cheese.getHoles().toArray(Shape[]::new));
            }
            ExtrudeMarker marker = builder.build();
            String markerId = "region-" + String.valueOf(region.getUniqueId()) + "-area-" + i++;
            markers.put(markerId, marker);
        }
        this.addRegionSpawnLocation(world, markerSet, region, hoverText);
    }

    public void addRegionSpawnLocation(World world, MarkerSet markerSet, Region region, String hoverText) {
        if (markerSet == null || region == null || region.getLocation() == null) {
            return;
        }
        Location loc = region.getLocation().getBukkitLocation();
        if (loc == null || loc.getWorld() == null || !loc.getWorld().equals((Object)world)) {
            return;
        }
        POIMarker marker = ((POIMarker.Builder)((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label(region.getName() + " Home")).detail(hoverText).position(loc.getX(), loc.getY(), loc.getZ())).maxDistance(1000.0)).build();
        String markerId = "region-" + String.valueOf(region.getUniqueId()) + "-home";
        markerSet.getMarkers().put(markerId, marker);
    }

    public void update() {
        this.clearAllMarkers();
        for (Region region : RegionsManager.getAll()) {
            this.addRegionMarker(region);
        }
    }

    private World resolveRegionWorld(Region region) {
        if (region.getLocation() != null && region.getLocation().getWorld() != null) {
            return region.getLocation().getWorld();
        }
        if (region.getChunks() != null) {
            for (SerializableChunk sc : region.getChunks()) {
                World byName;
                if (sc == null) continue;
                World w = sc.getWorld();
                if (w != null) {
                    return w;
                }
                if (sc.getWorldName() == null || (byName = Bukkit.getWorld((String)sc.getWorldName())) == null) continue;
                return byName;
            }
        }
        return null;
    }
}

