/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.plugin.Plugin;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.database.Database;
import tfagaming.projects.minecraft.homestead.integrations.DynamicMaps;
import tfagaming.projects.minecraft.homestead.integrations.bstats.Metrics;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.managers.WarsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;

public class bStats {
    public bStats(Homestead plugin) {
        try {
            Metrics metrics = new Metrics((Plugin)plugin, 25286);
            metrics.addCustomChart(new Metrics.SingleLineChart("regions", new Callable<Integer>(this){

                @Override
                public Integer call() throws Exception {
                    return RegionsManager.getAll().size();
                }
            }));
            metrics.addCustomChart(new Metrics.SingleLineChart("subareas", new Callable<Integer>(this){

                @Override
                public Integer call() throws Exception {
                    return SubAreasManager.getAll().size();
                }
            }));
            metrics.addCustomChart(new Metrics.SingleLineChart("trusted_players", new Callable<Integer>(this){

                @Override
                public Integer call() throws Exception {
                    int players = 0;
                    for (Region region : RegionsManager.getAll()) {
                        players += region.getMembers().size();
                    }
                    return players;
                }
            }));
            metrics.addCustomChart(new Metrics.SingleLineChart("chunks", new Callable<Integer>(this){

                @Override
                public Integer call() throws Exception {
                    int chunks = 0;
                    for (Region region : RegionsManager.getAll()) {
                        chunks += region.getChunks().size();
                    }
                    return chunks;
                }
            }));
            metrics.addCustomChart(new Metrics.AdvancedPie("database_provider", new Callable<Map<String, Integer>>(this){

                @Override
                public Map<String, Integer> call() throws Exception {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    switch (Database.parseProviderFromString(Homestead.database.getSelectedProvider())) {
                        case PostgreSQL: {
                            map.put("PostgreSQL", 1);
                            break;
                        }
                        case MariaDB: {
                            map.put("MariaDB", 1);
                            break;
                        }
                        case MySQL: {
                            map.put("MySQL", 1);
                            break;
                        }
                        case SQLite: {
                            map.put("SQLite", 1);
                            break;
                        }
                        case YAML: {
                            map.put("YAML", 1);
                            break;
                        }
                    }
                    return map;
                }
            }));
            metrics.addCustomChart(new Metrics.AdvancedPie("dynamic_maps", new Callable<Map<String, Integer>>(this){

                @Override
                public Map<String, Integer> call() throws Exception {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("Dynmap", DynamicMaps.dynmap == null ? 0 : 1);
                    map.put("Squaremap", DynamicMaps.squaremap == null ? 0 : 1);
                    map.put("Pl3xMap", DynamicMaps.pl3xmap == null ? 0 : 1);
                    map.put("BlueMap", DynamicMaps.bluemap == null ? 0 : 1);
                    return map;
                }
            }));
            metrics.addCustomChart(new Metrics.SingleLineChart("wars", new Callable<Integer>(this){

                @Override
                public Integer call() throws Exception {
                    return WarsManager.getAll().size();
                }
            }));
        }
        catch (IllegalStateException | NoClassDefFoundError e) {
            Logger.error("Unable to communicate with bStats servers.");
        }
    }
}

