/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.WarsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.limits.Limits;
import tfagaming.projects.minecraft.homestead.tools.other.UpkeepUtils;

public class PlaceholderAPI
extends PlaceholderExpansion {
    private final Homestead plugin;

    public PlaceholderAPI(Homestead plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "Homestead";
    }

    @NotNull
    public String getAuthor() {
        return "TayebYassine";
    }

    @NotNull
    public String getVersion() {
        String string = this.plugin.getDescription().getVersion();
        if (string == null) {
            PlaceholderAPI.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (params == null) {
            PlaceholderAPI.$$$reportNull$$$0(1);
        }
        if (player == null) {
            return "";
        }
        Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
        Region currentRegion = ChunksManager.getRegionOwnsTheChunk(player.getLocation().getChunk());
        return switch (params.toLowerCase()) {
            case "region_bank" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_bank");
                }
                yield Formatters.formatBalance(region.getBank());
            }
            case "region_name" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_name");
                }
                yield region.getName();
            }
            case "region_claimed_chunks" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_claimed_chunks");
                }
                yield String.valueOf(region.getChunks().size());
            }
            case "region_max_chunks" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_max_chunks");
                }
                yield String.valueOf(Limits.getPlayerLimit((OfflinePlayer)player, Limits.LimitType.CHUNKS_PER_REGION));
            }
            case "region_trusted_members" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_trusted_members");
                }
                yield String.valueOf(region.getMembers().size());
            }
            case "region_max_members" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_max_members");
                }
                yield String.valueOf(Limits.getPlayerLimit((OfflinePlayer)player, Limits.LimitType.MEMBERS_PER_REGION));
            }
            case "region_current" -> {
                if (currentRegion == null) {
                    yield Homestead.config.getString("placeholderapi.default.region_current");
                }
                yield currentRegion.getName();
            }
            case "upkeep_amount" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.upkeep_amount");
                }
                yield Formatters.formatBalance(UpkeepUtils.getAmountToPay(region));
            }
            case "upkeep_at" -> {
                if (region == null) {
                    yield Homestead.config.getString("placeholderapi.default.upkeep_at");
                }
                yield Formatters.formatDate(region.getUpkeepAt());
            }
            case "war_name" -> {
                if (region == null || !WarsManager.isRegionInWar(region.getUniqueId())) {
                    yield Homestead.config.getString("placeholderapi.default.war_name");
                }
                yield WarsManager.findWarByRegionId(region.getUniqueId()).getName();
            }
            case "war_prize" -> {
                if (region == null || !WarsManager.isRegionInWar(region.getUniqueId())) {
                    yield Homestead.config.getString("placeholderapi.default.war_prize");
                }
                yield Formatters.formatBalance(WarsManager.findWarByRegionId(region.getUniqueId()).getPrize());
            }
            default -> null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tfagaming/projects/minecraft/homestead/integrations/PlaceholderAPI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "tfagaming/projects/minecraft/homestead/integrations/PlaceholderAPI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onPlaceholderRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

