/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionInfoMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.TopMembersRegionMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.TopRatingRegionsMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;

public class TopOldestRegionMenu {
    List<Region> regions = new ArrayList<Region>();

    public TopOldestRegionMenu(Player player) {
        this.regions.addAll(RegionsManager.sortRegions(RegionsManager.RegionSorting.CREATION_DATE));
        this.regions = ListUtils.removeDuplications(this.regions);
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(21), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player), (_player, event) -> _player.closeInventory(), (_player, context) -> {
            if (context.getIndex() >= this.regions.size()) {
                return;
            }
            Region region = this.regions.get(context.getIndex());
            if (context.getEvent().isLeftClick()) {
                new RegionInfoMenu(player, region, () -> new TopOldestRegionMenu(player));
            }
        });
        gui.addActionButton(1, MenuUtils.getButton(59, new OfflinePlayer[0]), (_player, event) -> {
            if (event.isLeftClick()) {
                new TopRatingRegionsMenu(player);
            } else if (event.isRightClick()) {
                new TopMembersRegionMenu(player);
            }
            player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.regions.size(); ++i) {
            Region region = this.regions.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{rank}", String.valueOf(i + 1));
            replacements.put("{region}", region.getName());
            replacements.put("{region-displayname}", region.getDisplayName());
            replacements.put("{region-owner}", region.getOwner().getName());
            replacements.put("{region-bank}", Formatters.formatBalance(region.getBank()));
            replacements.put("{region-createdat}", Formatters.formatDate(region.getCreatedAt()));
            replacements.put("{region-rating}", Formatters.formatRating(RegionsManager.getAverageRating(region)));
            replacements.put("{region-members}", String.valueOf(region.getMembers().size()));
            replacements.put("{region-chunks}", String.valueOf(region.getChunks().size()));
            items.add(MenuUtils.getButton(55, replacements, new OfflinePlayer[0]));
        }
        return items;
    }
}

