/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.Menu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaFlagsMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaMembersMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreasMenu;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.sessions.playerinput.PlayerInputSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.StringUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class SubAreaSettingsMenu {
    public SubAreaSettingsMenu(Player player, Region region, SubArea subArea) {
        Menu gui = new Menu(MenuUtils.getTitle(15).replace("{subarea}", subArea.getName()), 27);
        boolean isEconomyEnabled = Homestead.vault.isEconomyReady();
        boolean isRentEnabled = isEconomyEnabled && Homestead.config.getBoolean("renting.enabled");
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{subarea}", subArea.getName());
        ItemStack renameSubAreaButton = MenuUtils.getButton(43, replacements, new OfflinePlayer[0]);
        gui.addItem(11, renameSubAreaButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.rename")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                String oldName = subArea.getName();
                subArea.setName((String)input);
                replacements.put("{oldname}", oldName);
                replacements.put("{newname}", (String)input);
                PlayerUtils.sendMessage(player, 61, (Map<String, String>)replacements);
                Homestead.getInstance().runSyncTask(() -> new SubAreaSettingsMenu(player, region, subArea));
            }, (Function<String, Boolean>)((Function)message -> {
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                    return false;
                }
                if (!StringUtils.isValidSubAreaName(message)) {
                    PlayerUtils.sendMessage(player, 57);
                    return false;
                }
                if (subArea.getName().equalsIgnoreCase((String)message)) {
                    PlayerUtils.sendMessage(player, 11);
                    return false;
                }
                if (SubAreasManager.isNameUsed(region.getUniqueId(), message)) {
                    PlayerUtils.sendMessage(player, 58);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new SubAreaSettingsMenu(player, region, subArea)), 88);
        });
        ItemStack flagsSubAreabutton = MenuUtils.getButton(44, replacements, new OfflinePlayer[0]);
        gui.addItem(12, flagsSubAreabutton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.flags")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            new SubAreaFlagsMenu(player, region, subArea);
        });
        replacements.put("{subarea-players}", String.valueOf(subArea.getMembers().size()));
        ItemStack membersSubAreabutton = MenuUtils.getButton(70, replacements, new OfflinePlayer[0]);
        gui.addItem(13, membersSubAreabutton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.flags")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            new SubAreaMembersMenu(player, region, subArea);
        });
        SerializableRent rent = subArea.getRent();
        if (rent != null) {
            replacements.put("{rent-enabled}", Formatters.getEnabled(isRentEnabled));
            replacements.put("{rent-renter}", rent.getPlayer().getName());
            replacements.put("{rent-price}", Formatters.formatBalance(rent.getPrice()));
            replacements.put("{rent-until}", Formatters.formatRemainingTime(rent.getUntilAt()));
        } else {
            replacements.put("{rent-enabled}", Formatters.getEnabled(isRentEnabled));
            replacements.put("{rent-renter}", Formatters.getNone());
            replacements.put("{rent-price}", Formatters.getNone());
            replacements.put("{rent-until}", Formatters.getNone());
        }
        ItemStack rentButton = MenuUtils.getButton(71, replacements, new OfflinePlayer[0]);
        gui.addItem(14, rentButton, (_player, event) -> {
            if (event.isLeftClick()) {
                boolean isOwnerOrOperator;
                boolean bl = isOwnerOrOperator = PlayerUtils.isOperator(player) || region.isOwner((OfflinePlayer)player);
                if (!isOwnerOrOperator) {
                    PlayerUtils.sendMessage(player, 159);
                    return;
                }
                if (subArea.getRent() == null) {
                    PlayerUtils.sendMessage(player, 195);
                } else {
                    subArea.setRent(null);
                    PlayerUtils.sendMessage(player, 127);
                    new SubAreaSettingsMenu(player, region, subArea);
                }
            }
        });
        ItemStack deleteSubAreaButton = MenuUtils.getButton(45, replacements, new OfflinePlayer[0]);
        gui.addItem(15, deleteSubAreaButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.delete")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                return;
            }
            SubAreasManager.deleteSubArea(subArea.getUniqueId());
            PlayerUtils.sendMessage(player, 62, (Map<String, String>)replacements);
            new SubAreasMenu(player, region);
        });
        gui.addItem(18, MenuUtils.getBackButton(), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            new SubAreasMenu(player, region);
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

