/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation.DelayedTeleport;

public class RegionsWithWelcomeSignsMenu {
    List<Region> regions = new ArrayList<Region>();

    public RegionsWithWelcomeSignsMenu(Player player) {
        this.regions.addAll(RegionsManager.getRegionsWithWelcomeSigns());
        this.regions = ListUtils.removeDuplications(this.regions);
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(0), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player), (_player, event) -> _player.closeInventory(), (_player, context) -> {
            if (context.getIndex() >= this.regions.size()) {
                return;
            }
            Region region = this.regions.get(context.getIndex());
            if (context.getEvent().isLeftClick()) {
                player.closeInventory();
                new DelayedTeleport(player, region.getWelcomeSign().getBukkitLocation());
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Region region : this.regions) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{region-displayname}", region.getDisplayName());
            replacements.put("{region-owner}", region.getOwner().getName());
            replacements.put("{region-bank}", Formatters.formatBalance(region.getBank()));
            replacements.put("{region-createdat}", Formatters.formatDate(region.getCreatedAt()));
            replacements.put("{region-rating}", Formatters.formatRating(RegionsManager.getAverageRating(region)));
            items.add(MenuUtils.getButton(47, replacements, new OfflinePlayer[0]));
        }
        return items;
    }
}

