/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.ManagePlayersMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.playerinput.PlayerInputSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.tools.minecraft.limits.Limits;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class RegionInvitedPlayersMenu {
    List<OfflinePlayer> invitedPlayers;

    public RegionInvitedPlayersMenu(Player player, Region region) {
        this.invitedPlayers = region.getInvitedPlayers();
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(10), 36, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player, region), (_player, event) -> new ManagePlayersMenu(player, region), (_player, context) -> {
            if (context.getIndex() >= this.invitedPlayers.size()) {
                return;
            }
            OfflinePlayer invitedPlayer = this.invitedPlayers.get(context.getIndex());
            if (context.getEvent().isLeftClick() && region.isPlayerInvited(invitedPlayer)) {
                region.removePlayerInvite(invitedPlayer);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{playername}", invitedPlayer.getName());
                PlayerUtils.sendMessage(player, 37, replacements);
                PaginationMenu instance = context.getInstance();
                this.invitedPlayers = region.getInvitedPlayers();
                instance.setItems(this.getItems(player, region));
            }
        });
        gui.addActionButton(0, MenuUtils.getButton(29, new OfflinePlayer[0]), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.players.trust")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                OfflinePlayer targetPlayer = Homestead.getInstance().getOfflinePlayerSync((String)input);
                if (Homestead.config.getBoolean("special-feat.ignore-trust-acceptance-system")) {
                    region.removePlayerInvite(targetPlayer);
                    region.addMember(targetPlayer);
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{region}", region.getName());
                    replacements.put("{playername}", targetPlayer.getName());
                    PlayerUtils.sendMessage(player, 199, replacements);
                } else {
                    region.addPlayerInvite(targetPlayer);
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", targetPlayer.getName());
                    replacements.put("{region}", region.getName());
                    PlayerUtils.sendMessage(player, 36, replacements);
                    RegionsManager.addNewLog(region.getUniqueId(), 2, replacements);
                }
                Homestead.getInstance().runSyncTask(() -> new RegionInvitedPlayersMenu(player, region));
            }, (Function<String, Boolean>)((Function)message -> {
                OfflinePlayer target = Homestead.getInstance().getOfflinePlayerSync((String)message);
                if (target == null) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", (String)message);
                    PlayerUtils.sendMessage(player, 29, replacements);
                    return false;
                }
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 1L)) {
                    return false;
                }
                if (region.isPlayerBanned(target)) {
                    PlayerUtils.sendMessage(player, 74);
                    return false;
                }
                if (region.isPlayerMember(target)) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", target.getName());
                    PlayerUtils.sendMessage(player, 48, replacements);
                    return false;
                }
                if (region.isPlayerInvited(target)) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", target.getName());
                    PlayerUtils.sendMessage(player, 35, replacements);
                    return false;
                }
                if (region.isOwner(target)) {
                    PlayerUtils.sendMessage(player, 30);
                    return false;
                }
                SerializableRent rent = region.getRent();
                if (rent != null && rent.getPlayerId().equals(target.getUniqueId())) {
                    PlayerUtils.sendMessage(player, 196);
                    return false;
                }
                if (Limits.hasReachedLimit(null, region, Limits.LimitType.MEMBERS_PER_REGION)) {
                    PlayerUtils.sendMessage(player, 116);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new RegionInvitedPlayersMenu(player, region)), 75);
        });
        gui.addActionButton(2, MenuUtils.getButton(31, new OfflinePlayer[0]), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (region.getInvitedPlayers().isEmpty()) {
                PlayerUtils.sendMessage(player, 76);
                return;
            }
            region.setInvitedPlayers(new ArrayList<OfflinePlayer>());
            PlayerUtils.sendMessage(player, 95);
            Homestead.getInstance().runSyncTask(() -> new RegionInvitedPlayersMenu(player, region));
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player, Region region) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.invitedPlayers.size(); ++i) {
            OfflinePlayer invitedPlayer = this.invitedPlayers.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{playername}", invitedPlayer.getName());
            items.add(MenuUtils.getButton(30, replacements, new OfflinePlayer[0]));
        }
        return items;
    }
}

