/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database;

import java.io.IOException;
import java.sql.SQLException;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.database.providers.MariaDB;
import tfagaming.projects.minecraft.homestead.database.providers.MySQL;
import tfagaming.projects.minecraft.homestead.database.providers.PostgreSQL;
import tfagaming.projects.minecraft.homestead.database.providers.SQLite;
import tfagaming.projects.minecraft.homestead.database.providers.YAML;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class Database {
    private final Provider provider;
    private PostgreSQL postgreSQL;
    private MariaDB mariaDB;
    private MySQL mySQL;
    private SQLite sqLite;
    private YAML yaml;

    public Database(Provider provider) throws ClassNotFoundException, SQLException, IOException {
        this.provider = provider;
        Logger.warning("Attempting to connect to database... Provider: " + provider.toString());
        switch (provider.ordinal()) {
            case 0: {
                this.postgreSQL = new PostgreSQL(Homestead.config.getString("database.postgresql.username"), Homestead.config.getString("database.postgresql.password"), Homestead.config.getString("database.postgresql.host"), Homestead.config.getInt("database.postgresql.port"), Homestead.config.getString("database.postgresql.database"), Homestead.config.getString("database.postgresql.table_prefix"));
                break;
            }
            case 1: {
                this.mariaDB = new MariaDB(Homestead.config.getString("database.mariadb.username"), Homestead.config.getString("database.mariadb.password"), Homestead.config.getString("database.mariadb.host"), Homestead.config.getInt("database.mariadb.port"), Homestead.config.getString("database.mariadb.database"), Homestead.config.getString("database.mariadb.table_prefix"));
                break;
            }
            case 2: {
                this.mySQL = new MySQL(Homestead.config.getString("database.mysql.username"), Homestead.config.getString("database.mysql.password"), Homestead.config.getString("database.mysql.host"), Homestead.config.getInt("database.mysql.port"), Homestead.config.getString("database.mysql.database"), Homestead.config.getString("database.mysql.table_prefix"));
                break;
            }
            case 3: {
                this.sqLite = new SQLite(Homestead.config.getString("database.sqlite"));
                break;
            }
            case 4: {
                this.yaml = new YAML(Homestead.getInstance().getDataFolder());
                break;
            }
        }
    }

    public static Provider parseProviderFromString(String provider) {
        return switch (provider.toLowerCase()) {
            case "postgresql" -> Provider.PostgreSQL;
            case "mariadb" -> Provider.MariaDB;
            case "mysql" -> Provider.MySQL;
            case "sqlite" -> Provider.SQLite;
            case "yaml" -> Provider.YAML;
            default -> null;
        };
    }

    public String getSelectedProvider() {
        return this.provider.toString();
    }

    public void importRegions() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.importRegions();
                break;
            }
            case 1: {
                this.mariaDB.importRegions();
                break;
            }
            case 2: {
                this.mySQL.importRegions();
                break;
            }
            case 3: {
                this.sqLite.importRegions();
                break;
            }
            case 4: {
                this.yaml.importRegions();
                break;
            }
        }
    }

    public void importWars() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.importWars();
                break;
            }
            case 1: {
                this.mariaDB.importWars();
                break;
            }
            case 2: {
                this.mySQL.importWars();
                break;
            }
            case 3: {
                this.sqLite.importWars();
                break;
            }
            case 4: {
                this.yaml.importWars();
                break;
            }
        }
    }

    public void importSubAreas() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.importSubAreas();
                break;
            }
            case 1: {
                this.mariaDB.importSubAreas();
                break;
            }
            case 2: {
                this.mySQL.importSubAreas();
                break;
            }
            case 3: {
                this.sqLite.importSubAreas();
                break;
            }
            case 4: {
                this.yaml.importSubAreas();
                break;
            }
        }
    }

    public void importLevels() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.importLevels();
                break;
            }
            case 1: {
                this.mariaDB.importLevels();
                break;
            }
            case 2: {
                this.mySQL.importLevels();
                break;
            }
            case 3: {
                this.sqLite.importLevels();
                break;
            }
            case 4: {
                this.yaml.importLevels();
                break;
            }
        }
    }

    public void exportRegions() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.exportRegions();
                break;
            }
            case 1: {
                this.mariaDB.exportRegions();
                break;
            }
            case 2: {
                this.mySQL.exportRegions();
                break;
            }
            case 3: {
                this.sqLite.exportRegions();
                break;
            }
            case 4: {
                this.yaml.exportRegions();
                break;
            }
        }
    }

    public void exportWars() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.exportWars();
                break;
            }
            case 1: {
                this.mariaDB.exportWars();
                break;
            }
            case 2: {
                this.mySQL.exportWars();
                break;
            }
            case 3: {
                this.sqLite.exportWars();
                break;
            }
            case 4: {
                this.yaml.exportWars();
                break;
            }
        }
    }

    public void exportSubAreas() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.exportSubAreas();
                break;
            }
            case 1: {
                this.mariaDB.exportSubAreas();
                break;
            }
            case 2: {
                this.mySQL.exportSubAreas();
                break;
            }
            case 3: {
                this.sqLite.exportSubAreas();
                break;
            }
            case 4: {
                this.yaml.exportSubAreas();
                break;
            }
        }
    }

    public void exportLevels() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.exportLevels();
                break;
            }
            case 1: {
                this.mariaDB.exportLevels();
                break;
            }
            case 2: {
                this.mySQL.exportLevels();
                break;
            }
            case 3: {
                this.sqLite.exportLevels();
                break;
            }
            case 4: {
                this.yaml.exportLevels();
                break;
            }
        }
    }

    public void closeConnection() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.closeConnection();
                break;
            }
            case 1: {
                this.mariaDB.closeConnection();
                break;
            }
            case 2: {
                this.mySQL.closeConnection();
                break;
            }
            case 3: {
                this.sqLite.closeConnection();
                break;
            }
            case 4: {
                this.yaml.closeConnection();
                break;
            }
        }
    }

    public long getLatency() {
        return switch (this.provider.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.postgreSQL.getLatency();
            case 1 -> this.mariaDB.getLatency();
            case 2 -> this.mySQL.getLatency();
            case 3 -> this.sqLite.getLatency();
            case 4 -> this.yaml.getLatency();
        };
    }

    public static enum Provider {
        PostgreSQL,
        MariaDB,
        MySQL,
        SQLite,
        YAML;

    }
}

