/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.WorldFlags;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class ConfigLoader {
    private final FileConfiguration config;

    public ConfigLoader(Homestead plugin) {
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            Logger.error("Unable to find the configuration file, closing plugin's instance...");
            plugin.endInstance();
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        Logger.info("The configuration file is ready.");
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        if (this.config == null) {
            return defaultValue;
        }
        return this.config.getBoolean(path, defaultValue);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public int getInt(String path, int defaultValue) {
        if (this.config == null) {
            return defaultValue;
        }
        return this.config.getInt(path, defaultValue);
    }

    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    public long getLong(String path, long defaultValue) {
        if (this.config == null) {
            return defaultValue;
        }
        return this.config.getLong(path, defaultValue);
    }

    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    public double getDouble(String path, double defaultValue) {
        if (this.config == null) {
            return defaultValue;
        }
        return this.config.getDouble(path, defaultValue);
    }

    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    public String getString(String path, String defaultValue) {
        if (this.config == null) {
            return defaultValue;
        }
        return this.config.getString(path, defaultValue);
    }

    public String getString(String path) {
        return this.getString(path, "");
    }

    public List<String> getStringList(String path) {
        if (this.config == null) {
            return Collections.emptyList();
        }
        if (!this.config.isList(path)) {
            Logger.warning("Config path '" + path + "' is not a list! Returning empty list.");
            return Collections.emptyList();
        }
        List rawList = this.config.getList(path);
        if (rawList == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object obj : rawList) {
            if (obj instanceof String) {
                result.add((String)obj);
                continue;
            }
            Logger.warning("Config path '" + path + "' contains non-string value: " + String.valueOf(obj));
        }
        return result;
    }

    public Object getRaw(String path) {
        if (this.config == null) {
            return null;
        }
        return this.config.get(path);
    }

    public List<String> getKeysUnderPath(String path) {
        if (this.config.isConfigurationSection(path)) {
            Set keys = Objects.requireNonNull(this.config.getConfigurationSection(path)).getKeys(false);
            return new ArrayList<String>(keys);
        }
        return new ArrayList<String>();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public long getDefaultPlayerFlags() {
        List<String> keys = this.getKeysUnderPath("default-players-flags");
        long flags = 0L;
        for (String key : keys) {
            boolean value = this.getBoolean("default-players-flags." + key);
            if (!value) continue;
            flags = FlagsCalculator.addFlag(flags, PlayerFlags.valueOf(key));
        }
        return flags;
    }

    public long getDefaultWorldFlags() {
        List<String> keys = this.getKeysUnderPath("default-world-flags");
        long flags = 0L;
        for (String key : keys) {
            boolean value = this.getBoolean("default-world-flags." + key);
            if (!value) continue;
            flags = FlagsCalculator.addFlag(flags, WorldFlags.valueOf(key));
        }
        return flags;
    }

    public boolean isFlagDisabled(String flag) {
        return this.getStringList("disabled-flags").contains(flag);
    }

    public boolean isWelcomeSignEnabled() {
        return this.getBoolean("welcome-signs.enabled");
    }

    public String getPrefix() {
        return (String)Homestead.language.get("prefix");
    }

    public boolean isAdjacentChunksRuleEnabled() {
        return this.getBoolean("adjacent-chunks");
    }

    public boolean regenerateChunksWithWorldEdit() {
        return this.getBoolean("worldedit.regenerate-chunks");
    }

    public boolean isRewardsEnabled() {
        return this.getBoolean("rewards.enabled");
    }

    public boolean isLevelsEnabled() {
        return this.getBoolean("levels.enabled");
    }

    public boolean isDebugEnabled() {
        return this.getBoolean("debug");
    }
}

