/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands.subcommands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.commands.SubCommandBuilder;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class MailSubCmd
extends SubCommandBuilder {
    public MailSubCmd() {
        super("mail");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You cannot use this command via the console.");
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homestead.region.mail")) {
            PlayerUtils.sendMessage(player, 8);
            return true;
        }
        if (args.length < 3) {
            PlayerUtils.sendMessage(player, 0);
            return true;
        }
        String regionName = args[1];
        Region region = RegionsManager.findRegion(regionName);
        if (region == null) {
            PlayerUtils.sendMessage(player, 9);
            return false;
        }
        int mailsCount = 0;
        for (SerializableLog log : region.getLogs()) {
            if (!log.getAuthor().equals(player.getName()) || log.isRead()) continue;
            ++mailsCount;
        }
        if (mailsCount >= 5) {
            PlayerUtils.sendMessage(player, 165);
            return false;
        }
        List<String> messageList = Arrays.asList(args).subList(2, args.length);
        String message = String.join((CharSequence)" ", messageList);
        RegionsManager.addNewLog(region.getUniqueId(), player.getName(), message);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region-owner}", region.getOwner().getName());
        PlayerUtils.sendMessage(player, 166, replacements);
        return true;
    }
}

