/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.CheckUpdatesSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.ClaimSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.ExportSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.FlagsOverrideSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.ImportSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.PluginSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.ReloadSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.TransferOwnershipSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.UnclaimSubCmd;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.WorldFlags;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.commands.AutoCompleteFilter;
import tfagaming.projects.minecraft.homestead.tools.java.StringSimilarity;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class HomesteadAdminCommand
extends CommandBuilder {
    public HomesteadAdminCommand() {
        super("homesteadadmin", "hsadmin");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (args.length < 1) {
            PlayerUtils.sendMessage(sender, 0);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (this.getSubcommands().contains(subCommand) && sender instanceof Player && !sender.hasPermission("homestead.commands.homesteadadmin." + subCommand)) {
            PlayerUtils.sendMessage(sender, 8);
            return true;
        }
        switch (subCommand) {
            case "export": {
                new ExportSubCmd().onExecution(sender, args);
                break;
            }
            case "plugin": {
                new PluginSubCmd().onExecution(sender, args);
                break;
            }
            case "reload": {
                new ReloadSubCmd().onExecution(sender, args);
                break;
            }
            case "updates": {
                new CheckUpdatesSubCmd().onExecution(sender, args);
                break;
            }
            case "import": {
                new ImportSubCmd().onExecution(sender, args);
                break;
            }
            case "flagsoverride": {
                new FlagsOverrideSubCmd().onExecution(sender, args);
                break;
            }
            case "claim": {
                new ClaimSubCmd().onExecution(sender, args);
                break;
            }
            case "unclaim": {
                new UnclaimSubCmd().onExecution(sender, args);
                break;
            }
            case "transfer": {
                new TransferOwnershipSubCmd().onExecution(sender, args);
                break;
            }
            default: {
                String similaritySubCmds = StringSimilarity.findTopSimilarStrings(this.getSubcommands(), subCommand).stream().collect(Collectors.joining(", "));
                if (sender instanceof Player) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{similarity-subcmds}", similaritySubCmds);
                    PlayerUtils.sendMessage(sender, 7, replacements);
                    break;
                }
                sender.sendMessage(new String[]{"Unknown sub-command, maybe you meant...", similaritySubCmds});
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String> onAutoComplete(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Lists.newArrayList();
        }
        player = (Player)sender;
        suggestions = new ArrayList<String>();
        if (args.length == 1) {
            subcommands = this.getSubcommands().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onAutoComplete$0(java.lang.String[] java.lang.String ), (Ljava/lang/String;)Z)((String[])args)).collect(Collectors.toList());
            for (String subcommand : subcommands) {
                if (!player.hasPermission("homestead.commands.homesteadadmin." + subcommand)) continue;
                suggestions.add(subcommand);
            }
            return suggestions;
        }
        if (this.getSubcommands().contains(args[0].toLowerCase()) && !player.hasPermission("homestead.commands.homesteadadmin." + args[0].toLowerCase())) {
            return new ArrayList<String>();
        }
        var5_6 = args[0].toLowerCase();
        var6_8 = -1;
        switch (var5_6.hashCode()) {
            case -1289153612: {
                if (!var5_6.equals("export")) break;
                var6_8 = 0;
                break;
            }
            case -1184795739: {
                if (!var5_6.equals("import")) break;
                var6_8 = 1;
                break;
            }
            case -1246784685: {
                if (!var5_6.equals("flagsoverride")) break;
                var6_8 = 2;
                break;
            }
            case -292302525: {
                if (!var5_6.equals("unclaim")) break;
                var6_8 = 3;
                break;
            }
            case 94742588: {
                if (!var5_6.equals("claim")) break;
                var6_8 = 4;
                break;
            }
            case 1280882667: {
                if (!var5_6.equals("transfer")) break;
                var6_8 = 5;
            }
        }
        switch (var6_8) {
            case 0: {
                if (args.length != 2) break;
                suggestions.addAll(List.of("SQLite", "MySQL", "YAML", "PostgreSQL", "MariaDB"));
                break;
            }
            case 1: {
                if (args.length != 2) break;
                suggestions.addAll(List.of("GriefPrevention", "LandLord", "ClaimChunk", "Lands", "HuskClaims"));
                break;
            }
            case 2: {
                if (args.length == 2) {
                    suggestions.addAll(List.of("member", "global", "world"));
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("member")) {
                    region = TargetRegionSession.getRegion((OfflinePlayer)player);
                    if (region == null) break;
                    for (SerializableMember member : region.getMembers()) {
                        bukkitMember = member.getBukkitOfflinePlayer();
                        if (bukkitMember == null) continue;
                        suggestions.add(bukkitMember.getName());
                    }
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("global")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("world")) {
                    suggestions.addAll(WorldFlags.getFlags());
                    break;
                }
                if (args.length == 4 && args[1].equalsIgnoreCase("member")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (!(args.length == 4 && args[1].equalsIgnoreCase("global") != false || args.length == 4 && args[1].equalsIgnoreCase("world") != false) && (args.length != 5 || !args[1].equalsIgnoreCase("member"))) break;
                suggestions.addAll(List.of("allow", "deny"));
                break;
            }
            case 3: 
            case 4: {
                if (args.length != 2) ** GOTO lbl88
                suggestions.addAll(RegionsManager.getAll().stream().map((Function<Region, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Ltfagaming/projects/minecraft/homestead/structure/Region;)Ljava/lang/String;)()).toList());
                ** GOTO lbl103
lbl88:
                // 1 sources

                if (args.length != 3) ** GOTO lbl95
                suggestions.add("here");
                loc = player.getLocation();
                suggestions.add(String.valueOf(loc.getChunk().getX()));
                ** GOTO lbl103
lbl95:
                // 1 sources

                if (args.length != 4 || args[2].equalsIgnoreCase("here")) ** GOTO lbl100
                loc = player.getLocation();
                suggestions.add(String.valueOf(loc.getChunk().getZ()));
                ** GOTO lbl103
lbl100:
                // 1 sources

                if (args.length == 4 && args[2].equalsIgnoreCase("here") || args.length == 5) {
                    suggestions.addAll(List.of("1", "2", "3", "4", "5"));
                }
            }
lbl103:
            // 7 sources

            case 5: {
                if (args.length == 2) {
                    suggestions.addAll(RegionsManager.getAll().stream().map((Function<Region, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Ltfagaming/projects/minecraft/homestead/structure/Region;)Ljava/lang/String;)()).toList());
                }
                if (args.length != 3) break;
                suggestions.addAll(Homestead.getInstance().getOfflinePlayersSync().stream().map((Function<OfflinePlayer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lorg/bukkit/OfflinePlayer;)Ljava/lang/String;)()).toList());
            }
        }
        return AutoCompleteFilter.filter(suggestions, args);
    }

    public List<String> getSubcommands() {
        return Lists.newArrayList((Object[])new String[]{"export", "plugin", "reload", "updates", "import", "flagsoverride", "claim", "unclaim", "transfer"});
    }

    private static /* synthetic */ boolean lambda$onAutoComplete$0(String[] args, String cmd) {
        return cmd.startsWith(args[0].toLowerCase());
    }
}

