/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import me.lucko.commodore.Commodore;
import me.lucko.commodore.CommodoreProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.commands.MojangBrigadier;
import tfagaming.projects.minecraft.homestead.commands.commands.ClaimCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.ForceUnclaimCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.HomesteadAdminCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.RegionCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.UnclaimCommand;
import tfagaming.projects.minecraft.homestead.config.ConfigLoader;
import tfagaming.projects.minecraft.homestead.config.LanguageLoader;
import tfagaming.projects.minecraft.homestead.config.MenusConfigLoader;
import tfagaming.projects.minecraft.homestead.database.Database;
import tfagaming.projects.minecraft.homestead.database.LevelsCache;
import tfagaming.projects.minecraft.homestead.database.RegionsCache;
import tfagaming.projects.minecraft.homestead.database.SubAreasCache;
import tfagaming.projects.minecraft.homestead.database.WarsCache;
import tfagaming.projects.minecraft.homestead.events.MemberTaxes;
import tfagaming.projects.minecraft.homestead.events.RegionRent;
import tfagaming.projects.minecraft.homestead.events.RegionUpkeep;
import tfagaming.projects.minecraft.homestead.integrations.DynamicMaps;
import tfagaming.projects.minecraft.homestead.integrations.PlaceholderAPI;
import tfagaming.projects.minecraft.homestead.integrations.Vault;
import tfagaming.projects.minecraft.homestead.integrations.bStats;
import tfagaming.projects.minecraft.homestead.integrations.maps.RegionIconTools;
import tfagaming.projects.minecraft.homestead.listeners.BorderBreakListener;
import tfagaming.projects.minecraft.homestead.listeners.CommandsCooldownListener;
import tfagaming.projects.minecraft.homestead.listeners.CustomSignsListener;
import tfagaming.projects.minecraft.homestead.listeners.DelayedTeleportListener;
import tfagaming.projects.minecraft.homestead.listeners.EntityDeathListener;
import tfagaming.projects.minecraft.homestead.listeners.PlayerAutoClaimListener;
import tfagaming.projects.minecraft.homestead.listeners.PlayerDeathListener;
import tfagaming.projects.minecraft.homestead.listeners.PlayerRegionEnterAndExitListener;
import tfagaming.projects.minecraft.homestead.listeners.RegionProtectionListener;
import tfagaming.projects.minecraft.homestead.listeners.SelectionToolListener;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.LevelsManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.managers.WarsManager;
import tfagaming.projects.minecraft.homestead.sessions.autoclaim.AutoClaimSession;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.tools.https.UpdateChecker;
import tfagaming.projects.minecraft.homestead.tools.minecraft.limits.Limits;
import tfagaming.projects.minecraft.homestead.tools.minecraft.plugins.IntegrationsUtils;
import tfagaming.projects.minecraft.homestead.tools.validator.YAMLValidator;

public class Homestead
extends JavaPlugin {
    private static final String VERSION = "5.0.0.2";
    private static final boolean SNAPSHOT = false;
    public static Database database;
    public static RegionsCache regionsCache;
    public static WarsCache warsCache;
    public static SubAreasCache subAreasCache;
    public static LevelsCache levelsCache;
    public static ConfigLoader config;
    public static LanguageLoader language;
    public static MenusConfigLoader menusConfig;
    public static Vault vault;
    private static Homestead INSTANCE;
    private static long startedAt;
    private static BukkitTask moveCheckTask;

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isSnapshot() {
        return false;
    }

    public static Homestead getInstance() {
        return INSTANCE;
    }

    public void onEnable() {
        INSTANCE = this;
        startedAt = System.currentTimeMillis();
        new Logger();
        try {
            if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
                throw new IOException("Unable to create Bukkit data directory");
            }
            File regionsFolder = new File(this.getDataFolder(), "regions");
            if (!regionsFolder.exists() && !regionsFolder.mkdir()) {
                throw new IOException("Unable to create regions directory");
            }
            File warsFolder = new File(this.getDataFolder(), "wars");
            if (!warsFolder.exists() && !warsFolder.mkdir()) {
                throw new IOException("Unable to create wars directory");
            }
            File subAreasFolder = new File(this.getDataFolder(), "subareas");
            if (!subAreasFolder.exists() && !subAreasFolder.mkdir()) {
                throw new IOException("Unable to create subareas directory");
            }
        }
        catch (IOException | SecurityException e) {
            this.endInstance(e);
            return;
        }
        this.saveDefaultConfig();
        config = new ConfigLoader(this);
        language = new LanguageLoader(this, config.getString("language", "en-US"));
        menusConfig = new MenusConfigLoader(this);
        HashSet<String> skipKeys = new HashSet<String>();
        YAMLValidator configValidator = new YAMLValidator("config.yml", new File(this.getDataFolder(), "config.yml"), skipKeys);
        try {
            if (!configValidator.validate()) {
                configValidator.fix();
                config = new ConfigLoader(this);
            }
        }
        catch (IOException e) {
            this.endInstance(e);
            return;
        }
        YAMLValidator languageValidator = new YAMLValidator("en-US.yml", language.getLanguageFile(config.getString("language", "en-US")));
        try {
            if (!languageValidator.validate()) {
                languageValidator.fix();
                language = new LanguageLoader(this, config.getString("language", "en-US"));
            }
        }
        catch (IOException e) {
            this.endInstance(e);
            return;
        }
        YAMLValidator menusConfigValidator = new YAMLValidator("menus.yml", new File(this.getDataFolder(), "menus.yml"), skipKeys);
        try {
            if (!menusConfigValidator.validate()) {
                menusConfigValidator.fix();
                menusConfig = new MenusConfigLoader(this);
            }
        }
        catch (IOException e) {
            this.endInstance(e);
            return;
        }
        regionsCache = new RegionsCache(config.getInt("cache-interval"));
        warsCache = new WarsCache(config.getInt("cache-interval"));
        subAreasCache = new SubAreasCache(config.getInt("cache-interval"));
        levelsCache = new LevelsCache(config.getInt("cache-interval"));
        try {
            Database.Provider provider = Database.parseProviderFromString(config.getString("database.provider"));
            if (provider == null) {
                throw new IllegalStateException("Database provider not found.");
            }
            database = new Database(provider);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            this.endInstance(e);
            return;
        }
        database.importRegions();
        database.importWars();
        database.importSubAreas();
        database.importLevels();
        if (!IntegrationsUtils.isVaultInstalled()) {
            Logger.error("Unable to start the plugin; \"Vault\" is required. Shutting down plugin instance...");
            this.endInstance();
            return;
        }
        Logger.warning("Loading service providers with Vault...");
        vault = new Vault(this);
        if (!vault.setupEconomy()) {
            Logger.warning("No Economy service provider found.");
            Logger.warning("Any feature requiring an Economy service will be skipped.");
        } else {
            Logger.info("Loaded service provider: Economy [" + vault.getEconomy().getName() + "]");
        }
        if (!vault.setupPermissions()) {
            if (Limits.getLimitsMethod() == Limits.LimitMethod.GROUPS) {
                Logger.error("No Permissions service provider found.");
                Logger.error("You are using groups as a limit method, and permission services are required for Homestead to run. Shutting down plugin instance...");
                this.endInstance();
                return;
            }
            Logger.warning("No Permission service provider found.");
            Logger.warning("The plugin is using static permissions; operator and non-operator.");
        } else {
            Logger.info("Loaded service provider: Permissions [" + vault.getPermissions().getName() + "]");
        }
        if (config.getBoolean("clean-startup")) {
            RegionsManager.cleanStartup();
            WarsManager.cleanStartup();
            SubAreasManager.cleanStartup();
            LevelsManager.cleanStartup();
        }
        this.registerCommands();
        this.registerEvents();
        this.registerBrigadier();
        if (config.getBoolean("metrics")) {
            new bStats(this);
            Logger.info("bStats metrics is enabled, anonymous data is being sent every 30 minutes.");
        }
        if (config.isDebugEnabled()) {
            Logger.warning("Debug mode is enabled in config.yml; logs.txt may be flooded with warnings.");
        }
        Logger.info("Ready, took " + (System.currentTimeMillis() - startedAt) + " ms to load.");
        if (config.getBoolean("dynamic-maps.icons.enabled")) {
            this.runAsyncTask(() -> {
                Logger.warning("Downloading required web map render icons... This may take a while!");
                RegionIconTools.downloadAllIcons();
                Logger.info("Successfully downloaded all icons!");
            });
        }
        this.runAsyncTimerTask(() -> this.runAsyncTask(() -> new DynamicMaps(this)), config.getInt("dynamic-maps.update-interval"));
        if (vault.isEconomyReady() && config.getBoolean("taxes.enabled")) {
            this.runAsyncTimerTask(() -> new MemberTaxes(this), 10);
        }
        if (vault.isEconomyReady() && config.getBoolean("upkeep.enabled")) {
            this.runAsyncTimerTask(() -> new RegionUpkeep(this), 10);
        }
        if (vault.isEconomyReady() && config.getBoolean("renting.enabled")) {
            this.runAsyncTimerTask(() -> new RegionRent(this), 10);
        }
        this.runAsyncTimerTask(() -> this.runAsyncTask(() -> UpdateChecker.check(this)), 86400);
        this.registerExternalPlugins();
        moveCheckTask = this.runSyncTimerTask(() -> {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    RegionProtectionListener.onEntityMove(entity);
                }
            }
        }, 5L);
    }

    private void registerCommands() {
        CommandBuilder.register(new RegionCommand());
        CommandBuilder.register(new ClaimCommand());
        CommandBuilder.register(new UnclaimCommand());
        CommandBuilder.register(new HomesteadAdminCommand());
        CommandBuilder.register(new ForceUnclaimCommand());
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerRegionEnterAndExitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RegionProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SelectionToolListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CommandsCooldownListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CustomSignsListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerAutoClaimListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BorderBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDeathListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DelayedTeleportListener(), (Plugin)this);
    }

    private void registerBrigadier() {
        try {
            if (CommodoreProvider.isSupported()) {
                Commodore commodore = CommodoreProvider.getCommodore((Plugin)this);
                new MojangBrigadier(this, commodore);
            } else {
                Logger.warning("Mojang Brigadier is not supported on this server software.");
            }
        }
        catch (NoClassDefFoundError e) {
            Logger.warning("Commodore/Brigadier classes not present. Skipping Brigadier command registration.");
        }
    }

    public BukkitTask runAsyncTimerTask(Runnable callable, int interval) {
        long intervalTicks = (long)interval * 20L;
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, callable, 0L, intervalTicks);
    }

    public BukkitTask runSyncTimerTask(Runnable callable, long ticks) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)this, callable, 0L, ticks);
    }

    public BukkitTask runSyncTaskLater(Runnable callable, int delay) {
        long delayTicks = (long)delay * 20L;
        return Bukkit.getScheduler().runTaskLater((Plugin)this, callable, delayTicks);
    }

    public void runAsyncTimerTask(Runnable callable, int delay, int interval) {
        long delayTicks = (long)delay * 20L;
        long intervalTicks = (long)interval * 20L;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, callable, delayTicks, intervalTicks);
    }

    public BukkitTask runAsyncTaskLater(Runnable callable, int delay) {
        long delayTicks = (long)delay * 20L;
        return Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, callable, delayTicks);
    }

    public void runAsyncTask(Runnable callable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, callable);
    }

    public void runSyncTask(Runnable callable) {
        Bukkit.getScheduler().runTask((Plugin)this, callable);
    }

    public List<OfflinePlayer> getOfflinePlayersSync() {
        OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
        return Arrays.asList(offlinePlayers);
    }

    public OfflinePlayer getOfflinePlayerSync(UUID playerId) {
        OfflinePlayer[] offlinePlayers;
        Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        for (OfflinePlayer player : offlinePlayers = Bukkit.getOfflinePlayers()) {
            if (player.getName() == null || !player.hasPlayedBefore() || !player.getUniqueId().equals(playerId)) continue;
            return player;
        }
        return null;
    }

    public OfflinePlayer getOfflinePlayerSync(String playerName) {
        OfflinePlayer[] offlinePlayers;
        Player onlinePlayer = Bukkit.getPlayer((String)playerName);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        for (OfflinePlayer player : offlinePlayers = Bukkit.getOfflinePlayers()) {
            if (player.getName() == null || !player.hasPlayedBefore() || !player.getName().equals(playerName)) continue;
            return player;
        }
        return null;
    }

    public void onDisable() {
        if (database != null) {
            Logger.info("Closing database connection...");
            database.closeConnection();
        }
        if (moveCheckTask != null) {
            moveCheckTask.cancel();
        }
        Logger.warning("Cleaning cache...");
        regionsCache.clear();
        warsCache.clear();
        TargetRegionSession.sessions.clear();
        AutoClaimSession.sessions.clear();
        Logger.info("Cache cleaned.");
        Logger.info("Homestead has been disabled. Goodbye!");
    }

    public void registerExternalPlugins() {
        boolean placeholderRegistered;
        if (this.isExternalPluginEnabled("PlaceholderAPI") && !(placeholderRegistered = new PlaceholderAPI(this).register())) {
            Logger.error("Failed to register hooks.");
        }
    }

    public boolean isExternalPluginEnabled(String pluginName) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        return plugin != null && plugin.isEnabled();
    }

    public void endInstance() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    public void endInstance(Throwable e) {
        Logger.error(e);
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }
}

