/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.players;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.RegionControlFlags;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.SubAreasManager;
import tfagaming.projects.minecraft.homestead.managers.WarsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.limits.Limits;

public class PlayerUtils {
    private static final int MESSAGE_COOLDOWN_SECONDS = 3;
    private static final HashSet<UUID> COOLDOWN = new HashSet();
    private static final Set<Long> RENT_BLACKLIST = Set.of(Long.valueOf(0x8000000L), Long.valueOf(0x4000000L));

    public static double getBalance(OfflinePlayer player) {
        if (!Homestead.vault.isEconomyReady()) {
            return 0.0;
        }
        return Homestead.vault.getEconomy().getBalance(player);
    }

    public static void addBalance(OfflinePlayer player, double amount) {
        if (!Homestead.vault.isEconomyReady()) {
            return;
        }
        Homestead.vault.getEconomy().depositPlayer(player, amount);
    }

    public static void removeBalance(OfflinePlayer player, double amount) {
        if (!Homestead.vault.isEconomyReady()) {
            return;
        }
        Homestead.vault.getEconomy().withdrawPlayer(player, amount);
    }

    public static void sendMessage(Player player, String ... messages) {
        player.sendMessage(ChatColorTranslator.translate(String.join((CharSequence)"", messages)));
    }

    public static void sendMessage(CommandSender sender, String path, Map<String, String> replacements) {
        if (sender == null) {
            return;
        }
        String message = (String)Homestead.language.get(path);
        if (message == null) {
            sender.sendMessage("STRING MISS AT " + path);
            return;
        }
        if (sender instanceof Player) {
            replacements.put("{__prefix__}", Homestead.config.getPrefix());
            message = Formatters.replace(message, replacements);
            sender.sendMessage(ChatColorTranslator.translate(message));
        } else {
            replacements.put("{__prefix__}", Homestead.config.getPrefix());
            message = Formatters.replace(message, replacements);
            sender.sendMessage(ChatColorTranslator.removeColor(message, true));
        }
    }

    public static void sendMessage(CommandSender sender, String path) {
        PlayerUtils.sendMessage(sender, path, new HashMap<String, String>());
    }

    public static void sendMessage(Player player, int path, Map<String, String> replacements) {
        PlayerUtils.sendMessage((CommandSender)player, String.valueOf(path), replacements);
    }

    public static void sendMessage(CommandSender sender, int path, Map<String, String> replacements) {
        PlayerUtils.sendMessage(sender, String.valueOf(path), replacements);
    }

    public static void sendMessage(CommandSender sender, int path) {
        PlayerUtils.sendMessage(sender, String.valueOf(path));
    }

    public static void sendMessage(Player player, int path) {
        PlayerUtils.sendMessage((CommandSender)player, String.valueOf(path));
    }

    public static void sendMessageRegionEnter(Player player, Map<String, String> replacements) {
        switch (((String)Homestead.config.get("enter-exit-region-message.type")).toLowerCase()) {
            case "title": {
                List titleData = (List)Homestead.config.get("enter-exit-region-message.messages.enter.title");
                player.sendTitle(ChatColorTranslator.translate(Formatters.replace((String)titleData.get(0), replacements)), ChatColorTranslator.translate(Formatters.replace((String)titleData.get(1), replacements)), 10, 70, 20);
                break;
            }
            case "actionbar": {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.enter.actionbar"), replacements))));
                break;
            }
            default: {
                player.sendMessage(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.enter.chat"), replacements)));
            }
        }
    }

    public static void sendMessageRegionExit(Player player, Map<String, String> replacements) {
        switch (((String)Homestead.config.get("enter-exit-region-message.type")).toLowerCase()) {
            case "title": {
                List titleData = (List)Homestead.config.get("enter-exit-region-message.messages.exit.title");
                player.sendTitle(ChatColorTranslator.translate(Formatters.replace((String)titleData.get(0), replacements)), ChatColorTranslator.translate(Formatters.replace((String)titleData.get(1), replacements)), 10, 70, 20);
                break;
            }
            case "actionbar": {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.exit.actionbar"), replacements))));
                break;
            }
            default: {
                player.sendMessage(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.exit.chat"), replacements)));
            }
        }
    }

    public static void teleportPlayerToChunk(Player player, Chunk chunk) {
        Location location = ChunksManager.getLocation(player, chunk);
        player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static boolean isOperator(Player player) {
        if (player.isOp()) {
            return true;
        }
        return player.hasPermission("homestead.operator");
    }

    public static boolean isOperator(OfflinePlayer player) {
        return player.isOp();
    }

    public static boolean hasPermissionFlag(UUID regionId, Player player, long flag, boolean notify) {
        boolean response;
        Region region = RegionsManager.findRegion(regionId);
        if (region == null) {
            return true;
        }
        SerializableRent rent = region.getRent();
        War war = WarsManager.findWarByRegionId(regionId);
        if (rent != null && rent.getPlayerId() != null && rent.getPlayerId().equals(player.getUniqueId()) && !List.of(Long.valueOf(0x8000000L), Long.valueOf(0x4000000L)).contains(flag)) {
            response = true;
        } else if (war != null && WarsManager.getMembersOfWar(war.getUniqueId()).stream().map(OfflinePlayer::getUniqueId).toList().contains(player.getUniqueId()) && List.of(Long.valueOf(0x8000000L), Long.valueOf(8L), Long.valueOf(16L), Long.valueOf(0x4000000L), Long.valueOf(32L), Long.valueOf(0x400000000L)).contains(flag)) {
            response = true;
        } else if (region.isPlayerMember((OfflinePlayer)player)) {
            SerializableMember member = region.getMember((OfflinePlayer)player);
            response = FlagsCalculator.isFlagSet(member.getFlags(), flag);
        } else {
            response = FlagsCalculator.isFlagSet(region.getPlayerFlags(), flag);
        }
        if (!response && flag != 0x10000000L && !COOLDOWN.contains(player.getUniqueId()) && notify) {
            PlayerUtils.sendDenialMessage(player, region, flag);
        }
        return response;
    }

    public static boolean hasPermissionFlag(UUID regionId, UUID subAreaId, Player player, long flag, boolean notify) {
        Region region = RegionsManager.findRegion(regionId);
        if (region == null) {
            return true;
        }
        boolean allowed = PlayerUtils.calculatePermission(region, subAreaId, player, flag);
        if (!allowed && notify && !COOLDOWN.contains(player.getUniqueId())) {
            PlayerUtils.sendDenialMessage(player, region, flag);
        }
        return allowed;
    }

    private static boolean calculatePermission(Region region, UUID subAreaId, Player player, long flag) {
        Set<Long> warFlags;
        List<UUID> warMembers;
        SubArea subArea;
        SubArea subArea2 = subArea = subAreaId != null ? SubAreasManager.findSubArea(subAreaId) : null;
        if (subArea != null) {
            SerializableRent subRent = subArea.getRent();
            if (subRent != null && subRent.getPlayerId() != null && subRent.getPlayerId().equals(player.getUniqueId()) && !RENT_BLACKLIST.contains(flag)) {
                return true;
            }
            if (subArea.isPlayerMember((OfflinePlayer)player)) {
                SerializableMember member = subArea.getMember((OfflinePlayer)player);
                return FlagsCalculator.isFlagSet(member.getFlags(), flag);
            }
            return FlagsCalculator.isFlagSet(subArea.getFlags(), flag);
        }
        War war = WarsManager.findWarByRegionId(region.getUniqueId());
        if (war != null && (warMembers = WarsManager.getMembersOfWar(war.getUniqueId()).stream().map(OfflinePlayer::getUniqueId).toList()).contains(player.getUniqueId()) && (warFlags = Set.of(Long.valueOf(0x8000000L), Long.valueOf(8L), Long.valueOf(16L), Long.valueOf(0x4000000L), Long.valueOf(32L), Long.valueOf(0x400000000L))).contains(flag)) {
            return true;
        }
        SerializableRent regionRent = region.getRent();
        if (regionRent != null && regionRent.getPlayerId() != null && regionRent.getPlayerId().equals(player.getUniqueId()) && !RENT_BLACKLIST.contains(flag)) {
            return true;
        }
        if (region.isPlayerMember((OfflinePlayer)player)) {
            SerializableMember member = region.getMember((OfflinePlayer)player);
            return FlagsCalculator.isFlagSet(member.getFlags(), flag);
        }
        return FlagsCalculator.isFlagSet(region.getPlayerFlags(), flag);
    }

    private static void sendDenialMessage(Player player, Region region, long flag) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{flag}", PlayerFlags.from(flag));
        placeholders.put("{region}", region.getName());
        PlayerUtils.sendMessage(player, 50, placeholders);
        COOLDOWN.add(player.getUniqueId());
        Homestead.getInstance().runAsyncTaskLater(() -> COOLDOWN.remove(player.getUniqueId()), 3);
    }

    public static boolean hasControlRegionPermissionFlag(UUID regionId, Player player, long flag) {
        Region region = RegionsManager.findRegion(regionId);
        if (region != null) {
            if (PlayerUtils.isOperator(player) || region.isOwner((OfflinePlayer)player)) {
                return true;
            }
            boolean response = true;
            if (region.isPlayerMember((OfflinePlayer)player)) {
                SerializableMember member = region.getMember((OfflinePlayer)player);
                response = FlagsCalculator.isFlagSet(member.getRegionControlFlags(), flag);
            }
            if (!response && !COOLDOWN.contains(player.getUniqueId())) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", RegionControlFlags.from(flag));
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 70, replacements);
                COOLDOWN.add(player.getUniqueId());
                Homestead.getInstance().runAsyncTaskLater(() -> COOLDOWN.remove(player.getUniqueId()), 3);
            }
            return response;
        }
        return true;
    }

    public static String getPlayerGroup(OfflinePlayer player) {
        if (Limits.getLimitsMethod() != Limits.LimitMethod.GROUPS) {
            return null;
        }
        try {
            if (player.isOnline()) {
                return Homestead.vault.getPermissions().getPrimaryGroup((Player)player);
            }
            Location location = player.getLocation();
            if (location == null) {
                return null;
            }
            World world = location.getWorld();
            if (world == null) {
                return null;
            }
            return Homestead.vault.getPermissions().getPrimaryGroup(world.getName(), player);
        }
        catch (UnsupportedOperationException e) {
            Logger.error("Unable to find a service provider for permissions and groups, using the default group \"default\".");
            Logger.error("Please install a plugin that supports permissions and groups. We recommend installing the LuckPerms plugin.");
            Logger.error("To ignore this warning, change the limits method to \"static\" in this setting: limits.method");
            return null;
        }
    }
}

