/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure.serializable;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;

public class SerializableMember {
    private final long joinedAt;
    private UUID playerId;
    private long flags;
    private long regionControlFlags;
    private long taxesAt;

    public SerializableMember(OfflinePlayer player) {
        this.playerId = player.getUniqueId();
        this.flags = 0L;
        this.regionControlFlags = 0L;
        this.joinedAt = System.currentTimeMillis();
        this.taxesAt = 0L;
    }

    public SerializableMember(OfflinePlayer player, long flags, long regionControlFlags) {
        this.playerId = player.getUniqueId();
        this.flags = flags;
        this.regionControlFlags = regionControlFlags;
        this.joinedAt = System.currentTimeMillis();
        this.taxesAt = 0L;
    }

    public SerializableMember(OfflinePlayer player, long flags, long regionControlFlags, long joinedAt, long taxesAt) {
        this.playerId = player.getUniqueId();
        this.flags = flags;
        this.regionControlFlags = regionControlFlags;
        this.joinedAt = joinedAt;
        this.taxesAt = taxesAt;
    }

    public SerializableMember(UUID playerId, long flags, long regionControlFlags, long joinedAt, long taxesAt) {
        this.playerId = playerId;
        this.flags = flags;
        this.regionControlFlags = regionControlFlags;
        this.joinedAt = joinedAt;
        this.taxesAt = taxesAt;
    }

    public static SerializableMember fromString(String string) {
        String[] splitted = string.split(",");
        return new SerializableMember(UUID.fromString(splitted[0]), Long.parseLong(splitted[1]), Long.parseLong(splitted[2]), Long.parseLong(splitted[3]), Long.parseLong(splitted[4]));
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public long getJoinedAt() {
        return this.joinedAt;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public long getTaxesAt() {
        return this.taxesAt;
    }

    public void setTaxesAt(long taxesAt) {
        this.taxesAt = taxesAt;
    }

    public long getRegionControlFlags() {
        return this.regionControlFlags;
    }

    public void setRegionControlFlags(long flags) {
        this.regionControlFlags = flags;
    }

    public String toString() {
        return String.valueOf(this.playerId) + "," + this.flags + "," + this.regionControlFlags + "," + this.joinedAt + "," + this.taxesAt;
    }

    public OfflinePlayer getBukkitOfflinePlayer() {
        return Homestead.getInstance().getOfflinePlayerSync(this.playerId);
    }
}

