/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure;

import java.util.UUID;
import tfagaming.projects.minecraft.homestead.Homestead;

public class Level {
    public static double BASE = 5.0;
    public static double COEFFICIENT = 50.0;
    public static double CONSTANT = 100.0;
    public UUID id;
    public UUID regionId;
    public int level;
    public long experience;
    public long totalExperience;
    public long createdAt;

    public Level(UUID regionId) {
        this.id = UUID.randomUUID();
        this.regionId = regionId;
        this.level = 0;
        this.experience = 0L;
        this.totalExperience = 0L;
        this.createdAt = System.currentTimeMillis();
    }

    public Level(UUID id, UUID regionId, int level, long experience, long totalExperience, long createdAt) {
        this.id = id;
        this.regionId = regionId;
        this.level = level;
        this.experience = experience;
        this.totalExperience = totalExperience;
        this.createdAt = createdAt;
    }

    public static long getXpForLevel(int level) {
        if (level < 0) {
            return 0L;
        }
        double xp = BASE * Math.pow(level, 2.0) + COEFFICIENT * (double)level + CONSTANT;
        return (long)Math.floor(xp);
    }

    public UUID getUniqueId() {
        return this.id;
    }

    public UUID getRegionId() {
        return this.regionId;
    }

    public void setRegionId(UUID regionId) {
        this.regionId = regionId;
        this.updateCache();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = Math.max(0, level);
        this.experience = 0L;
        this.updateCache();
    }

    public long getExperience() {
        return this.experience;
    }

    public long getTotalExperience() {
        return this.totalExperience;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getTotalXpForCurrentLevel() {
        long total = 0L;
        for (int i = 0; i < this.level; ++i) {
            total += Level.getXpForLevel(i);
        }
        return total;
    }

    public long getXpForNextLevel() {
        return Level.getXpForLevel(this.level);
    }

    public long getXpProgress() {
        return this.experience;
    }

    public long getXpRemaining() {
        long needed = this.getXpForNextLevel();
        return Math.max(0L, needed - this.experience);
    }

    public double getProgressPercentage() {
        long needed = this.getXpForNextLevel();
        if (needed == 0L) {
            return 100.0;
        }
        return (double)this.experience / (double)needed * 100.0;
    }

    public void addXp(long amount) {
        if (amount <= 0L) {
            return;
        }
        this.experience += amount;
        this.totalExperience += amount;
        this.checkLevelUp();
        this.updateCache();
    }

    private void checkLevelUp() {
        long needed = this.getXpForNextLevel();
        while (this.experience >= needed && needed > 0L) {
            this.experience -= needed;
            ++this.level;
            this.onLevelUp();
            needed = this.getXpForNextLevel();
        }
    }

    public void onLevelUp() {
    }

    public void setXp(long experience) {
        this.experience = Math.max(0L, experience);
        this.checkLevelUp();
        this.updateCache();
    }

    public void removeXp(long amount) {
        if (amount <= 0L) {
            return;
        }
        this.experience = Math.max(0L, this.experience - amount);
        this.updateCache();
    }

    public void reset() {
        this.level = 0;
        this.experience = 0L;
        this.totalExperience = 0L;
        this.updateCache();
    }

    private void updateCache() {
        Homestead.levelsCache.putOrUpdate(this);
    }
}

