/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Level;

public final class LevelsManager {
    private static final Random random = new Random();

    private LevelsManager() {
    }

    public static Level createLevel(UUID regionId) {
        if (LevelsManager.getLevelByRegion(regionId) != null) {
            return null;
        }
        Level level = new Level(regionId);
        Homestead.levelsCache.putOrUpdate(level);
        return level;
    }

    public static List<Level> getAll() {
        return Homestead.levelsCache.getAll();
    }

    public static Level getLevelByRegion(UUID regionId) {
        for (Level level : LevelsManager.getAll()) {
            if (!level.getRegionId().equals(regionId)) continue;
            return level;
        }
        return null;
    }

    public static Level findLevel(UUID id) {
        for (Level level : LevelsManager.getAll()) {
            if (!level.getUniqueId().equals(id)) continue;
            return level;
        }
        return null;
    }

    public static Level getOrCreateLevel(UUID regionId) {
        Level level = LevelsManager.getLevelByRegion(regionId);
        if (level == null) {
            level = LevelsManager.createLevel(regionId);
        }
        return level;
    }

    public static void deleteLevel(UUID id) {
        Level level = LevelsManager.findLevel(id);
        if (level == null) {
            return;
        }
        Homestead.levelsCache.remove(id);
    }

    public static void deleteLevelByRegion(UUID regionId) {
        Level level = LevelsManager.getLevelByRegion(regionId);
        if (level != null) {
            LevelsManager.deleteLevel(level.getUniqueId());
        }
    }

    public static void addXp(UUID regionId, long amount) {
        Level level = LevelsManager.getOrCreateLevel(regionId);
        level.addXp(amount);
    }

    public static long addRandomXp(UUID regionId, double min2, double max) {
        long maxLong;
        long minLong = (long)Math.floor(min2);
        if (minLong > (maxLong = (long)Math.floor(max))) {
            long temp = minLong;
            minLong = maxLong;
            maxLong = temp;
        }
        long range = maxLong - minLong + 1L;
        long amount = minLong + (long)(random.nextDouble() * (double)range);
        LevelsManager.addXp(regionId, amount);
        return amount;
    }

    public static long addRandomXp(UUID regionId, long min2, long max) {
        return LevelsManager.addRandomXp(regionId, (double)min2, (double)max);
    }

    public static void removeXp(UUID regionId, long amount) {
        Level level = LevelsManager.getLevelByRegion(regionId);
        if (level != null) {
            level.removeXp(amount);
        }
    }

    public static void setXp(UUID regionId, long experience) {
        Level level = LevelsManager.getOrCreateLevel(regionId);
        level.setXp(experience);
    }

    public static void setLevel(UUID regionId, int level) {
        Level lvl = LevelsManager.getOrCreateLevel(regionId);
        lvl.setLevel(level);
    }

    public static void resetLevel(UUID regionId) {
        Level level = LevelsManager.getLevelByRegion(regionId);
        if (level != null) {
            level.reset();
        }
    }

    public static List<Level> getTopLevels(int limit) {
        ArrayList<Level> sorted = new ArrayList<Level>(LevelsManager.getAll());
        sorted.sort((a, b) -> {
            if (a.getLevel() != b.getLevel()) {
                return Integer.compare(b.getLevel(), a.getLevel());
            }
            return Long.compare(b.getExperience(), a.getExperience());
        });
        return sorted.size() > limit ? sorted.subList(0, limit) : sorted;
    }

    public static int getRank(UUID regionId) {
        Level target = LevelsManager.getLevelByRegion(regionId);
        if (target == null) {
            return -1;
        }
        int rank = 1;
        for (Level level : LevelsManager.getAll()) {
            if (level.getUniqueId().equals(target.getUniqueId())) continue;
            if (level.getLevel() > target.getLevel()) {
                ++rank;
                continue;
            }
            if (level.getLevel() != target.getLevel() || level.getExperience() <= target.getExperience()) continue;
            ++rank;
        }
        return rank;
    }

    public static void cleanStartup() {
        Logger.warning("Cleaning up levels data...");
        int updated = 0;
        for (Level level : Homestead.levelsCache.getAll()) {
            if (RegionsManager.findRegion(level.getRegionId()) != null) continue;
            LevelsManager.deleteLevel(level.getUniqueId());
            ++updated;
        }
        if (updated == 0) {
            Logger.info("No data corruption was found!");
        } else {
            Logger.info(updated + " updates have been applied to levels data.");
        }
    }
}

