/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations.maps;

import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class RegionIconTools {
    private static final Map<String, BufferedImage> icons = new HashMap<String, BufferedImage>();
    private static BufferedImage defaultIcon;

    public static List<String> getAllIcons() {
        return Homestead.config.getKeysUnderPath("dynamic-maps.icons.list");
    }

    public static boolean isValidIcon(String icon) {
        return RegionIconTools.getAllIcons().contains(icon);
    }

    public static BufferedImage getIconBufferedImage(String icon) {
        if (icon == null) {
            return defaultIcon;
        }
        return icons.getOrDefault(icon, defaultIcon);
    }

    public static void downloadAllIcons() {
        List<String> allIcons = RegionIconTools.getAllIcons();
        int totalIcons = allIcons.size();
        int downloadedCount = 0;
        Logger.warning("Downloaded icons status: 0% (0 / " + totalIcons + ")");
        defaultIcon = RegionIconTools.downloadIcon((String)Homestead.config.get("dynamic-maps.icons.default"));
        for (String icon : RegionIconTools.getAllIcons()) {
            String url;
            if (icons.containsKey(icon) || (url = (String)Homestead.config.get("dynamic-maps.icons.list." + icon)) == null) continue;
            BufferedImage downloaded = RegionIconTools.downloadIcon(url);
            icons.putIfAbsent(icon, downloaded);
            Logger.warning("Downloaded icons status: " + (int)((float)(++downloadedCount) / (float)totalIcons * 100.0f) + "% (" + downloadedCount + " / " + totalIcons + ")");
        }
    }

    public static BufferedImage downloadIcon(String imageUrl) {
        try {
            URL url = new URI(imageUrl).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            BufferedImage bufferedImage = ImageIO.read(connection.getInputStream());
            return bufferedImage;
        }
        catch (Exception e) {
            Logger.warning("Failed to download the icon! URL: " + imageUrl);
            return null;
        }
    }
}

