/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class GlobalPlayerFlagsMenu {
    private final HashSet<UUID> cooldowns = new HashSet();

    public GlobalPlayerFlagsMenu(Player player, Region region) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String flagString : PlayerFlags.getFlags()) {
            boolean value = FlagsCalculator.isFlagSet(region.getPlayerFlags(), PlayerFlags.valueOf(flagString));
            items.add(MenuUtils.getFlagButton(flagString, value));
        }
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(2), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), items, (_player, event) -> new RegionMenu(player, region), (_player, context) -> {
            if (this.cooldowns.contains(player.getUniqueId())) {
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 256L)) {
                return;
            }
            String flagString = PlayerFlags.getFlags().get(context.getIndex());
            List disabledFlags = (List)Homestead.config.get("disabled-flags");
            if (Homestead.config.isFlagDisabled(flagString)) {
                PlayerUtils.sendMessage(player, 42);
                return;
            }
            long flag = PlayerFlags.valueOf(flagString);
            if (context.getEvent().isLeftClick()) {
                PaginationMenu instance = context.getInstance();
                long flags = region.getPlayerFlags();
                boolean isSet = FlagsCalculator.isFlagSet(flags, flag);
                long newFlags = isSet ? FlagsCalculator.removeFlag(flags, flag) : FlagsCalculator.addFlag(flags, flag);
                region.setPlayerFlags(newFlags);
                this.cooldowns.add(player.getUniqueId());
                player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", flagString);
                replacements.put("{state}", Formatters.getFlag(!isSet));
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 44, replacements);
                instance.replaceSlot(context.getIndex(), MenuUtils.getFlagButton(flagString, !isSet));
                Homestead.getInstance().runAsyncTaskLater(() -> this.cooldowns.remove(player.getUniqueId()), 1);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

