/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.InventoryManager;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;

public class PaginationMenu
implements Listener {
    private final Homestead plugin;
    private final String title;
    private final int size;
    private final int contentSize;
    private final ItemStack nextPageItem;
    private final ItemStack prevPageItem;
    private final List<ItemStack> items;
    private final Map<Integer, BiConsumer<Player, InventoryClickEvent>> bottomRowActions = new HashMap<Integer, BiConsumer<Player, InventoryClickEvent>>();
    private final Map<Integer, ItemStack> bottomRowActionItems = new HashMap<Integer, ItemStack>();
    private final BiConsumer<Player, InventoryClickEvent> goBackCallback;
    private final BiConsumer<Player, ClickContext> clickCallback;
    private boolean pageChanged = false;
    private Player player;
    private ItemStack fillerItemstack = null;
    private Consumer<Inventory> openHandler;
    private int itemsPerPage = -1;
    private int currentPage;

    public PaginationMenu(String title, int size, ItemStack nextPageItem, ItemStack prevPageItem, List<ItemStack> items, BiConsumer<Player, InventoryClickEvent> goBackCallback, BiConsumer<Player, ClickContext> clickCallback) {
        if (size % 9 != 0 || size < 36) {
            throw new IllegalArgumentException("Inventory size must be a multiple of 9 and at least 36.");
        }
        this.plugin = Homestead.getInstance();
        this.title = title;
        this.size = size;
        this.contentSize = size - 18;
        this.nextPageItem = nextPageItem;
        this.prevPageItem = prevPageItem;
        this.items = items;
        this.goBackCallback = goBackCallback;
        this.clickCallback = clickCallback;
        this.currentPage = 0;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void addActionButton(int index, ItemStack item, BiConsumer<Player, InventoryClickEvent> callback) {
        int[] validSlots = new int[]{this.size - 6, this.size - 5, this.size - 4};
        if (index < 0 || index >= validSlots.length) {
            throw new IllegalArgumentException("Invalid index. Only 0, 1, or 2 are allowed.");
        }
        int slot = validSlots[index];
        this.bottomRowActions.put(slot, callback);
        this.bottomRowActionItems.put(slot, item);
    }

    public void addOpenHandler(Consumer<Inventory> handler) {
        this.openHandler = handler;
    }

    public void setItemsPerPage(int n) {
        this.itemsPerPage = n;
    }

    public void open(Player player) {
        this.player = player;
        player.openInventory(this.createPage(this.currentPage));
        InventoryManager.register(player, this);
    }

    public void open(Player player, ItemStack filler) {
        int i;
        this.player = player;
        Inventory inventory = this.createPage(this.currentPage);
        for (i = 0; i < 9; ++i) {
            inventory.setItem(i, filler);
        }
        for (i = this.size - 9; i < this.size; ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, filler);
        }
        this.fillerItemstack = filler;
        player.openInventory(inventory);
        InventoryManager.register(player, this);
    }

    public void replaceSlot(int index, ItemStack newItem) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.items.set(index, newItem);
        int start = this.currentPage * this.contentSize;
        int end = Math.min(start + this.contentSize, this.items.size());
        if (index >= start && index < end) {
            int slot = index - start + 9;
            if (this.player != null) {
                Inventory inventory = this.player.getOpenInventory().getTopInventory();
                inventory.setItem(slot, newItem);
            }
        }
    }

    public void setItems(List<ItemStack> newItems) {
        boolean wasOpen = this.player != null && this.player.getOpenInventory() != null;
        this.items.clear();
        this.items.addAll(newItems);
        int totalPages = this.getTotalPages();
        if (this.currentPage >= totalPages && totalPages > 0) {
            this.currentPage = totalPages - 1;
        } else if (totalPages == 0) {
            this.currentPage = 0;
        }
        if (wasOpen) {
            InventoryManager.unregister(this.player);
            Inventory newInventory = this.createPage(this.currentPage);
            this.pageChanged = true;
            this.player.openInventory(newInventory);
            InventoryManager.register(this.player, this);
            this.plugin.runAsyncTaskLater(() -> {
                this.pageChanged = false;
            }, 1);
        }
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
    }

    public int getTotalPages() {
        int buttonsPerPage = this.itemsPerPage > 0 ? this.itemsPerPage : this.contentSize;
        return (int)Math.ceil((double)this.items.size() / (double)buttonsPerPage);
    }

    private Inventory createPage(int page) {
        int i;
        boolean hasNext;
        Inventory inventory = Bukkit.createInventory(null, (int)this.size, (String)Formatters.formatPaginationMenuTitle(this.title, page + 1, this.getTotalPages()));
        int buttonsPerPage = this.itemsPerPage > 0 ? this.itemsPerPage : this.contentSize;
        boolean bl = hasNext = (page + 1) * buttonsPerPage < this.items.size();
        if (hasNext) {
            inventory.setItem(this.size - 1, this.nextPageItem);
        }
        int start = page * buttonsPerPage;
        int end = Math.min(start + buttonsPerPage, this.items.size());
        int i2 = start;
        int slot = 9;
        while (i2 < end) {
            inventory.setItem(slot, this.items.get(i2));
            ++i2;
            ++slot;
        }
        if (page > 0) {
            inventory.setItem(this.size - 9, this.prevPageItem);
        } else {
            inventory.setItem(this.size - 9, MenuUtils.getBackButton());
        }
        if (end < this.items.size()) {
            inventory.setItem(this.size - 1, this.nextPageItem);
        }
        int[] validSlots = new int[]{this.size - 6, this.size - 5, this.size - 4};
        for (i = 0; i < validSlots.length; ++i) {
            if (!this.bottomRowActionItems.containsKey(validSlots[i])) continue;
            inventory.setItem(validSlots[i], this.bottomRowActionItems.get(validSlots[i]));
        }
        if (this.fillerItemstack != null) {
            for (i = 0; i < 9; ++i) {
                inventory.setItem(i, this.fillerItemstack);
            }
            for (i = this.size - 9; i < this.size; ++i) {
                if (inventory.getItem(i) != null) continue;
                inventory.setItem(i, this.fillerItemstack);
            }
        }
        if (this.openHandler != null) {
            this.openHandler.accept(inventory);
        }
        return inventory;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int itemIndex;
        int buttonsPerPage;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (InventoryManager.getMenu(player) != this) {
            return;
        }
        if (!event.getView().getTitle().startsWith(Formatters.formatPaginationMenuTitle(this.title, this.currentPage + 1, this.getTotalPages()))) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (this.bottomRowActions.containsKey(slot)) {
            this.bottomRowActions.get(slot).accept(player, event);
            return;
        }
        if (slot < 9) {
            return;
        }
        if (slot == this.size - 9 && this.currentPage > 0) {
            --this.currentPage;
            this.pageChanged = true;
            player.openInventory(this.createPage(this.currentPage));
            return;
        }
        int n = buttonsPerPage = this.itemsPerPage > 0 ? this.itemsPerPage : this.contentSize;
        if (slot == this.size - 1 && (this.currentPage + 1) * buttonsPerPage < this.items.size()) {
            ++this.currentPage;
            this.pageChanged = true;
            player.openInventory(this.createPage(this.currentPage));
            return;
        }
        if (slot == this.size - 9) {
            this.plugin.runSyncTask(() -> {
                this.goBackCallback.accept(player, event);
                this.destroy();
            });
        }
        if (slot >= 9 && slot < this.size - 9 && (itemIndex = this.currentPage * buttonsPerPage + (slot - 9)) < this.items.size()) {
            this.clickCallback.accept(player, new ClickContext(event, itemIndex, this.items, this));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.pageChanged) {
            this.pageChanged = false;
            return;
        }
        Player player = (Player)event.getPlayer();
        if (InventoryManager.getMenu(player) == this) {
            InventoryManager.unregister(player);
            this.destroy();
        }
    }

    public static class ClickContext {
        private final InventoryClickEvent event;
        private final int index;
        private final List<ItemStack> items;
        private final PaginationMenu instance;

        public ClickContext(InventoryClickEvent event, int index, List<ItemStack> items, PaginationMenu instance) {
            this.event = event;
            this.index = index;
            this.items = items;
            this.instance = instance;
        }

        public InventoryClickEvent getEvent() {
            return this.event;
        }

        public int getIndex() {
            return this.index;
        }

        public List<ItemStack> getItems() {
            return this.items;
        }

        public PaginationMenu getInstance() {
            return this.instance;
        }
    }
}

