/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chunks.ChunkBorder;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class ForceUnclaimCommand
extends CommandBuilder {
    public ForceUnclaimCommand() {
        super("forceunclaim");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            PlayerUtils.sendMessage(sender, 8);
            return false;
        }
        Player player = (Player)sender;
        if (!PlayerUtils.isOperator(player)) {
            PlayerUtils.sendMessage(sender, 8);
            return true;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (ChunksManager.isChunkInDisabledWorld(chunk)) {
            PlayerUtils.sendMessage(player, 20);
            return true;
        }
        Region owningRegion = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (owningRegion == null) {
            PlayerUtils.sendMessage(player, 25);
            return true;
        }
        ChunksManager.Error error = ChunksManager.forceUnclaimChunk(owningRegion.getUniqueId(), chunk);
        if (error == null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", owningRegion.getName());
            PlayerUtils.sendMessage(player, 24, replacements);
            ChunkBorder.show(player);
        } else {
            switch (error) {
                case REGION_NOT_FOUND: {
                    PlayerUtils.sendMessage(player, 9);
                    break;
                }
                case CHUNK_WOULD_SPLIT_REGION: {
                    PlayerUtils.sendMessage(player, 141);
                }
            }
        }
        return true;
    }

    @Override
    public List<String> onAutoComplete(CommandSender sender, String[] args) {
        return new ArrayList<String>();
    }
}

