/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;

public class War {
    public UUID id;
    public String name;
    public String description;
    public String displayName;
    public ArrayList<UUID> regions = new ArrayList();
    public double prize;
    public long startedAt;

    public War(String name) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.displayName = name;
        this.description = "";
        this.prize = 0.0;
        this.startedAt = System.currentTimeMillis();
    }

    public War(String name, List<UUID> regions) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.displayName = name;
        this.description = "";
        this.prize = 0.0;
        this.startedAt = System.currentTimeMillis();
        this.regions.addAll(regions);
    }

    public UUID getUniqueId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updateCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateCache();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateCache();
    }

    public double getPrize() {
        return this.prize;
    }

    public void setPrize(double prize) {
        this.prize = prize;
        this.updateCache();
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public ArrayList<UUID> getRegionUniqueIds() {
        return this.regions;
    }

    public ArrayList<Region> getRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (UUID uuid : this.regions) {
            Region region = RegionsManager.findRegion(uuid);
            if (region == null) continue;
            regions.add(region);
        }
        return regions;
    }

    public void addRegion(Region region) {
        if (this.regions.contains(region.id)) {
            return;
        }
        this.regions.add(region.id);
        this.updateCache();
    }

    public void removeRegion(Region region) {
        if (!this.regions.contains(region.id)) {
            return;
        }
        this.regions.remove(region.id);
        this.updateCache();
    }

    public void updateCache() {
        Homestead.warsCache.putOrUpdate(this);
    }
}

