/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;

public final class WarsManager {
    private WarsManager() {
    }

    public static War declareWar(String name, double prize, List<Region> regions) {
        War war = new War(name);
        regions.forEach(war::addRegion);
        war.setPrize(prize);
        return war;
    }

    public static List<War> getAll() {
        return Homestead.warsCache.getAll();
    }

    public static War findWar(UUID id) {
        return WarsManager.getAll().stream().filter(w -> w.getUniqueId().equals(id)).findFirst().orElse(null);
    }

    public static War findWar(String name) {
        return WarsManager.getAll().stream().filter(w -> w.getName().equals(name)).findFirst().orElse(null);
    }

    public static War findWarByRegionId(UUID regionId) {
        return WarsManager.getAll().stream().filter(w -> w.getRegions().stream().anyMatch(r -> r.getUniqueId().equals(regionId))).findFirst().orElse(null);
    }

    public static void endWar(UUID id) {
        War war = WarsManager.findWar(id);
        if (war != null) {
            Homestead.warsCache.remove(war.getUniqueId());
        }
    }

    public static List<OfflinePlayer> getMembersOfWar(UUID warId) {
        War war = WarsManager.findWar(warId);
        if (war == null || war.getRegions().size() < 2) {
            return Collections.emptyList();
        }
        Region first = war.getRegions().get(0);
        Region second = war.getRegions().get(1);
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        first.getMembers().forEach(m4 -> players.add(m4.getBukkitOfflinePlayer()));
        second.getMembers().forEach(m4 -> players.add(m4.getBukkitOfflinePlayer()));
        players.add(first.getOwner());
        players.add(second.getOwner());
        return new ArrayList<OfflinePlayer>(players);
    }

    public static boolean isPlayerInWar(OfflinePlayer player) {
        return WarsManager.getAll().stream().anyMatch(war -> WarsManager.getMembersOfWar(war.getUniqueId()).contains(player));
    }

    public static War surrenderRegionFromFirstWarFound(UUID regionId) {
        for (War war : WarsManager.getAll()) {
            for (Region region : war.getRegions()) {
                if (!region.getUniqueId().equals(regionId)) continue;
                war.removeRegion(region);
                return war;
            }
        }
        return null;
    }

    public static boolean isNameUsed(String name) {
        return WarsManager.getAll().stream().anyMatch(w -> w.getName().equalsIgnoreCase(name));
    }

    public static boolean isRegionInWar(UUID regionId) {
        return WarsManager.getAll().stream().anyMatch(w -> w.getRegions().stream().anyMatch(r -> r.getUniqueId().equals(regionId)));
    }

    public static void cleanStartup() {
        Logger.warning("Cleaning up wars data...");
        int updated = 0;
        for (War war : Homestead.warsCache.getAll()) {
            if (war.getRegions().size() >= 2) continue;
            WarsManager.endWar(war.getUniqueId());
            ++updated;
        }
        if (updated == 0) {
            Logger.info("No data corruption was found!");
        } else {
            Logger.info(updated + " updates have been applied to wars data.");
        }
    }
}

