/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;

public final class SubAreasManager {
    private SubAreasManager() {
    }

    public static SubArea createSubArea(UUID regionId, String name, World world, Block point1, Block point2, long flags) {
        SubArea subArea = new SubArea(regionId, name, world, point1, point2, flags);
        Homestead.subAreasCache.putOrUpdate(subArea);
        return subArea;
    }

    public static List<SubArea> getAll() {
        return Homestead.subAreasCache.getAll();
    }

    public static List<SubArea> getSubAreasOfRegion(UUID regionId) {
        ArrayList<SubArea> subAreas = new ArrayList<SubArea>();
        for (SubArea area : SubAreasManager.getAll()) {
            if (!area.getRegionId().equals(regionId)) continue;
            subAreas.add(area);
        }
        return subAreas;
    }

    public static SubArea findSubArea(UUID id) {
        for (SubArea area : SubAreasManager.getAll()) {
            if (!area.getUniqueId().equals(id)) continue;
            return area;
        }
        return null;
    }

    public static SubArea findSubArea(UUID regionId, String name) {
        for (SubArea area : SubAreasManager.getSubAreasOfRegion(regionId)) {
            if (!area.getName().equals(name)) continue;
            return area;
        }
        return null;
    }

    public static SubArea findSubAreaHasBlockInside(Block block) {
        return SubAreasManager.findSubAreaHasLocationInside(block.getLocation());
    }

    public static SubArea findSubAreaHasLocationInside(Location location) {
        for (SubArea subArea : SubAreasManager.getAll()) {
            if (!subArea.isLocationInside(location)) continue;
            return subArea;
        }
        return null;
    }

    public static void deleteSubArea(UUID id) {
        SubArea subArea = SubAreasManager.findSubArea(id);
        if (subArea == null) {
            return;
        }
        Homestead.subAreasCache.remove(id);
    }

    public static boolean isNameUsed(UUID regionId, String name) {
        for (SubArea area : SubAreasManager.getSubAreasOfRegion(regionId)) {
            if (!area.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void cleanStartup() {
        Logger.warning("Cleaning up sub-areas data...");
        int updated = 0;
        for (SubArea subArea : Homestead.subAreasCache.getAll()) {
            World world = subArea.getWorld();
            if (world == null) {
                SubAreasManager.deleteSubArea(subArea.getUniqueId());
                ++updated;
                continue;
            }
            if (RegionsManager.findRegion(subArea.getRegionId()) == null) {
                SubAreasManager.deleteSubArea(subArea.getUniqueId());
                ++updated;
                continue;
            }
            for (SerializableMember member : subArea.getMembers()) {
                if (member.getBukkitOfflinePlayer() != null) continue;
                subArea.removeMember(member);
                ++updated;
            }
        }
        if (updated == 0) {
            Logger.info("No data corruption was found!");
        } else {
            Logger.info(updated + " updates have been applied to sub-areas data.");
        }
    }
}

