/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.PlayerInfoMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaMemberPlayerFlagsMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaSettingsMenu;
import tfagaming.projects.minecraft.homestead.sessions.playerinput.PlayerInputSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class SubAreaMembersMenu {
    List<SerializableMember> members;

    public SubAreaMembersMenu(Player player, Region region, SubArea subArea) {
        this.members = subArea.getMembers();
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(24), 36, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player, region, subArea), (_player, event) -> new SubAreaSettingsMenu(player, region, subArea), (_player, context) -> {
            if (context.getIndex() >= this.members.size()) {
                return;
            }
            SerializableMember member = this.members.get(context.getIndex());
            if (context.getEvent().isShiftClick() && context.getEvent().isRightClick()) {
                new PlayerInfoMenu(player, member.getBukkitOfflinePlayer(), () -> new SubAreaMembersMenu(player, region, subArea));
            } else if (context.getEvent().isShiftClick() && context.getEvent().isLeftClick()) {
                if (region.isPlayerMember(member.getBukkitOfflinePlayer()) && subArea.isPlayerMember(member.getBukkitOfflinePlayer())) {
                    if (!player.hasPermission("homestead.region.subareas.players")) {
                        PlayerUtils.sendMessage(player, 8);
                        return;
                    }
                    if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                        return;
                    }
                    subArea.removeMember(member.getBukkitOfflinePlayer());
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{player}", member.getBukkitOfflinePlayer().getName());
                    replacements.put("{subarea}", subArea.getName());
                    PlayerUtils.sendMessage(player, 173, replacements);
                    PaginationMenu instance = context.getInstance();
                    this.members = subArea.getMembers();
                    instance.setItems(this.getItems(player, region, subArea));
                }
            } else if (context.getEvent().isLeftClick()) {
                if (!player.hasPermission("homestead.region.subareas.players")) {
                    PlayerUtils.sendMessage(player, 8);
                    return;
                }
                new SubAreaMemberPlayerFlagsMenu(player, region, subArea, member);
            }
        });
        gui.addActionButton(1, MenuUtils.getButton(68, new OfflinePlayer[0]), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.players")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                OfflinePlayer targetPlayer = Homestead.getInstance().getOfflinePlayerSync((String)input);
                subArea.addMember(targetPlayer);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{subarea}", subArea.getName());
                replacements.put("{player}", targetPlayer.getName());
                PlayerUtils.sendMessage(player, 172, replacements);
                Homestead.getInstance().runSyncTask(() -> new SubAreaMembersMenu(player, region, subArea));
            }, (Function<String, Boolean>)((Function)message -> {
                OfflinePlayer target = Homestead.getInstance().getOfflinePlayerSync((String)message);
                if (target == null) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", (String)message);
                    PlayerUtils.sendMessage(player, 29, replacements);
                    return false;
                }
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                    return false;
                }
                if (region.isOwner(target)) {
                    PlayerUtils.sendMessage(player, 30);
                    return false;
                }
                if (!region.isPlayerMember(target)) {
                    PlayerUtils.sendMessage(player, 171);
                    return false;
                }
                if (subArea.isPlayerMember(target)) {
                    PlayerUtils.sendMessage(player, 174);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new SubAreaMembersMenu(player, region, subArea)), 75);
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player, Region region, SubArea subArea) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.members.size(); ++i) {
            SerializableMember member = this.members.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{subarea}", subArea.getName());
            replacements.put("{playername}", member.getBukkitOfflinePlayer().getName());
            items.add(MenuUtils.getButton(69, replacements, member.getBukkitOfflinePlayer()));
        }
        return items;
    }
}

