/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaMembersMenu;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class SubAreaMemberPlayerFlagsMenu {
    private static final int BULK_INDEX = 0;
    private final HashSet<UUID> cooldowns = new HashSet();

    public SubAreaMemberPlayerFlagsMenu(Player player, Region region, SubArea subArea, SerializableMember member) {
        List<ItemStack> items = this.buildItemsList(member);
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(25).replace("{playername}", Objects.requireNonNull(member.getBukkitOfflinePlayer().getName())), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), items, (_player, event) -> new SubAreaMembersMenu(player, region, subArea), (_player, context) -> {
            if (this.cooldowns.contains(player.getUniqueId())) {
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                return;
            }
            int index = context.getIndex();
            if (index == 0) {
                long current;
                boolean enableAll = context.getEvent().isLeftClick();
                boolean disableAll = context.getEvent().isRightClick();
                if (!enableAll && !disableAll) {
                    return;
                }
                long newFlags = current = member.getFlags();
                int changed = 0;
                for (String flagString : PlayerFlags.getFlags()) {
                    if (Homestead.config.isFlagDisabled(flagString)) continue;
                    long flag = PlayerFlags.valueOf(flagString);
                    boolean isSet = FlagsCalculator.isFlagSet(newFlags, flag);
                    if (enableAll && !isSet) {
                        newFlags = FlagsCalculator.addFlag(newFlags, flag);
                        ++changed;
                        continue;
                    }
                    if (!disableAll || !isSet) continue;
                    newFlags = FlagsCalculator.removeFlag(newFlags, flag);
                    ++changed;
                }
                if (changed > 0) {
                    subArea.setMemberFlags(member, newFlags);
                    player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{changes}", String.valueOf(changed));
                    replacements.put("{new-value}", Formatters.getBoolean(enableAll));
                    PlayerUtils.sendMessage(player, 161, replacements);
                    PaginationMenu instance = context.getInstance();
                    instance.setItems(this.buildItemsList(member));
                    this.cooldowns.add(player.getUniqueId());
                    Homestead.getInstance().runAsyncTaskLater(() -> this.cooldowns.remove(player.getUniqueId()), 1);
                } else {
                    PlayerUtils.sendMessage(player, 162);
                }
                return;
            }
            int flagListIndex = index - 1;
            if (flagListIndex < 0 || flagListIndex >= PlayerFlags.getFlags().size()) {
                return;
            }
            String flagString = PlayerFlags.getFlags().get(flagListIndex);
            if (Homestead.config.isFlagDisabled(flagString)) {
                PlayerUtils.sendMessage(player, 42);
                return;
            }
            long flag = PlayerFlags.valueOf(flagString);
            if (context.getEvent().isLeftClick()) {
                PaginationMenu instance = context.getInstance();
                long flags = member.getFlags();
                boolean isSet = FlagsCalculator.isFlagSet(flags, flag);
                long newFlags = isSet ? FlagsCalculator.removeFlag(flags, flag) : FlagsCalculator.addFlag(flags, flag);
                subArea.setMemberFlags(member, newFlags);
                this.cooldowns.add(player.getUniqueId());
                player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", flagString);
                replacements.put("{state}", Formatters.getFlag(!isSet));
                replacements.put("{region}", region.getName());
                replacements.put("{subarea}", subArea.getName());
                replacements.put("{player}", member.getBukkitOfflinePlayer().getName());
                PlayerUtils.sendMessage(player, 169, replacements);
                instance.replaceSlot(index, MenuUtils.getFlagButton(flagString, !isSet));
                Homestead.getInstance().runAsyncTaskLater(() -> this.cooldowns.remove(player.getUniqueId()), 1);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    private List<ItemStack> buildItemsList(SerializableMember member) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack bulk = MenuUtils.getButton(65, new OfflinePlayer[0]);
        items.add(bulk);
        for (String flagString : PlayerFlags.getFlags()) {
            boolean value = FlagsCalculator.isFlagSet(member.getFlags(), PlayerFlags.valueOf(flagString));
            items.add(MenuUtils.getFlagButton(flagString, value));
        }
        return items;
    }
}

