/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database.providers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.structure.Level;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;

public class PostgreSQL {
    private static final String JDBC_URL = "jdbc:postgresql://";
    private final String TABLE_PREFIX;
    private final Connection connection;

    public PostgreSQL(String username, String password, String host, int port, String database, String tablePrefix) throws ClassNotFoundException, SQLException {
        this.TABLE_PREFIX = tablePrefix.replaceAll("[^A-Za-z0-9_]", "");
        Class.forName("org.postgresql.Driver");
        String connectionUrl = JDBC_URL + host + ":" + port + "/" + database;
        this.connection = DriverManager.getConnection(connectionUrl, username, password);
        Logger.info("PostgreSQL database connection established.");
        this.createTables();
        TableSyncer.apply(this.connection, this.TABLE_PREFIX);
    }

    private void createTables() throws SQLException {
        String sql1 = "CREATE TABLE IF NOT EXISTS " + this.TABLE_PREFIX + "regions (id UUID PRIMARY KEY, display_name TEXT NOT NULL, name TEXT NOT NULL, description TEXT NOT NULL, owner_id UUID NOT NULL, location TEXT, created_at BIGINT NOT NULL, player_flags BIGINT NOT NULL, world_flags BIGINT NOT NULL, bank DOUBLE PRECISION NOT NULL, map_color INTEGER NOT NULL, chunks TEXT[] NOT NULL, members TEXT[] NOT NULL, rates TEXT[] NOT NULL, invited_players UUID[] NOT NULL, banned_players TEXT[] NOT NULL, logs TEXT[] NOT NULL, rent TEXT, upkeep_at BIGINT NOT NULL, taxes_amount DOUBLE PRECISION NOT NULL, weather INTEGER NOT NULL, time INTEGER NOT NULL, welcome_sign TEXT,icon TEXT)";
        String sql2 = "CREATE TABLE IF NOT EXISTS " + this.TABLE_PREFIX + "wars (id UUID PRIMARY KEY, displayName TEXT NOT NULL, name TEXT NOT NULL, description TEXT NOT NULL, regions TEXT[] NOT NULL, prize DOUBLE PRECISION NOT NULL, started_at BIGINT NOT NULL)";
        String sql3 = "CREATE TABLE IF NOT EXISTS %ssubareas (\n    id         UUID PRIMARY KEY,\n    region_id  UUID NOT NULL,\n    name       TEXT NOT NULL,\n    world_name TEXT NOT NULL,\n    point1     TEXT NOT NULL,\n    point2     TEXT NOT NULL,\n    members    TEXT[] NOT NULL,\n    flags      BIGINT NOT NULL,\n    rent       TEXT,\n    created_at BIGINT NOT NULL\n)\n".formatted(this.TABLE_PREFIX);
        String sql4 = "CREATE TABLE IF NOT EXISTS %slevels (\n    id              UUID PRIMARY KEY,\n    region_id       UUID NOT NULL,\n    level           INTEGER NOT NULL,\n    experience      BIGINT NOT NULL,\n    total_experience BIGINT NOT NULL,\n    created_at      BIGINT NOT NULL\n)\n".formatted(this.TABLE_PREFIX);
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql1);
            stmt.executeUpdate(sql2);
            stmt.executeUpdate(sql3);
            stmt.executeUpdate(sql4);
        }
    }

    public void importRegions() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.regionsCache.clear();
            while (rs.next()) {
                String icon;
                UUID id = (UUID)rs.getObject("id");
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                OfflinePlayer owner = Homestead.getInstance().getOfflinePlayerSync((UUID)rs.getObject("owner_id"));
                SerializableLocation location = SerializableLocation.fromString(rs.getString("location"));
                long createdAt = rs.getLong("created_at");
                long playerFlags = rs.getLong("player_flags");
                long worldFlags = rs.getLong("world_flags");
                double bank = rs.getDouble("bank");
                int mapColor = rs.getInt("map_color");
                List<SerializableChunk> chunks = Arrays.stream((String[])rs.getArray("chunks").getArray()).map(SerializableChunk::fromString).collect(Collectors.toList());
                List<SerializableMember> members = Arrays.stream((String[])rs.getArray("members").getArray()).map(SerializableMember::fromString).collect(Collectors.toList());
                List<SerializableRate> rates = Arrays.stream((String[])rs.getArray("rates").getArray()).map(SerializableRate::fromString).collect(Collectors.toList());
                List invitedPlayers = Arrays.stream((UUID[])rs.getArray("invited_players").getArray()).map(uuid -> Homestead.getInstance().getOfflinePlayerSync((UUID)uuid)).collect(Collectors.toList());
                List<SerializableBannedPlayer> bannedPlayers = Arrays.stream((String[])rs.getArray("banned_players").getArray()).map(SerializableBannedPlayer::fromString).collect(Collectors.toList());
                List<SerializableLog> logs = Arrays.stream((String[])rs.getArray("logs").getArray()).map(SerializableLog::fromString).collect(Collectors.toList());
                SerializableRent rent = rs.getString("rent") != null ? SerializableRent.fromString(rs.getString("rent")) : null;
                long upkeepAt = rs.getLong("upkeep_at");
                double taxesAmount = rs.getDouble("taxes_amount");
                int weather = rs.getInt("weather");
                int time = rs.getInt("time");
                SerializableLocation welcomeSign = rs.getString("welcome_sign") != null ? SerializableLocation.fromString(rs.getString("welcome_sign")) : null;
                String string = icon = rs.getString("icon") == null ? null : rs.getString("icon");
                if (owner == null) continue;
                Region region = new Region(name, owner);
                region.id = id;
                region.displayName = displayName;
                region.description = description;
                region.location = location;
                region.createdAt = createdAt;
                region.playerFlags = playerFlags;
                region.worldFlags = worldFlags;
                region.bank = bank;
                region.mapColor = mapColor;
                region.setChunks(chunks);
                region.setMembers(members);
                region.setRates(rates);
                region.setInvitedPlayers(ListUtils.removeNullElements(invitedPlayers));
                region.setBannedPlayers(bannedPlayers);
                region.setLogs(logs);
                region.rent = rent;
                region.upkeepAt = upkeepAt;
                region.taxesAmount = taxesAmount;
                region.weather = weather;
                region.time = time;
                region.welcomeSign = welcomeSign;
                region.icon = icon;
                Homestead.regionsCache.putOrUpdate(region);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.regionsCache.size() + " regions.");
    }

    public void importWars() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.warsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("displayName");
                String name = rs.getString("name");
                String description = rs.getString("description");
                List<UUID> regions = Arrays.stream((String[])rs.getArray("regions").getArray()).map(UUID::fromString).collect(Collectors.toList());
                double prize = rs.getDouble("prize");
                long startedAt = rs.getLong("started_at");
                War war = new War(name, regions);
                war.id = id;
                war.displayName = displayName;
                war.description = description;
                war.prize = prize;
                war.startedAt = startedAt;
                Homestead.warsCache.putOrUpdate(war);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.warsCache.size() + " wars.");
    }

    public void importSubAreas() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "subareas";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.subAreasCache.clear();
            while (rs.next()) {
                UUID id = (UUID)rs.getObject("id");
                UUID regionId = (UUID)rs.getObject("region_id");
                String name = rs.getString("name");
                World world = Bukkit.getWorld((String)rs.getString("world_name"));
                if (world == null) continue;
                Block point1 = SubArea.parseBlockLocation(world, rs.getString("point1"));
                Block point2 = SubArea.parseBlockLocation(world, rs.getString("point2"));
                List<SerializableMember> members = Arrays.stream((String[])rs.getArray("members").getArray()).map(SerializableMember::fromString).collect(Collectors.toList());
                long flags = rs.getLong("flags");
                SerializableRent rent = SerializableRent.fromString(rs.getString("rent"));
                long createdAt = rs.getLong("created_at");
                SubArea subArea = new SubArea(id, regionId, name, world.getName(), point1, point2, members, flags, rent, createdAt);
                Homestead.subAreasCache.putOrUpdate(subArea);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.subAreasCache.size() + " sub-areas from PostgreSQL.");
    }

    public void importLevels() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "levels";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.levelsCache.clear();
            while (rs.next()) {
                UUID id = (UUID)rs.getObject("id");
                UUID regionId = (UUID)rs.getObject("region_id");
                int level = rs.getInt("level");
                long xp = rs.getLong("experience");
                long totalXp = rs.getLong("total_experience");
                long createdAt = rs.getLong("created_at");
                Level lvl = new Level(id, regionId, level, xp, totalXp, createdAt);
                Homestead.levelsCache.putOrUpdate(lvl);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.levelsCache.size() + " levels.");
    }

    public void exportRegions() {
        HashSet<UUID> dbRegionIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbRegionIds.add((UUID)rs.getObject("id"));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO " + this.TABLE_PREFIX + "regions (id, display_name, name, description, owner_id, location, created_at, player_flags, world_flags, bank, map_color, chunks, members, rates, invited_players, banned_players, logs, rent, upkeep_at, taxes_amount, weather, time, welcome_sign, icon) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT (id) DO UPDATE SET display_name = EXCLUDED.display_name, name = EXCLUDED.name, description = EXCLUDED.description, owner_id = EXCLUDED.owner_id, location = EXCLUDED.location, created_at = EXCLUDED.created_at, player_flags = EXCLUDED.player_flags, world_flags = EXCLUDED.world_flags, bank = EXCLUDED.bank, map_color = EXCLUDED.map_color, chunks = EXCLUDED.chunks, members = EXCLUDED.members, rates = EXCLUDED.rates, invited_players = EXCLUDED.invited_players, banned_players = EXCLUDED.banned_players, logs = EXCLUDED.logs, rent = EXCLUDED.rent, upkeep_at = EXCLUDED.upkeep_at, taxes_amount = EXCLUDED.taxes_amount, weather = EXCLUDED.weather, time = EXCLUDED.time, welcome_sign = EXCLUDED.welcome_sign,icon = EXCLUDED.icon";
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "regions WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheRegionIds = new HashSet<UUID>();
            for (Region region : Homestead.regionsCache.getAll()) {
                UUID regionId = region.id;
                cacheRegionIds.add(regionId);
                Object[] chunksArray = (String[])region.chunks.stream().map(SerializableChunk::toString).toArray(String[]::new);
                Object[] membersArray = (String[])region.members.stream().map(SerializableMember::toString).toArray(String[]::new);
                Object[] ratesArray = (String[])region.rates.stream().map(SerializableRate::toString).toArray(String[]::new);
                Object[] invitedArray = (UUID[])region.getInvitedPlayers().stream().map(OfflinePlayer::getUniqueId).toArray(UUID[]::new);
                Object[] bannedArray = (String[])region.bannedPlayers.stream().map(SerializableBannedPlayer::toString).toArray(String[]::new);
                Object[] logsArray = (String[])region.logs.stream().map(SerializableLog::toString).toArray(String[]::new);
                upsertStmt.setObject(1, regionId);
                upsertStmt.setString(2, region.displayName);
                upsertStmt.setString(3, region.name);
                upsertStmt.setString(4, region.description);
                upsertStmt.setObject(5, region.getOwnerId());
                upsertStmt.setString(6, region.location != null ? region.location.toString() : null);
                upsertStmt.setLong(7, region.createdAt);
                upsertStmt.setLong(8, region.playerFlags);
                upsertStmt.setLong(9, region.worldFlags);
                upsertStmt.setDouble(10, region.bank);
                upsertStmt.setInt(11, region.mapColor);
                upsertStmt.setArray(12, this.connection.createArrayOf("text", chunksArray));
                upsertStmt.setArray(13, this.connection.createArrayOf("text", membersArray));
                upsertStmt.setArray(14, this.connection.createArrayOf("text", ratesArray));
                upsertStmt.setArray(15, this.connection.createArrayOf("uuid", invitedArray));
                upsertStmt.setArray(16, this.connection.createArrayOf("text", bannedArray));
                upsertStmt.setArray(17, this.connection.createArrayOf("text", logsArray));
                upsertStmt.setString(18, region.rent != null ? region.rent.toString() : null);
                upsertStmt.setLong(19, region.upkeepAt);
                upsertStmt.setDouble(20, region.taxesAmount);
                upsertStmt.setInt(21, region.weather);
                upsertStmt.setInt(22, region.time);
                upsertStmt.setString(23, region.welcomeSign != null ? region.welcomeSign.toString() : null);
                upsertStmt.setString(24, region.icon != null ? region.icon : null);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbRegionIds.removeAll(cacheRegionIds);
            for (UUID deletedId : dbRegionIds) {
                deleteStmt.setObject(1, deletedId);
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheRegionIds.size() + " regions and deleted " + dbRegionIds.size() + " regions.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void exportWars() {
        HashSet<UUID> dbWarIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbWarIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO " + this.TABLE_PREFIX + "wars (id, displayName, name, description, regions, prize, started_at) VALUES (?, ?, ?, ?, ?, ?, ?) ON CONFLICT (id) DO UPDATE SET displayName = EXCLUDED.displayName, name = EXCLUDED.name, description = EXCLUDED.description, regions = EXCLUDED.regions, prize = EXCLUDED.prize, started_at = EXCLUDED.started_at";
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "wars WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheWarIds = new HashSet<UUID>();
            for (War war : Homestead.warsCache.getAll()) {
                UUID warId = war.id;
                cacheWarIds.add(warId);
                String regionsStr = war.regions.stream().map(UUID::toString).collect(Collectors.joining("\u00a7"));
                upsertStmt.setString(1, warId.toString());
                upsertStmt.setString(2, war.displayName);
                upsertStmt.setString(3, war.name);
                upsertStmt.setString(4, war.description);
                upsertStmt.setString(5, regionsStr);
                upsertStmt.setDouble(6, war.prize);
                upsertStmt.setLong(7, war.startedAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbWarIds.removeAll(cacheWarIds);
            for (UUID deletedId : dbWarIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheWarIds.size() + " wars and deleted " + dbWarIds.size() + " wars.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void exportSubAreas() {
        HashSet<UUID> dbSubAreaIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "subareas";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbSubAreaIds.add((UUID)rs.getObject("id"));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO %ssubareas\n    (id, region_id, name, world_name, point1, point2, members, flags, rent, created_at)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT (id) DO UPDATE SET\n    region_id  = EXCLUDED.region_id,\n    name       = EXCLUDED.name,\n    world_name = EXCLUDED.world_name,\n    point1     = EXCLUDED.point1,\n    point2     = EXCLUDED.point2,\n    members    = EXCLUDED.members,\n    flags      = EXCLUDED.flags,\n    rent       = EXCLUDED.rent,\n    created_at = EXCLUDED.created_at\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "subareas WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheSubAreaIds = new HashSet<UUID>();
            for (SubArea subArea : Homestead.subAreasCache.getAll()) {
                UUID subAreaId = subArea.id;
                cacheSubAreaIds.add(subAreaId);
                Object[] membersArray = (String[])subArea.members.stream().map(SerializableMember::toString).toArray(String[]::new);
                upsertStmt.setObject(1, subAreaId);
                upsertStmt.setObject(2, subArea.regionId);
                upsertStmt.setString(3, subArea.name);
                upsertStmt.setString(4, subArea.worldName);
                upsertStmt.setString(5, SubArea.toStringBlockLocation(subArea.getWorld(), subArea.point1));
                upsertStmt.setString(6, SubArea.toStringBlockLocation(subArea.getWorld(), subArea.point2));
                upsertStmt.setArray(7, this.connection.createArrayOf("text", membersArray));
                upsertStmt.setLong(8, subArea.flags);
                upsertStmt.setString(9, subArea.rent != null ? subArea.rent.toString() : null);
                upsertStmt.setLong(10, subArea.createdAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbSubAreaIds.removeAll(cacheSubAreaIds);
            for (UUID deletedId : dbSubAreaIds) {
                deleteStmt.setObject(1, deletedId);
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheSubAreaIds.size() + " sub-areas and deleted " + dbSubAreaIds.size() + " sub-areas.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void exportLevels() {
        HashSet<UUID> dbIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "levels";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbIds.add((UUID)rs.getObject("id"));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO %slevels\n    (id, region_id, level, experience, total_experience, created_at)\nVALUES (?, ?, ?, ?, ?, ?)\nON CONFLICT (id) DO UPDATE SET\n    region_id       = EXCLUDED.region_id,\n    level           = EXCLUDED.level,\n    experience      = EXCLUDED.experience,\n    total_experience = EXCLUDED.total_experience,\n    created_at      = EXCLUDED.created_at\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "levels WHERE id = ?";
        try (PreparedStatement upsert = this.connection.prepareStatement(upsertSql);
             PreparedStatement delete = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheIds = new HashSet<UUID>();
            for (Level lvl : Homestead.levelsCache.getAll()) {
                UUID lvlId = lvl.getUniqueId();
                cacheIds.add(lvlId);
                upsert.setObject(1, lvlId);
                upsert.setObject(2, lvl.getRegionId());
                upsert.setInt(3, lvl.getLevel());
                upsert.setLong(4, lvl.getExperience());
                upsert.setLong(5, lvl.getTotalExperience());
                upsert.setLong(6, lvl.getCreatedAt());
                upsert.addBatch();
            }
            upsert.executeBatch();
            dbIds.removeAll(cacheIds);
            for (UUID deletedId : dbIds) {
                delete.setObject(1, deletedId);
                delete.addBatch();
            }
            delete.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheIds.size() + " levels and deleted " + dbIds.size() + " levels.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Logger.warning("PostgreSQL connection has been closed.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public long getLatency() {
        long before = System.currentTimeMillis();
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "regions";
        int count = 0;
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                ++count;
            }
        }
        catch (SQLException e) {
            return -1L;
        }
        long after = System.currentTimeMillis();
        return after - before;
    }

    public static final class TableSyncer {
        public static void syncTable(Connection conn, String tableName, List<String> wantedCols, Map<String, String> colDef) throws SQLException {
            LinkedHashSet<String> wanted = new LinkedHashSet<String>(wantedCols);
            Set<String> real = TableSyncer.getRealColumns(conn, tableName);
            Logger.warning("Synchronizing columns... This might take a while.");
            for (String existing : real) {
                if (wanted.contains(existing)) continue;
                String sql = "ALTER TABLE \"" + tableName + "\" DROP COLUMN IF EXISTS \"" + existing + "\"";
                Statement st = conn.createStatement();
                try {
                    st.execute(sql);
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
            for (String col : wanted) {
                if (real.contains(col)) continue;
                String def = colDef.get(col);
                if (def == null) {
                    throw new IllegalArgumentException("No definition for column " + col);
                }
                String sql = "ALTER TABLE \"" + tableName + "\" ADD COLUMN \"" + col + "\" " + def;
                Statement st = conn.createStatement();
                try {
                    st.execute(sql);
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
            Logger.info("Synchronization done!");
        }

        private static Set<String> getRealColumns(Connection conn, String table) throws SQLException {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            String sql = "SELECT column_name FROM information_schema.columns WHERE table_schema = current_schema() AND table_name = ? ORDER BY ordinal_position";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, table);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        set.add(rs.getString(1));
                    }
                }
            }
            return set;
        }

        public static void apply(Connection conn, String prefix) throws SQLException {
            String table = prefix + "regions";
            List<String> wanted = Arrays.asList("id", "display_name", "name", "description", "owner_id", "location", "created_at", "player_flags", "world_flags", "bank", "map_color", "chunks", "members", "rates", "invited_players", "banned_players", "logs", "rent", "upkeep_at", "taxes_amount", "weather", "time", "welcome_sign", "icon");
            HashMap<String, String> def = new HashMap<String, String>();
            def.put("id", "UUID PRIMARY KEY");
            def.put("display_name", "TEXT NOT NULL");
            def.put("name", "TEXT NOT NULL");
            def.put("description", "TEXT NOT NULL");
            def.put("owner_id", "UUID NOT NULL");
            def.put("location", "TEXT");
            def.put("created_at", "BIGINT NOT NULL");
            def.put("player_flags", "BIGINT NOT NULL");
            def.put("world_flags", "BIGINT NOT NULL");
            def.put("bank", "DOUBLE PRECISION NOT NULL");
            def.put("map_color", "INTEGER NOT NULL");
            def.put("chunks", "TEXT[] NOT NULL");
            def.put("members", "TEXT[] NOT NULL");
            def.put("rates", "TEXT[] NOT NULL");
            def.put("invited_players", "UUID[] NOT NULL");
            def.put("banned_players", "TEXT[] NOT NULL");
            def.put("logs", "TEXT[] NOT NULL");
            def.put("rent", "TEXT");
            def.put("upkeep_at", "BIGINT NOT NULL");
            def.put("taxes_amount", "DOUBLE PRECISION NOT NULL");
            def.put("weather", "INTEGER NOT NULL");
            def.put("time", "INTEGER NOT NULL");
            def.put("welcome_sign", "TEXT");
            def.put("icon", "TEXT");
            TableSyncer.syncTable(conn, table, wanted, def);
        }
    }
}

