/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database.providers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.structure.Level;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.SubArea;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;

public class MariaDB {
    private static final String JDBC_URL = "jdbc:mariadb://";
    private final String TABLE_PREFIX;
    private final Connection connection;

    public MariaDB(String username, String password, String host, int port, String database, String tablePrefix) throws ClassNotFoundException, SQLException {
        this.TABLE_PREFIX = tablePrefix.replaceAll("[^A-Za-z0-9_]", "");
        Class.forName("org.mariadb.jdbc.Driver");
        String connectionUrl = JDBC_URL + host + ":" + port + "/" + database + "?allowPublicKeyRetrieval=true&useSSL=false&serverTimezone=UTC";
        this.connection = DriverManager.getConnection(connectionUrl, username, password);
        Logger.info("MariaDB database connection established.");
        this.createTables();
        TableSyncer.apply(this.connection, this.TABLE_PREFIX);
    }

    private void createTables() throws SQLException {
        String sql1 = "    CREATE TABLE IF NOT EXISTS `%sregions` (\n        id              CHAR(36) PRIMARY KEY,\n        display_name    TEXT NOT NULL,\n        name            TEXT NOT NULL,\n        description     TEXT NOT NULL,\n        owner_id        CHAR(36) NOT NULL,\n        location        TEXT,\n        created_at      BIGINT NOT NULL,\n        player_flags    BIGINT NOT NULL,\n        world_flags     BIGINT NOT NULL,\n        bank            DOUBLE PRECISION NOT NULL,\n        map_color       INT NOT NULL,\n        chunks          TEXT NOT NULL,\n        members         TEXT NOT NULL,\n        rates           TEXT NOT NULL,\n        invited_players TEXT NOT NULL,\n        banned_players  TEXT NOT NULL,\n        logs            TEXT NOT NULL,\n        rent            TEXT,\n        upkeep_at       BIGINT NOT NULL,\n        taxes_amount    DOUBLE NOT NULL,\n        weather         INT NOT NULL,\n        time            INT NOT NULL,\n        welcome_sign    TEXT,\n        icon            TEXT\n    )\n".formatted(this.TABLE_PREFIX);
        String sql2 = "CREATE TABLE IF NOT EXISTS `%swars` (\n    id          CHAR(36) PRIMARY KEY,\n    display_name TEXT NOT NULL,\n    name        TEXT NOT NULL,\n    description TEXT NOT NULL,\n    regions     TEXT NOT NULL,\n    prize       DOUBLE PRECISION NOT NULL,\n    started_at  BIGINT NOT NULL\n)\n".formatted(this.TABLE_PREFIX);
        String sql3 = "CREATE TABLE IF NOT EXISTS `%ssubareas` (\n    id         CHAR(36) PRIMARY KEY,\n    region_id  CHAR(36) NOT NULL,\n    name       TEXT NOT NULL,\n    world_name TEXT NOT NULL,\n    point1     TEXT NOT NULL,\n    point2     TEXT NOT NULL,\n    members    TEXT NOT NULL,\n    flags      BIGINT NOT NULL,\n    rent       TEXT,\n    created_at BIGINT NOT NULL\n)\n".formatted(this.TABLE_PREFIX);
        String sql4 = "CREATE TABLE IF NOT EXISTS `%slevels` (\n    id              CHAR(36) PRIMARY KEY,\n    region_id       CHAR(36) NOT NULL,\n    level           INT NOT NULL,\n    experience      BIGINT NOT NULL,\n    total_experience BIGINT NOT NULL,\n    created_at      BIGINT NOT NULL\n)\n".formatted(this.TABLE_PREFIX);
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql1);
            stmt.executeUpdate(sql2);
            stmt.executeUpdate(sql3);
            stmt.executeUpdate(sql4);
        }
    }

    public void importRegions() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.regionsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                OfflinePlayer owner = Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(rs.getString("owner_id")));
                SerializableLocation location = Optional.ofNullable(rs.getString("location")).map(SerializableLocation::fromString).orElse(null);
                long createdAt = rs.getLong("created_at");
                long playerFlags = rs.getLong("player_flags");
                long worldFlags = rs.getLong("world_flags");
                double bank = rs.getDouble("bank");
                int mapColor = rs.getInt("map_color");
                ArrayList<SerializableChunk> chunks = !rs.getString("chunks").isEmpty() ? Arrays.stream(rs.getString("chunks").split("\u00a7")).map(SerializableChunk::fromString).collect(Collectors.toList()) : new ArrayList<SerializableChunk>();
                ArrayList<SerializableMember> members = !rs.getString("members").isEmpty() ? Arrays.stream(rs.getString("members").split("\u00a7")).map(SerializableMember::fromString).collect(Collectors.toList()) : new ArrayList<SerializableMember>();
                ArrayList<SerializableRate> rates = !rs.getString("rates").isEmpty() ? Arrays.stream(rs.getString("rates").split("\u00a7")).map(SerializableRate::fromString).collect(Collectors.toList()) : new ArrayList<SerializableRate>();
                ArrayList invitedPlayers = !rs.getString("invited_players").isEmpty() ? Arrays.stream(rs.getString("invited_players").split("\u00a7")).map(uuidString -> Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(uuidString))).collect(Collectors.toList()) : new ArrayList();
                ArrayList<SerializableBannedPlayer> bannedPlayers = !rs.getString("banned_players").isEmpty() ? Arrays.stream(rs.getString("banned_players").split("\u00a7")).map(SerializableBannedPlayer::fromString).collect(Collectors.toList()) : new ArrayList<SerializableBannedPlayer>();
                ArrayList<SerializableLog> logs = !rs.getString("logs").isEmpty() ? Arrays.stream(rs.getString("logs").split("\u00b5")).map(SerializableLog::fromString).collect(Collectors.toList()) : new ArrayList<SerializableLog>();
                SerializableRent rent = SerializableRent.fromString(rs.getString("rent"));
                long upkeepAt = rs.getLong("upkeep_at");
                double taxesAmount = rs.getDouble("taxes_amount");
                int weather = rs.getInt("weather");
                int time = rs.getInt("time");
                SerializableLocation welcomeSign = Optional.ofNullable(rs.getString("welcome_sign")).map(SerializableLocation::fromString).orElse(null);
                String icon = rs.getString("icon");
                if (owner == null) continue;
                Region region = new Region(name, owner);
                region.id = id;
                region.displayName = displayName;
                region.description = description;
                region.location = location;
                region.createdAt = createdAt;
                region.playerFlags = playerFlags;
                region.worldFlags = worldFlags;
                region.bank = bank;
                region.mapColor = mapColor;
                region.setChunks(chunks);
                region.setMembers(members);
                region.setRates(rates);
                region.setInvitedPlayers(ListUtils.removeNullElements(invitedPlayers));
                region.setBannedPlayers(bannedPlayers);
                region.setLogs(logs);
                region.rent = rent;
                region.upkeepAt = upkeepAt;
                region.taxesAmount = taxesAmount;
                region.weather = weather;
                region.time = time;
                region.welcomeSign = welcomeSign;
                region.icon = icon;
                Homestead.regionsCache.putOrUpdate(region);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.regionsCache.size() + " regions from MariaDB.");
    }

    public void importWars() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.warsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                ArrayList<UUID> regions = !rs.getString("regions").isEmpty() ? Arrays.stream(rs.getString("regions").split("\u00a7")).map(UUID::fromString).collect(Collectors.toList()) : new ArrayList<UUID>();
                double prize = rs.getDouble("prize");
                long startedAt = rs.getLong("started_at");
                War war = new War(name, regions);
                war.id = id;
                war.displayName = displayName;
                war.description = description;
                war.prize = prize;
                war.startedAt = startedAt;
                Homestead.warsCache.putOrUpdate(war);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.warsCache.size() + " wars from MariaDB.");
    }

    public void importSubAreas() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "subareas";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.subAreasCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                UUID regionId = UUID.fromString(rs.getString("region_id"));
                String name = rs.getString("name");
                World world = Bukkit.getWorld((String)rs.getString("world_name"));
                if (world == null) continue;
                Block point1 = SubArea.parseBlockLocation(world, rs.getString("point1"));
                Block point2 = SubArea.parseBlockLocation(world, rs.getString("point2"));
                ArrayList<SerializableMember> members = !rs.getString("members").isEmpty() ? Arrays.stream(rs.getString("members").split("\u00a7")).map(SerializableMember::fromString).collect(Collectors.toList()) : new ArrayList<SerializableMember>();
                long flags = rs.getLong("flags");
                SerializableRent rent = rs.getString("rent") != null ? SerializableRent.fromString(rs.getString("rent")) : null;
                long createdAt = rs.getLong("created_at");
                SubArea subArea = new SubArea(id, regionId, name, world.getName(), point1, point2, members, flags, rent, createdAt);
                Homestead.subAreasCache.putOrUpdate(subArea);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.subAreasCache.size() + " sub-areas.");
    }

    public void importLevels() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "levels";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.levelsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                UUID regionId = UUID.fromString(rs.getString("region_id"));
                int level = rs.getInt("level");
                long xp = rs.getLong("experience");
                long totalXp = rs.getLong("total_experience");
                long createdAt = rs.getLong("created_at");
                Level lvl = new Level(id, regionId, level, xp, totalXp, createdAt);
                Homestead.levelsCache.putOrUpdate(lvl);
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        Logger.info("Imported " + Homestead.levelsCache.size() + " levels.");
    }

    public void exportRegions() {
        HashSet<UUID> dbRegionIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbRegionIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "    INSERT INTO `%sregions` (\n        id, display_name, name, description, owner_id, location, created_at,\n        player_flags, world_flags, bank, map_color, chunks, members, rates,\n        invited_players, banned_players, logs, rent, upkeep_at,\n        taxes_amount, weather, time, welcome_sign, icon\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        display_name = VALUES(display_name),\n        name = VALUES(name),\n        description = VALUES(description),\n        owner_id = VALUES(owner_id),\n        location = VALUES(location),\n        created_at = VALUES(created_at),\n        player_flags = VALUES(player_flags),\n        world_flags = VALUES(world_flags),\n        bank = VALUES(bank),\n        map_color = VALUES(map_color),\n        chunks = VALUES(chunks),\n        members = VALUES(members),\n        rates = VALUES(rates),\n        invited_players = VALUES(invited_players),\n        banned_players = VALUES(banned_players),\n        logs = VALUES(logs),\n        rent = VALUES(rent),\n        upkeep_at = VALUES(upkeep_at),\n        taxes_amount = VALUES(taxes_amount),\n        weather = VALUES(weather),\n        time = VALUES(time),\n        welcome_sign = VALUES(welcome_sign),\n        icon = VALUES(icon)\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "regions WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheRegionIds = new HashSet<UUID>();
            for (Region region : Homestead.regionsCache.getAll()) {
                UUID regionId = region.id;
                cacheRegionIds.add(regionId);
                upsertStmt.setString(1, regionId.toString());
                upsertStmt.setString(2, region.displayName);
                upsertStmt.setString(3, region.name);
                upsertStmt.setString(4, region.description);
                upsertStmt.setString(5, region.getOwnerId().toString());
                upsertStmt.setString(6, region.location == null ? null : region.location.toString());
                upsertStmt.setLong(7, region.createdAt);
                upsertStmt.setLong(8, region.playerFlags);
                upsertStmt.setLong(9, region.worldFlags);
                upsertStmt.setDouble(10, region.bank);
                upsertStmt.setInt(11, region.mapColor);
                String chunksStr = String.join((CharSequence)"\u00a7", region.chunks.stream().map(SerializableChunk::toString).collect(Collectors.toList()));
                String membersStr = String.join((CharSequence)"\u00a7", region.members.stream().map(SerializableMember::toString).collect(Collectors.toList()));
                String ratesStr = String.join((CharSequence)"\u00a7", region.rates.stream().map(SerializableRate::toString).collect(Collectors.toList()));
                String invitedStr = String.join((CharSequence)"\u00a7", region.getInvitedPlayers().stream().map(OfflinePlayer::getUniqueId).map(UUID::toString).collect(Collectors.toList()));
                String bannedStr = String.join((CharSequence)"\u00a7", region.bannedPlayers.stream().map(SerializableBannedPlayer::toString).collect(Collectors.toList()));
                String logsStr = String.join((CharSequence)"\u00b5", region.logs.stream().map(SerializableLog::toString).collect(Collectors.toList()));
                upsertStmt.setString(12, chunksStr);
                upsertStmt.setString(13, membersStr);
                upsertStmt.setString(14, ratesStr);
                upsertStmt.setString(15, invitedStr);
                upsertStmt.setString(16, bannedStr);
                upsertStmt.setString(17, logsStr);
                upsertStmt.setString(18, region.rent == null ? null : region.rent.toString());
                upsertStmt.setLong(19, region.upkeepAt);
                upsertStmt.setDouble(20, region.taxesAmount);
                upsertStmt.setInt(21, region.weather);
                upsertStmt.setInt(22, region.time);
                upsertStmt.setString(23, region.welcomeSign == null ? null : region.welcomeSign.toString());
                upsertStmt.setString(24, region.icon);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbRegionIds.removeAll(cacheRegionIds);
            for (UUID deletedId : dbRegionIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheRegionIds.size() + " regions and deleted " + dbRegionIds.size() + " regions from MariaDB.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void exportWars() {
        HashSet<UUID> dbWarIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbWarIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO `%swars` (\n    id, display_name, name, description, regions, prize, started_at\n) VALUES (?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    display_name = VALUES(display_name),\n    name = VALUES(name),\n    description = VALUES(description),\n    regions = VALUES(regions),\n    prize = VALUES(prize),\n    started_at = VALUES(started_at)\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "wars WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheWarIds = new HashSet<UUID>();
            for (War war : Homestead.warsCache.getAll()) {
                UUID warId = war.id;
                cacheWarIds.add(warId);
                String regionsStr = String.join((CharSequence)"\u00a7", war.regions.stream().map(UUID::toString).collect(Collectors.toList()));
                upsertStmt.setString(1, warId.toString());
                upsertStmt.setString(2, war.displayName);
                upsertStmt.setString(3, war.name);
                upsertStmt.setString(4, war.description);
                upsertStmt.setString(5, regionsStr);
                upsertStmt.setDouble(6, war.prize);
                upsertStmt.setLong(7, war.startedAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbWarIds.removeAll(cacheWarIds);
            for (UUID deletedId : dbWarIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheWarIds.size() + " wars and deleted " + dbWarIds.size() + " wars from MariaDB.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void exportSubAreas() {
        HashSet<UUID> dbSubAreaIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "subareas";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbSubAreaIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO `%ssubareas`\n    (id, region_id, name, world_name, point1, point2, members, flags, rent, created_at)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    region_id  = VALUES(region_id),\n    name       = VALUES(name),\n    world_name = VALUES(world_name),\n    point1     = VALUES(point1),\n    point2     = VALUES(point2),\n    members    = VALUES(members),\n    flags      = VALUES(flags),\n    rent       = VALUES(rent),\n    created_at = VALUES(created_at)\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "subareas WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheSubAreaIds = new HashSet<UUID>();
            for (SubArea subArea : Homestead.subAreasCache.getAll()) {
                UUID subAreaId = subArea.id;
                cacheSubAreaIds.add(subAreaId);
                String membersStr = subArea.members.stream().map(SerializableMember::toString).collect(Collectors.joining("\u00a7"));
                upsertStmt.setString(1, subAreaId.toString());
                upsertStmt.setString(2, subArea.regionId.toString());
                upsertStmt.setString(3, subArea.name);
                upsertStmt.setString(4, subArea.worldName);
                upsertStmt.setString(5, SubArea.toStringBlockLocation(subArea.getWorld(), subArea.point1));
                upsertStmt.setString(6, SubArea.toStringBlockLocation(subArea.getWorld(), subArea.point2));
                upsertStmt.setString(7, membersStr);
                upsertStmt.setLong(8, subArea.flags);
                upsertStmt.setString(9, subArea.rent != null ? subArea.rent.toString() : null);
                upsertStmt.setLong(10, subArea.createdAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbSubAreaIds.removeAll(cacheSubAreaIds);
            for (UUID deletedId : dbSubAreaIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheSubAreaIds.size() + " sub-areas and deleted " + dbSubAreaIds.size() + " sub-areas.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void exportLevels() {
        HashSet<UUID> dbIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "levels";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
            return;
        }
        String upsertSql = "INSERT INTO `%slevels`\n    (id, region_id, level, experience, total_experience, created_at)\nVALUES (?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    region_id       = VALUES(region_id),\n    level           = VALUES(level),\n    experience      = VALUES(experience),\n    total_experience = VALUES(total_experience),\n    created_at      = VALUES(created_at)\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "levels WHERE id = ?";
        try (PreparedStatement upsert = this.connection.prepareStatement(upsertSql);
             PreparedStatement delete = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheIds = new HashSet<UUID>();
            for (Level lvl : Homestead.levelsCache.getAll()) {
                UUID lvlId = lvl.getUniqueId();
                cacheIds.add(lvlId);
                upsert.setString(1, lvlId.toString());
                upsert.setString(2, lvl.getRegionId().toString());
                upsert.setInt(3, lvl.getLevel());
                upsert.setLong(4, lvl.getExperience());
                upsert.setLong(5, lvl.getTotalExperience());
                upsert.setLong(6, lvl.getCreatedAt());
                upsert.addBatch();
            }
            upsert.executeBatch();
            dbIds.removeAll(cacheIds);
            for (UUID deletedId : dbIds) {
                delete.setString(1, deletedId.toString());
                delete.addBatch();
            }
            delete.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheIds.size() + " levels and deleted " + dbIds.size() + " levels.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Logger.warning("MariaDB connection has been closed.");
            }
        }
        catch (SQLException e) {
            Homestead.getInstance().endInstance(e);
        }
    }

    public long getLatency() {
        long before = System.currentTimeMillis();
        String sql = "SELECT 1 FROM `%sregions` LIMIT 1".formatted(this.TABLE_PREFIX);
        int count = 0;
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                ++count;
            }
        }
        catch (SQLException e) {
            return -1L;
        }
        return System.currentTimeMillis() - before;
    }

    public static final class TableSyncer {
        public static void syncTable(Connection conn, String tableName, List<String> wantedCols, Map<String, String> colDef) throws SQLException {
            LinkedHashSet<String> wanted = new LinkedHashSet<String>(wantedCols);
            Set<String> real = TableSyncer.getRealColumns(conn, tableName);
            Logger.warning("Synchronizing columns... This might take a while.");
            for (String col : real) {
                if (wanted.contains(col)) continue;
                String sql = "ALTER TABLE `" + tableName + "` DROP COLUMN `" + col + "`";
                Statement st = conn.createStatement();
                try {
                    st.execute(sql);
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
            for (String col : wanted) {
                if (real.contains(col)) continue;
                String def = colDef.get(col);
                if (def == null) {
                    throw new IllegalArgumentException("No definition for column " + col);
                }
                String sql = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + col + "` " + def;
                Statement st = conn.createStatement();
                try {
                    st.execute(sql);
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
            Logger.info("Synchronization done!");
        }

        private static Set<String> getRealColumns(Connection conn, String table) throws SQLException {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            String sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? ORDER BY ORDINAL_POSITION";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, table);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        set.add(rs.getString(1));
                    }
                }
            }
            return set;
        }

        public static void apply(Connection conn, String prefix) throws SQLException {
            List<String> wanted = Arrays.asList("id", "display_name", "name", "description", "owner_id", "location", "created_at", "player_flags", "world_flags", "bank", "map_color", "chunks", "members", "rates", "invited_players", "banned_players", "logs", "rent", "upkeep_at", "taxes_amount", "weather", "time", "welcome_sign", "icon");
            HashMap<String, String> def = new HashMap<String, String>();
            def.put("id", "CHAR(36) PRIMARY KEY");
            def.put("display_name", "TEXT NOT NULL");
            def.put("name", "TEXT NOT NULL");
            def.put("description", "TEXT NOT NULL");
            def.put("owner_id", "CHAR(36) NOT NULL");
            def.put("location", "TEXT");
            def.put("created_at", "BIGINT NOT NULL");
            def.put("player_flags", "BIGINT NOT NULL");
            def.put("world_flags", "BIGINT NOT NULL");
            def.put("bank", "DOUBLE PRECISION NOT NULL");
            def.put("map_color", "INT NOT NULL");
            def.put("chunks", "TEXT NOT NULL");
            def.put("members", "TEXT NOT NULL");
            def.put("rates", "TEXT NOT NULL");
            def.put("invited_players", "TEXT NOT NULL");
            def.put("banned_players", "TEXT NOT NULL");
            def.put("logs", "TEXT NOT NULL");
            def.put("rent", "TEXT");
            def.put("upkeep_at", "BIGINT NOT NULL");
            def.put("taxes_amount", "DOUBLE NOT NULL");
            def.put("weather", "INT NOT NULL");
            def.put("time", "INT NOT NULL");
            def.put("welcome_sign", "TEXT");
            def.put("icon", "TEXT");
            TableSyncer.syncTable(conn, prefix + "regions", wanted, def);
        }
    }
}

