/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands.subcommands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.commands.SubCommandBuilder;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionsWithWelcomeSignsMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.NumberUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation.DelayedTeleport;

public class VisitRegionSubCmd
extends SubCommandBuilder {
    public VisitRegionSubCmd() {
        super("visit");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You cannot use this command via the console.");
            return false;
        }
        Player player = (Player)sender;
        if (Homestead.config.isWelcomeSignEnabled()) {
            String indexInput;
            if (args.length < 2) {
                new RegionsWithWelcomeSignsMenu(player);
                return true;
            }
            String playerName = args[1];
            OfflinePlayer target = Homestead.getInstance().getOfflinePlayerSync(playerName);
            if (target == null) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{playername}", playerName);
                PlayerUtils.sendMessage(player, 29, replacements);
                return true;
            }
            String string = indexInput = args.length >= 3 ? args[2] : "0";
            if (!NumberUtils.isValidInteger(indexInput)) {
                PlayerUtils.sendMessage(player, 137);
                return true;
            }
            int index = Integer.parseInt(indexInput);
            List<Region> regions = RegionsManager.getRegionsOwnedByPlayer(target);
            ArrayList<Region> filteredRegions = new ArrayList<Region>();
            for (Region region : regions) {
                if (region.getWelcomeSign() == null) continue;
                filteredRegions.add(region);
            }
            if (filteredRegions.isEmpty()) {
                PlayerUtils.sendMessage(player, 137);
                return true;
            }
            if (index < 0 || index > filteredRegions.size() - 1) {
                PlayerUtils.sendMessage(player, 137);
                return true;
            }
            new DelayedTeleport(player, ((Region)filteredRegions.get(index)).getWelcomeSign().getBukkitLocation());
        } else {
            if (args.length < 2) {
                PlayerUtils.sendMessage(player, 0);
                return true;
            }
            String regionName = args[1];
            Region region = RegionsManager.findRegion(regionName);
            if (region == null) {
                PlayerUtils.sendMessage(player, 9);
                return false;
            }
            if (region.getLocation() == null) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 71, replacements);
                return true;
            }
            if (!(PlayerUtils.isOperator(player) || region.isOwner((OfflinePlayer)player) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x2000000L, true) && PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x4000000L, true))) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 131, replacements);
                return true;
            }
            new DelayedTeleport(player, region.getLocation().getBukkitLocation());
        }
        return true;
    }
}

