/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands.subcommands;

import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.commands.SubCommandBuilder;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.mergingregion.MergeRegionSession;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class MergeAcceptRegionSubCmd
extends SubCommandBuilder {
    public MergeAcceptRegionSubCmd() {
        super("mergeaccept");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You cannot use this command via the console.");
            return false;
        }
        Player player = (Player)sender;
        Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
        if (region == null) {
            PlayerUtils.sendMessage(player, 4);
            return true;
        }
        if (!MergeRegionSession.isToHaveRequest(region)) {
            PlayerUtils.sendMessage(player, 182);
            return true;
        }
        if (!PlayerUtils.isOperator(player) && !region.isOwner((OfflinePlayer)player)) {
            PlayerUtils.sendMessage(player, 30);
            return false;
        }
        Region from = RegionsManager.findRegion(MergeRegionSession.getFrom(region));
        if (from == null) {
            PlayerUtils.sendMessage(player, 182);
            return false;
        }
        RegionsManager.mergeRegions(from, region);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", from.getName());
        PlayerUtils.sendMessage(player, 183, replacements);
        return true;
    }
}

